/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.controller.ForwardingControllerListener;
import com.facebook.drawee.drawable.AutoRotateDrawable;
import com.facebook.drawee.drawable.RoundedColorDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.GenericDraweeView;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.postprocessors.IterativeBoxBlurPostProcessor;
import com.facebook.imagepipeline.request.BasePostprocessor;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.request.Postprocessor;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.modules.fresco.ReactNetworkImageRequest;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.FloatUtil;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.util.RNLog;
import com.facebook.react.views.image.GlobalImageLoadListener;
import com.facebook.react.views.image.ImageLoadEvent;
import com.facebook.react.views.image.ImageResizeMethod;
import com.facebook.react.views.image.ImageResizeMode;
import com.facebook.react.views.image.MultiPostprocessor;
import com.facebook.react.views.image.ReactImageDownloadListener;
import com.facebook.react.views.imagehelper.ImageSource;
import com.facebook.react.views.imagehelper.MultiSourceHelper;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.facebook.react.views.view.ReactViewBackgroundManager;
import com.facebook.yoga.YogaConstants;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 t2\u00020\u0001:\u0002tuB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0011H\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010\u001b2\u0006\u0010!\u001a\u00020\u0016H\u0002J\b\u0010D\u001a\u00020'H\u0002J\b\u0010E\u001a\u00020'H\u0016J\u0006\u0010F\u001a\u00020AJ\u0010\u0010G\u001a\u00020A2\u0006\u0010H\u001a\u00020\u001bH\u0002J\u0010\u0010I\u001a\u00020A2\u0006\u0010J\u001a\u00020'H\u0002J\u0010\u0010K\u001a\u00020A2\u0006\u0010L\u001a\u00020MH\u0016J(\u0010N\u001a\u00020A2\u0006\u0010O\u001a\u00020\f2\u0006\u0010P\u001a\u00020\f2\u0006\u0010Q\u001a\u00020\f2\u0006\u0010R\u001a\u00020\fH\u0014J\u0010\u0010S\u001a\u00020A2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010T\u001a\u00020A2\u0006\u0010U\u001a\u00020\u0013J\u000e\u0010V\u001a\u00020A2\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010W\u001a\u00020A2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010W\u001a\u00020A2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010X\u001a\u00020\fJ\u000e\u0010Y\u001a\u00020A2\u0006\u0010\u0014\u001a\u00020\u0013J\u0018\u0010Z\u001a\u00020A2\u000e\u0010[\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0007J\u0010\u0010\\\u001a\u00020A2\b\u0010]\u001a\u0004\u0018\u00010^J\u000e\u0010_\u001a\u00020A2\u0006\u0010`\u001a\u00020\fJ\u0010\u0010a\u001a\u00020A2\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0010\u0010b\u001a\u00020A2\b\u0010]\u001a\u0004\u0018\u00010^J\u000e\u0010c\u001a\u00020A2\u0006\u0010-\u001a\u00020\fJ\u000e\u0010d\u001a\u00020A2\u0006\u0010e\u001a\u00020'J\u000e\u0010f\u001a\u00020A2\u0006\u00101\u001a\u000202J\u000e\u0010g\u001a\u00020A2\u0006\u0010h\u001a\u00020\u0013J\u000e\u0010i\u001a\u00020A2\u0006\u00108\u001a\u000209J\u000e\u0010j\u001a\u00020A2\u0006\u0010k\u001a\u00020'J\u0010\u0010l\u001a\u00020A2\b\u0010:\u001a\u0004\u0018\u00010mJ\b\u0010n\u001a\u00020AH\u0002J\u000e\u0010o\u001a\u00020A2\u0006\u0010<\u001a\u00020=J\u0010\u0010p\u001a\u00020'2\u0006\u0010!\u001a\u00020\u0016H\u0002J\u0010\u0010q\u001a\u00020A2\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0012\u0010r\u001a\u00020A2\b\u0010s\u001a\u0004\u0018\u00010^H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0004\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\u0004\u0018\u0001058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u000e\u00108\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00160;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\b\u0018\u00010?R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lcom/facebook/react/views/image/ReactImageView;", "Lcom/facebook/drawee/view/GenericDraweeView;", "context", "Landroid/content/Context;", "draweeControllerBuilder", "Lcom/facebook/drawee/controller/AbstractDraweeControllerBuilder;", "globalImageLoadListener", "Lcom/facebook/react/views/image/GlobalImageLoadListener;", "callerContext", "", "(Landroid/content/Context;Lcom/facebook/drawee/controller/AbstractDraweeControllerBuilder;Lcom/facebook/react/views/image/GlobalImageLoadListener;Ljava/lang/Object;)V", "backgroundColor", "", "backgroundImageDrawable", "Lcom/facebook/drawee/drawable/RoundedColorDrawable;", "borderColor", "borderCornerRadii", "", "borderRadius", "", "borderWidth", "cachedImageSource", "Lcom/facebook/react/views/imagehelper/ImageSource;", "controllerForTesting", "Lcom/facebook/drawee/controller/ControllerListener;", "Lcom/facebook/imagepipeline/image/ImageInfo;", "defaultImageDrawable", "Landroid/graphics/drawable/Drawable;", "downloadListener", "Lcom/facebook/react/views/image/ReactImageDownloadListener;", "fadeDurationMs", "headers", "Lcom/facebook/react/bridge/ReadableMap;", "imageSource", "getImageSource$ReactAndroid_release", "()Lcom/facebook/react/views/imagehelper/ImageSource;", "setImageSource$ReactAndroid_release", "(Lcom/facebook/react/views/imagehelper/ImageSource;)V", "isDirty", "", "isTiled", "()Z", "iterativeBoxBlurPostProcessor", "Lcom/facebook/imagepipeline/postprocessors/IterativeBoxBlurPostProcessor;", "loadingImageDrawable", "overlayColor", "progressiveRenderingEnabled", "reactBackgroundManager", "Lcom/facebook/react/views/view/ReactViewBackgroundManager;", "resizeMethod", "Lcom/facebook/react/views/image/ImageResizeMethod;", "resizeMultiplier", "resizeOptions", "Lcom/facebook/imagepipeline/common/ResizeOptions;", "getResizeOptions", "()Lcom/facebook/imagepipeline/common/ResizeOptions;", "scaleType", "Lcom/facebook/drawee/drawable/ScalingUtils$ScaleType;", "sources", "", "tileMode", "Landroid/graphics/Shader$TileMode;", "tilePostprocessor", "Lcom/facebook/react/views/image/ReactImageView$TilePostprocessor;", "getCornerRadii", "", "computedCorners", "getDrawableIfUnsupported", "hasMultipleSources", "hasOverlappingRendering", "maybeUpdateView", "maybeUpdateViewFromDrawable", "drawable", "maybeUpdateViewFromRequest", "doResize", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "setBackgroundColor", "setBlurRadius", "blurRadius", "setBorderColor", "setBorderRadius", "position", "setBorderWidth", "setControllerListener", "controllerListener", "setDefaultSource", "name", "", "setFadeDuration", "durationMs", "setHeaders", "setLoadingIndicatorSource", "setOverlayColor", "setProgressiveRenderingEnabled", "enabled", "setResizeMethod", "setResizeMultiplier", "multiplier", "setScaleType", "setShouldNotifyLoadEvents", "shouldNotify", "setSource", "Lcom/facebook/react/bridge/ReadableArray;", "setSourceImage", "setTileMode", "shouldResize", "updateCallerContext", "warnImageSource", "uri", "Companion", "TilePostprocessor", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nReactImageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactImageView.kt\ncom/facebook/react/views/image/ReactImageView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,726:1\n1#2:727\n*E\n"})
public final class ReactImageView
extends GenericDraweeView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractDraweeControllerBuilder<?, ?, ?, ?> draweeControllerBuilder;
    @Nullable
    private final GlobalImageLoadListener globalImageLoadListener;
    @Nullable
    private Object callerContext;
    @NotNull
    private final List<ImageSource> sources;
    @Nullable
    private ImageSource imageSource;
    @Nullable
    private ImageSource cachedImageSource;
    @Nullable
    private Drawable defaultImageDrawable;
    @Nullable
    private Drawable loadingImageDrawable;
    @Nullable
    private RoundedColorDrawable backgroundImageDrawable;
    private int backgroundColor;
    private int borderColor;
    private int overlayColor;
    private float borderWidth;
    private float borderRadius;
    @Nullable
    private float[] borderCornerRadii;
    @NotNull
    private ScalingUtils.ScaleType scaleType;
    @NotNull
    private Shader.TileMode tileMode;
    private boolean isDirty;
    @Nullable
    private TilePostprocessor tilePostprocessor;
    @Nullable
    private IterativeBoxBlurPostProcessor iterativeBoxBlurPostProcessor;
    @Nullable
    private ReactImageDownloadListener<ImageInfo> downloadListener;
    @Nullable
    private ControllerListener<ImageInfo> controllerForTesting;
    private int fadeDurationMs;
    private boolean progressiveRenderingEnabled;
    @Nullable
    private ReadableMap headers;
    private float resizeMultiplier;
    @NotNull
    private final ReactViewBackgroundManager reactBackgroundManager;
    @NotNull
    private ImageResizeMethod resizeMethod;
    public static final int REMOTE_IMAGE_FADE_DURATION_MS = 300;
    @NotNull
    private static final float[] computedCornerRadii = new float[4];
    @NotNull
    private static final Matrix tileMatrix = new Matrix();

    public ReactImageView(@NotNull Context context, @NotNull AbstractDraweeControllerBuilder<?, ?, ?, ?> draweeControllerBuilder, @Nullable GlobalImageLoadListener globalImageLoadListener, @Nullable Object callerContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(draweeControllerBuilder, (String)"draweeControllerBuilder");
        super(context, ReactImageView.Companion.buildHierarchy(context));
        this.draweeControllerBuilder = draweeControllerBuilder;
        this.globalImageLoadListener = globalImageLoadListener;
        this.callerContext = callerContext;
        this.sources = new ArrayList();
        this.borderRadius = Float.NaN;
        this.scaleType = ImageResizeMode.defaultValue();
        this.tileMode = ImageResizeMode.defaultTileMode();
        this.fadeDurationMs = -1;
        this.resizeMultiplier = 1.0f;
        this.reactBackgroundManager = new ReactViewBackgroundManager((View)this);
        this.resizeMethod = ImageResizeMethod.AUTO;
        this.reactBackgroundManager.setOverflow("hidden");
        this.setLegacyVisibilityHandlingEnabled(true);
    }

    @Nullable
    public final ImageSource getImageSource$ReactAndroid_release() {
        return this.imageSource;
    }

    public final void setImageSource$ReactAndroid_release(@Nullable ImageSource imageSource) {
        this.imageSource = imageSource;
    }

    public final void updateCallerContext(@Nullable Object callerContext) {
        if (!Intrinsics.areEqual((Object)this.callerContext, (Object)callerContext)) {
            this.callerContext = callerContext;
            this.isDirty = true;
        }
    }

    public final void setShouldNotifyLoadEvents(boolean shouldNotify) {
        if (shouldNotify == (this.downloadListener != null)) {
            return;
        }
        if (!shouldNotify) {
            this.downloadListener = null;
        } else {
            Context context = this.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
            EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag((ReactContext)context, this.getId());
            this.downloadListener = new ReactImageDownloadListener<ImageInfo>(eventDispatcher, this){
                final /* synthetic */ EventDispatcher $eventDispatcher;
                final /* synthetic */ ReactImageView this$0;
                {
                    this.$eventDispatcher = $eventDispatcher;
                    this.this$0 = $receiver;
                }

                public void onProgressChange(int loaded, int total) {
                    if (this.$eventDispatcher == null || this.this$0.getImageSource$ReactAndroid_release() == null) {
                        return;
                    }
                    ImageSource imageSource = this.this$0.getImageSource$ReactAndroid_release();
                    this.$eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createProgressEvent(UIManagerHelper.getSurfaceId((View)this.this$0), this.this$0.getId(), imageSource != null ? imageSource.getSource() : null, loaded, total));
                }

                public void onSubmit(@NotNull String id2, @Nullable Object callerContext) {
                    Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                    if (this.$eventDispatcher == null) {
                        return;
                    }
                    this.$eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createLoadStartEvent(UIManagerHelper.getSurfaceId((View)this.this$0), this.this$0.getId()));
                }

                public void onFinalImageSet(@NotNull String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable animatable) {
                    Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                    if (imageInfo != null && this.this$0.getImageSource$ReactAndroid_release() != null && this.$eventDispatcher != null) {
                        ImageSource imageSource = this.this$0.getImageSource$ReactAndroid_release();
                        this.$eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createLoadEvent(UIManagerHelper.getSurfaceId((View)this.this$0), this.this$0.getId(), imageSource != null ? imageSource.getSource() : null, imageInfo.getWidth(), imageInfo.getHeight()));
                        this.$eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createLoadEndEvent(UIManagerHelper.getSurfaceId((View)this.this$0), this.this$0.getId()));
                    }
                }

                public void onFailure(@NotNull String id2, @NotNull Throwable throwable) {
                    Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    if (this.$eventDispatcher == null) {
                        return;
                    }
                    this.$eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createErrorEvent(UIManagerHelper.getSurfaceId((View)this.this$0), this.this$0.getId(), throwable));
                }
            };
        }
        this.isDirty = true;
    }

    public final void setBlurRadius(float blurRadius) {
        int pixelBlurRadius = (int)PixelUtil.INSTANCE.dpToPx(blurRadius) / 2;
        this.iterativeBoxBlurPostProcessor = pixelBlurRadius == 0 ? null : new IterativeBoxBlurPostProcessor(2, pixelBlurRadius);
        this.isDirty = true;
    }

    public void setBackgroundColor(int backgroundColor) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.setBackgroundColor((View)this, backgroundColor);
        } else if (ReactNativeFeatureFlags.useNewReactImageViewBackgroundDrawing()) {
            this.reactBackgroundManager.setBackgroundColor(backgroundColor);
        } else if (this.backgroundColor != backgroundColor) {
            this.backgroundColor = backgroundColor;
            this.backgroundImageDrawable = new RoundedColorDrawable(backgroundColor);
            this.isDirty = true;
        }
    }

    public final void setBorderColor(int borderColor) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.setBorderColor((View)this, LogicalEdge.ALL, borderColor);
        } else if (ReactNativeFeatureFlags.useNewReactImageViewBackgroundDrawing()) {
            this.reactBackgroundManager.setBorderColor(8, borderColor);
        } else if (this.borderColor != borderColor) {
            this.borderColor = borderColor;
            this.isDirty = true;
        }
    }

    public final void setOverlayColor(int overlayColor) {
        if (this.overlayColor != overlayColor) {
            this.overlayColor = overlayColor;
            this.isDirty = true;
        }
    }

    public final void setBorderWidth(float borderWidth) {
        float newBorderWidth = PixelUtil.INSTANCE.dpToPx(borderWidth);
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.setBorderWidth((View)this, LogicalEdge.ALL, Float.valueOf(borderWidth));
        } else if (ReactNativeFeatureFlags.useNewReactImageViewBackgroundDrawing()) {
            this.reactBackgroundManager.setBorderWidth(8, newBorderWidth);
        } else if (!FloatUtil.floatsEqual(this.borderWidth, newBorderWidth)) {
            this.borderWidth = newBorderWidth;
            this.isDirty = true;
        }
    }

    public final void setBorderRadius(float borderRadius) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(PixelUtil.INSTANCE.pxToDp(borderRadius), LengthPercentageType.POINT);
            BackgroundStyleApplicator.setBorderRadius((View)this, BorderRadiusProp.BORDER_RADIUS, radius);
        } else if (ReactNativeFeatureFlags.useNewReactImageViewBackgroundDrawing()) {
            this.reactBackgroundManager.setBorderRadius(borderRadius);
        } else if (!FloatUtil.floatsEqual(this.borderRadius, borderRadius)) {
            this.borderRadius = borderRadius;
            this.isDirty = true;
        }
    }

    public final void setBorderRadius(float borderRadius, int position) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(PixelUtil.INSTANCE.pxToDp(borderRadius), LengthPercentageType.POINT);
            BackgroundStyleApplicator.setBorderRadius((View)this, BorderRadiusProp.values()[position], radius);
        } else if (ReactNativeFeatureFlags.useNewReactImageViewBackgroundDrawing()) {
            this.reactBackgroundManager.setBorderRadius(borderRadius, position + 1);
        } else {
            if (this.borderCornerRadii == null) {
                int n = 0;
                float[] fArray = new float[4];
                ReactImageView reactImageView = this;
                while (n < 4) {
                    int n2 = n++;
                    fArray[n2] = Float.NaN;
                }
                reactImageView.borderCornerRadii = fArray;
            }
            if (!FloatUtil.floatsEqual(this.borderCornerRadii != null ? Float.valueOf(this.borderCornerRadii[position]) : null, Float.valueOf(borderRadius))) {
                if (this.borderCornerRadii != null) {
                    this.borderCornerRadii[position] = borderRadius;
                }
                this.isDirty = true;
            }
        }
    }

    public final void setScaleType(@NotNull ScalingUtils.ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        if (this.scaleType != scaleType) {
            this.scaleType = scaleType;
            this.isDirty = true;
        }
    }

    public final void setTileMode(@NotNull Shader.TileMode tileMode) {
        Intrinsics.checkNotNullParameter((Object)tileMode, (String)"tileMode");
        if (this.tileMode != tileMode) {
            this.tileMode = tileMode;
            this.tilePostprocessor = this.isTiled() ? new TilePostprocessor() : null;
            this.isDirty = true;
        }
    }

    public final void setResizeMethod(@NotNull ImageResizeMethod resizeMethod) {
        Intrinsics.checkNotNullParameter((Object)((Object)resizeMethod), (String)"resizeMethod");
        if (this.resizeMethod != resizeMethod) {
            this.resizeMethod = resizeMethod;
            this.isDirty = true;
        }
    }

    public final void setResizeMultiplier(float multiplier) {
        boolean isNewMultiplier;
        boolean bl = isNewMultiplier = Math.abs((double)(this.resizeMultiplier - multiplier)) > (double)1.0E-4f;
        if (isNewMultiplier) {
            this.resizeMultiplier = multiplier;
            this.isDirty = true;
        }
    }

    public final void setSource(@Nullable ReadableArray sources) {
        List tmpSources = new ArrayList();
        if (sources == null || sources.size() == 0) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            tmpSources.add(ImageSource.Companion.getTransparentBitmapImageSource(context));
        } else if (sources.size() == 1) {
            ReadableMap source = sources.getMap(0);
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            ImageSource imageSource = new ImageSource(context, source.getString("uri"), 0.0, 0.0, 12, null);
            if (Intrinsics.areEqual((Object)Uri.EMPTY, (Object)imageSource.getUri())) {
                this.warnImageSource(source.getString("uri"));
                Context context2 = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
                imageSource = ImageSource.Companion.getTransparentBitmapImageSource(context2);
            }
            tmpSources.add(imageSource);
        } else {
            int n = sources.size();
            for (int idx = 0; idx < n; ++idx) {
                ReadableMap source = sources.getMap(idx);
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                ImageSource imageSource = new ImageSource(context, source.getString("uri"), source.getDouble("width"), source.getDouble("height"));
                if (Intrinsics.areEqual((Object)Uri.EMPTY, (Object)imageSource.getUri())) {
                    this.warnImageSource(source.getString("uri"));
                    Context context3 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getContext(...)");
                    imageSource = ImageSource.Companion.getTransparentBitmapImageSource(context3);
                }
                tmpSources.add(imageSource);
            }
        }
        if (Intrinsics.areEqual(this.sources, (Object)tmpSources)) {
            return;
        }
        this.sources.clear();
        this.sources.addAll(tmpSources);
        this.isDirty = true;
    }

    public final void setDefaultSource(@Nullable String name) {
        ResourceDrawableIdHelper resourceDrawableIdHelper = ResourceDrawableIdHelper.Companion.getInstance();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Drawable newDefaultDrawable = resourceDrawableIdHelper.getResourceDrawable(context, name);
        if (!Intrinsics.areEqual((Object)this.defaultImageDrawable, (Object)newDefaultDrawable)) {
            this.defaultImageDrawable = newDefaultDrawable;
            this.isDirty = true;
        }
    }

    public final void setLoadingIndicatorSource(@Nullable String name) {
        AutoRotateDrawable newLoadingIndicatorSource;
        Drawable drawable;
        ResourceDrawableIdHelper resourceDrawableIdHelper = ResourceDrawableIdHelper.Companion.getInstance();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Drawable drawable2 = drawable = resourceDrawableIdHelper.getResourceDrawable(context, name);
        if (drawable2 != null) {
            Drawable it = drawable2;
            boolean bl = false;
            v3 = new AutoRotateDrawable(it, 1000);
        } else {
            v3 = newLoadingIndicatorSource = null;
        }
        if (!Intrinsics.areEqual((Object)this.loadingImageDrawable, (Object)newLoadingIndicatorSource)) {
            this.loadingImageDrawable = (Drawable)newLoadingIndicatorSource;
            this.isDirty = true;
        }
    }

    public final void setProgressiveRenderingEnabled(boolean enabled) {
        this.progressiveRenderingEnabled = enabled;
    }

    public final void setFadeDuration(int durationMs) {
        this.fadeDurationMs = durationMs;
    }

    public final void setHeaders(@Nullable ReadableMap headers) {
        this.headers = headers;
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.clipToPaddingBox((View)this, canvas);
        } else if (ReactNativeFeatureFlags.useNewReactImageViewBackgroundDrawing()) {
            this.reactBackgroundManager.maybeClipToPaddingBox(canvas);
        }
        super.onDraw(canvas);
    }

    public final void maybeUpdateView() {
        if (!this.isDirty) {
            return;
        }
        if (this.hasMultipleSources() && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        this.setSourceImage();
        ImageSource imageSource = this.imageSource;
        if (imageSource == null) {
            return;
        }
        ImageSource imageSourceSafe = imageSource;
        boolean doResize = this.shouldResize(imageSourceSafe);
        if (doResize && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        if (this.isTiled() && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        GenericDraweeHierarchy hierarchy = (GenericDraweeHierarchy)this.getHierarchy();
        hierarchy.setActualImageScaleType(this.scaleType);
        if (this.defaultImageDrawable != null) {
            hierarchy.setPlaceholderImage(this.defaultImageDrawable, this.scaleType);
        }
        if (this.loadingImageDrawable != null) {
            hierarchy.setPlaceholderImage(this.loadingImageDrawable, ScalingUtils.ScaleType.CENTER);
        }
        this.getCornerRadii(computedCornerRadii);
        RoundingParams roundingParams = hierarchy.getRoundingParams();
        if (roundingParams != null) {
            roundingParams.setCornersRadii(computedCornerRadii[0], computedCornerRadii[1], computedCornerRadii[2], computedCornerRadii[3]);
            RoundedColorDrawable roundedColorDrawable = this.backgroundImageDrawable;
            if (roundedColorDrawable != null) {
                RoundedColorDrawable background = roundedColorDrawable;
                boolean bl = false;
                background.setBorder(this.borderColor, this.borderWidth);
                float[] fArray = roundingParams.getCornersRadii();
                if (fArray != null) {
                    float[] it = fArray;
                    boolean bl2 = false;
                    background.setRadii(it);
                }
                hierarchy.setBackgroundImage((Drawable)background);
            }
            roundingParams.setBorder(this.borderColor, this.borderWidth);
            if (this.overlayColor != 0) {
                roundingParams.setOverlayColor(this.overlayColor);
            } else {
                roundingParams.setRoundingMethod(RoundingParams.RoundingMethod.BITMAP_ONLY);
            }
            hierarchy.setRoundingParams(roundingParams);
        }
        hierarchy.setFadeDuration(this.fadeDurationMs >= 0 ? this.fadeDurationMs : (imageSourceSafe.isResource() ? 0 : 300));
        Drawable drawable = this.getDrawableIfUnsupported(imageSourceSafe);
        if (drawable != null) {
            this.maybeUpdateViewFromDrawable(drawable);
        } else {
            this.maybeUpdateViewFromRequest(doResize);
        }
        this.isDirty = false;
    }

    private final void maybeUpdateViewFromRequest(boolean doResize) {
        Object it;
        ImageSource imageSource = this.imageSource;
        if (imageSource == null || (imageSource = imageSource.getUri()) == null) {
            return;
        }
        ImageSource uri = imageSource;
        List postprocessorList = new ArrayList();
        IterativeBoxBlurPostProcessor iterativeBoxBlurPostProcessor = this.iterativeBoxBlurPostProcessor;
        if (iterativeBoxBlurPostProcessor != null) {
            it = iterativeBoxBlurPostProcessor;
            boolean bl = false;
            postprocessorList.add(it);
        }
        TilePostprocessor tilePostprocessor = this.tilePostprocessor;
        if (tilePostprocessor != null) {
            it = tilePostprocessor;
            boolean bl = false;
            postprocessorList.add(it);
        }
        Postprocessor postprocessor = MultiPostprocessor.Companion.from(postprocessorList);
        ResizeOptions resizeOptions = doResize ? this.getResizeOptions() : null;
        ImageRequestBuilder imageRequestBuilder = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setPostprocessor(postprocessor).setResizeOptions(resizeOptions).setAutoRotateEnabled(true).setProgressiveRenderingEnabled(this.progressiveRenderingEnabled);
        Intrinsics.checkNotNull((Object)imageRequestBuilder);
        ImageRequest imageRequest = ReactNetworkImageRequest.Companion.fromBuilderWithHeaders(imageRequestBuilder, this.headers);
        GlobalImageLoadListener globalImageLoadListener = this.globalImageLoadListener;
        if (globalImageLoadListener != null) {
            globalImageLoadListener.onLoadAttempt((Uri)uri);
        }
        AbstractDraweeControllerBuilder<?, ?, ?, ?> abstractDraweeControllerBuilder = this.draweeControllerBuilder;
        Intrinsics.checkNotNull(abstractDraweeControllerBuilder, (String)"null cannot be cast to non-null type com.facebook.drawee.controller.AbstractDraweeControllerBuilder<*, com.facebook.imagepipeline.request.ImageRequest, com.facebook.common.references.CloseableReference<com.facebook.imagepipeline.image.CloseableImage>, com.facebook.imagepipeline.image.ImageInfo>");
        AbstractDraweeControllerBuilder<?, ?, ?, ?> builder = abstractDraweeControllerBuilder;
        builder.reset();
        builder.setImageRequest((Object)imageRequest).setAutoPlayAnimations(true).setOldController(this.getController());
        Object object = this.callerContext;
        if (object != null) {
            Object it2 = object;
            boolean bl = false;
            builder.setCallerContext(it2);
        }
        ImageSource imageSource2 = this.cachedImageSource;
        if (imageSource2 != null) {
            ImageSource cachedSource = imageSource2;
            boolean bl = false;
            ImageRequest cachedImageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)cachedSource.getUri()).setPostprocessor(postprocessor).setResizeOptions(resizeOptions).setAutoRotateEnabled(true).setProgressiveRenderingEnabled(this.progressiveRenderingEnabled).build();
            builder.setLowResImageRequest((Object)cachedImageRequest);
        }
        if (this.downloadListener != null && this.controllerForTesting != null) {
            ForwardingControllerListener combinedListener = new ForwardingControllerListener();
            combinedListener.addListener((ControllerListener)this.downloadListener);
            combinedListener.addListener(this.controllerForTesting);
            builder.setControllerListener((ControllerListener)combinedListener);
        } else if (this.controllerForTesting != null) {
            builder.setControllerListener(this.controllerForTesting);
        } else if (this.downloadListener != null) {
            builder.setControllerListener((ControllerListener)this.downloadListener);
        }
        if (this.downloadListener != null) {
            ((GenericDraweeHierarchy)this.getHierarchy()).setProgressBarImage((Drawable)this.downloadListener);
        }
        this.setController((DraweeController)builder.build());
        builder.reset();
    }

    private final void maybeUpdateViewFromDrawable(Drawable drawable) {
        EventDispatcher eventDispatcher;
        EventDispatcher eventDispatcher2;
        boolean shouldNotify;
        boolean bl = shouldNotify = this.downloadListener != null;
        if (shouldNotify) {
            Context context = this.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
            eventDispatcher2 = UIManagerHelper.getEventDispatcherForReactTag((ReactContext)context, this.getId());
        } else {
            eventDispatcher2 = null;
        }
        EventDispatcher eventDispatcher3 = eventDispatcher = eventDispatcher2;
        if (eventDispatcher3 != null) {
            eventDispatcher3.dispatchEvent(ImageLoadEvent.Companion.createLoadStartEvent(UIManagerHelper.getSurfaceId((View)this), this.getId()));
        }
        ((GenericDraweeHierarchy)this.getHierarchy()).setImage(drawable, 1.0f, false);
        if (eventDispatcher != null && this.imageSource != null) {
            ImageSource imageSource = this.imageSource;
            eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createLoadEvent(UIManagerHelper.getSurfaceId((View)this), this.getId(), imageSource != null ? imageSource.getSource() : null, this.getWidth(), this.getHeight()));
            eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createLoadEndEvent(UIManagerHelper.getSurfaceId((View)this), this.getId()));
        }
    }

    private final void getCornerRadii(float[] computedCorners) {
        float[] radii;
        float defaultBorderRadius = !YogaConstants.isUndefined(this.borderRadius) ? this.borderRadius : 0.0f;
        float[] fArray = this.borderCornerRadii;
        if (this.borderCornerRadii == null) {
            int n = 0;
            float[] fArray2 = new float[4];
            while (n < 4) {
                int n2 = n++;
                fArray2[n2] = Float.NaN;
            }
            fArray = fArray2;
        }
        computedCorners[0] = !YogaConstants.isUndefined((radii = fArray)[0]) ? radii[0] : defaultBorderRadius;
        computedCorners[1] = !YogaConstants.isUndefined(radii[1]) ? radii[1] : defaultBorderRadius;
        computedCorners[2] = !YogaConstants.isUndefined(radii[2]) ? radii[2] : defaultBorderRadius;
        computedCorners[3] = !YogaConstants.isUndefined(radii[3]) ? radii[3] : defaultBorderRadius;
    }

    @VisibleForTesting
    public final void setControllerListener(@Nullable ControllerListener<ImageInfo> controllerListener) {
        this.controllerForTesting = controllerListener;
        this.isDirty = true;
        this.maybeUpdateView();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.isDirty = this.isDirty || this.hasMultipleSources() || this.isTiled();
            this.maybeUpdateView();
        }
    }

    private final boolean hasMultipleSources() {
        return this.sources.size() > 1;
    }

    private final boolean isTiled() {
        return this.tileMode != Shader.TileMode.CLAMP;
    }

    private final void setSourceImage() {
        this.imageSource = null;
        if (this.sources.isEmpty()) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            this.sources.add(ImageSource.Companion.getTransparentBitmapImageSource(context));
        } else if (this.hasMultipleSources()) {
            MultiSourceHelper.MultiSourceResult multiSource = MultiSourceHelper.getBestSourceForSize(this.getWidth(), this.getHeight(), this.sources);
            this.imageSource = multiSource.bestResult;
            this.cachedImageSource = multiSource.bestResultInCache;
            return;
        }
        this.imageSource = this.sources.get(0);
    }

    private final boolean shouldResize(ImageSource imageSource) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.resizeMethod.ordinal()]) {
            case 1 -> {
                if (UriUtil.isLocalContentUri((Uri)imageSource.getUri()) || UriUtil.isLocalFileUri((Uri)imageSource.getUri())) {
                    yield true;
                }
                yield false;
            }
            case 2 -> true;
            default -> false;
        };
    }

    private final Drawable getDrawableIfUnsupported(ImageSource imageSource) {
        if (!ReactNativeFeatureFlags.loadVectorDrawablesOnImages()) {
            return null;
        }
        String resourceName = imageSource.getSource();
        if (!imageSource.isResource() || resourceName == null) {
            return null;
        }
        ResourceDrawableIdHelper drawableHelper = ResourceDrawableIdHelper.Companion.getInstance();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        boolean isVectorDrawable = drawableHelper.isVectorDrawable(context, resourceName);
        if (!isVectorDrawable) {
            return null;
        }
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        return drawableHelper.getResourceDrawable(context2, resourceName);
    }

    private final ResizeOptions getResizeOptions() {
        int width = Math.round((float)this.getWidth() * this.resizeMultiplier);
        int height = Math.round((float)this.getHeight() * this.resizeMultiplier);
        if (width <= 0 || height <= 0) {
            return null;
        }
        return new ResizeOptions(width, height, 0.0f, 0.0f, 12, null);
    }

    private final void warnImageSource(String uri) {
        if (ReactBuildConfig.DEBUG && !ReactFeatureFlags.enableBridgelessArchitecture) {
            Context context = this.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
            RNLog.w((ReactContext)context, "ReactImageView: Image source \"" + uri + "\" doesn't exist");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/react/views/image/ReactImageView$Companion;", "", "()V", "REMOTE_IMAGE_FADE_DURATION_MS", "", "computedCornerRadii", "", "tileMatrix", "Landroid/graphics/Matrix;", "buildHierarchy", "Lcom/facebook/drawee/generic/GenericDraweeHierarchy;", "context", "Landroid/content/Context;", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nReactImageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactImageView.kt\ncom/facebook/react/views/image/ReactImageView$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,726:1\n1#2:727\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final GenericDraweeHierarchy buildHierarchy(Context context) {
            void $this$buildHierarchy_u24lambda_u240;
            RoundingParams roundingParams;
            RoundingParams roundingParams2 = roundingParams = RoundingParams.fromCornersRadius((float)0.0f);
            GenericDraweeHierarchyBuilder genericDraweeHierarchyBuilder = new GenericDraweeHierarchyBuilder(context.getResources());
            boolean bl = false;
            $this$buildHierarchy_u24lambda_u240.setPaintFilterBitmap(true);
            GenericDraweeHierarchy genericDraweeHierarchy = genericDraweeHierarchyBuilder.setRoundingParams(roundingParams).build();
            Intrinsics.checkNotNullExpressionValue((Object)genericDraweeHierarchy, (String)"build(...)");
            return genericDraweeHierarchy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/facebook/react/views/image/ReactImageView$TilePostprocessor;", "Lcom/facebook/imagepipeline/request/BasePostprocessor;", "(Lcom/facebook/react/views/image/ReactImageView;)V", "process", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "source", "bitmapFactory", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "ReactAndroid_release"})
    private final class TilePostprocessor
    extends BasePostprocessor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public CloseableReference<Bitmap> process(@NotNull Bitmap source, @NotNull PlatformBitmapFactory bitmapFactory) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)bitmapFactory, (String)"bitmapFactory");
            Rect destRect = new Rect(0, 0, ReactImageView.this.getWidth(), ReactImageView.this.getHeight());
            ReactImageView.this.scaleType.getTransform(tileMatrix, destRect, source.getWidth(), source.getHeight(), 0.0f, 0.0f);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            Shader shader = (Shader)new BitmapShader(source, ReactImageView.this.tileMode, ReactImageView.this.tileMode);
            shader.setLocalMatrix(tileMatrix);
            paint.setShader(shader);
            CloseableReference closeableReference = bitmapFactory.createBitmap(ReactImageView.this.getWidth(), ReactImageView.this.getHeight());
            Intrinsics.checkNotNullExpressionValue((Object)closeableReference, (String)"createBitmap(...)");
            CloseableReference output = closeableReference;
            try {
                Canvas canvas = new Canvas((Bitmap)output.get());
                canvas.drawRect(destRect, paint);
                CloseableReference closeableReference2 = output.clone();
                Intrinsics.checkNotNullExpressionValue((Object)closeableReference2, (String)"clone(...)");
                CloseableReference closeableReference3 = closeableReference2;
                return closeableReference3;
            }
            finally {
                CloseableReference.closeSafely((CloseableReference)output);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageResizeMethod.values().length];
            try {
                nArray[ImageResizeMethod.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageResizeMethod.RESIZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

