/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime.internal.bolts;

import androidx.annotation.Nullable;
import com.facebook.react.runtime.internal.bolts.Task;
import com.facebook.react.runtime.internal.bolts.UnobservedTaskException;

class UnobservedErrorNotifier {
    @Nullable
    private Task<?> task;

    public UnobservedErrorNotifier(@Nullable Task<?> task) {
        this.task = task;
    }

    protected void finalize() throws Throwable {
        try {
            Task.UnobservedExceptionHandler ueh;
            Task<?> faultedTask = this.task;
            if (faultedTask != null && (ueh = Task.getUnobservedExceptionHandler()) != null) {
                ueh.unobservedException(faultedTask, new UnobservedTaskException(faultedTask.getError()));
            }
        }
        finally {
            super.finalize();
        }
    }

    public void setObserved() {
        this.task = null;
    }
}

