/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.bridge.ReactIgnorableMountingException;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.SurfaceMountingManager;
import com.facebook.react.fabric.mounting.mountitems.DispatchCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MountItemDispatcher {
    private static final String TAG = "MountItemDispatcher";
    private static final long FRAME_TIME_NS = 16666666L;
    private final MountingManager mMountingManager;
    private final ItemDispatchListener mItemDispatchListener;
    @NonNull
    private final ConcurrentLinkedQueue<DispatchCommandMountItem> mViewCommandMountItems = new ConcurrentLinkedQueue();
    @NonNull
    private final ConcurrentLinkedQueue<MountItem> mMountItems = new ConcurrentLinkedQueue();
    @NonNull
    private final ConcurrentLinkedQueue<MountItem> mPreMountItems = new ConcurrentLinkedQueue();
    private boolean mInDispatch = false;
    private int mReDispatchCounter = 0;
    private long mBatchedExecutionTime = 0L;
    private long mRunStartTime = 0L;

    public MountItemDispatcher(MountingManager mountingManager, ItemDispatchListener listener) {
        this.mMountingManager = mountingManager;
        this.mItemDispatchListener = listener;
    }

    public void addViewCommandMountItem(DispatchCommandMountItem mountItem) {
        this.mViewCommandMountItems.add(mountItem);
    }

    public void addMountItem(MountItem mountItem) {
        this.mMountItems.add(mountItem);
    }

    public void addPreAllocateMountItem(MountItem mountItem) {
        if (!this.mMountingManager.surfaceIsStopped(mountItem.getSurfaceId())) {
            this.mPreMountItems.add(mountItem);
        } else if (FabricUIManager.IS_DEVELOPMENT_ENVIRONMENT) {
            FLog.e((String)TAG, (String)"Not queueing PreAllocateMountItem: surfaceId stopped: [%d] - %s", (Object[])new Object[]{mountItem.getSurfaceId(), mountItem.toString()});
        }
    }

    @UiThread
    @ThreadConfined(value="UI")
    public void tryDispatchMountItems() {
        if (this.mInDispatch) {
            return;
        }
        if (ReactNativeFeatureFlags.forceBatchingMountItemsOnAndroid()) {
            this.mInDispatch = true;
            try {
                boolean didDispatchItems = true;
                while (didDispatchItems) {
                    didDispatchItems = this.dispatchMountItems();
                }
            }
            finally {
                this.mInDispatch = false;
            }
            this.mItemDispatchListener.didDispatchMountItems();
        } else {
            boolean didDispatchItems;
            try {
                didDispatchItems = this.dispatchMountItems();
            }
            catch (Throwable e) {
                this.mReDispatchCounter = 0;
                throw e;
            }
            finally {
                this.mInDispatch = false;
            }
            this.mItemDispatchListener.didDispatchMountItems();
            if (this.mReDispatchCounter < 10 && didDispatchItems) {
                if (this.mReDispatchCounter > 2) {
                    ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Re-dispatched " + this.mReDispatchCounter + " times. This indicates setState (?) is likely being called too many times during mounting."));
                }
                ++this.mReDispatchCounter;
                this.tryDispatchMountItems();
            }
            this.mReDispatchCounter = 0;
        }
    }

    @UiThread
    @ThreadConfined(value="UI")
    public void dispatchMountItems(Queue<MountItem> mountItems) {
        while (!mountItems.isEmpty()) {
            MountItem item = mountItems.poll();
            try {
                item.execute(this.mMountingManager);
            }
            catch (RetryableMountingLayerException e) {
                if (item instanceof DispatchCommandMountItem) {
                    DispatchCommandMountItem mountItem = (DispatchCommandMountItem)item;
                    if (mountItem.getRetries() != 0) continue;
                    mountItem.incrementRetries();
                    this.addViewCommandMountItem(mountItem);
                    continue;
                }
                MountItemDispatcher.printMountItem(item, "dispatchExternalMountItems: mounting failed with " + e.getMessage());
            }
        }
    }

    @UiThread
    @ThreadConfined(value="UI")
    private boolean dispatchMountItems() {
        List<MountItem> preMountItemsToDispatch;
        if (this.mReDispatchCounter == 0) {
            this.mBatchedExecutionTime = 0L;
        }
        this.mRunStartTime = SystemClock.uptimeMillis();
        List<DispatchCommandMountItem> viewCommandMountItemsToDispatch = this.getAndResetViewCommandMountItems();
        List<MountItem> mountItemsToDispatch = this.getAndResetMountItems();
        if (mountItemsToDispatch == null && viewCommandMountItemsToDispatch == null) {
            return false;
        }
        this.mItemDispatchListener.willMountItems(mountItemsToDispatch);
        if (viewCommandMountItemsToDispatch != null) {
            Systrace.beginSection(0L, "MountItemDispatcher::mountViews viewCommandMountItems");
            for (DispatchCommandMountItem dispatchCommandMountItem : viewCommandMountItemsToDispatch) {
                if (ReactNativeFeatureFlags.enableFabricLogs()) {
                    MountItemDispatcher.printMountItem(dispatchCommandMountItem, "dispatchMountItems: Executing viewCommandMountItem");
                }
                try {
                    this.executeOrEnqueue(dispatchCommandMountItem);
                }
                catch (RetryableMountingLayerException e) {
                    if (dispatchCommandMountItem.getRetries() == 0) {
                        dispatchCommandMountItem.incrementRetries();
                        this.addViewCommandMountItem(dispatchCommandMountItem);
                        continue;
                    }
                    ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Caught exception executing ViewCommand: " + dispatchCommandMountItem.toString(), e));
                }
                catch (Throwable e) {
                    ReactSoftExceptionLogger.logSoftException(TAG, new RuntimeException("Caught exception executing ViewCommand: " + dispatchCommandMountItem.toString(), e));
                }
            }
            Systrace.endSection(0L);
        }
        if ((preMountItemsToDispatch = this.getAndResetPreMountItems()) != null) {
            Systrace.beginSection(0L, "MountItemDispatcher::mountViews preMountItems");
            for (MountItem preMountItem : preMountItemsToDispatch) {
                if (ReactNativeFeatureFlags.enableFabricLogs()) {
                    MountItemDispatcher.printMountItem(preMountItem, "dispatchMountItems: Executing preMountItem");
                }
                this.executeOrEnqueue(preMountItem);
            }
            Systrace.endSection(0L);
        }
        if (mountItemsToDispatch != null) {
            Systrace.beginSection(0L, "MountItemDispatcher::mountViews mountItems to execute");
            long l = SystemClock.uptimeMillis();
            for (MountItem mountItem : mountItemsToDispatch) {
                if (ReactNativeFeatureFlags.enableFabricLogs()) {
                    MountItemDispatcher.printMountItem(mountItem, "dispatchMountItems: Executing mountItem");
                }
                try {
                    this.executeOrEnqueue(mountItem);
                }
                catch (Throwable e) {
                    SurfaceMountingManager surfaceManager;
                    FLog.e((String)TAG, (String)"dispatchMountItems: caught exception, displaying mount state", (Throwable)e);
                    for (MountItem m : mountItemsToDispatch) {
                        if (m == mountItem) {
                            FLog.e((String)TAG, (String)"dispatchMountItems: mountItem: next mountItem triggered exception!");
                        }
                        MountItemDispatcher.printMountItem(m, "dispatchMountItems: mountItem");
                    }
                    if (mountItem.getSurfaceId() != -1 && (surfaceManager = this.mMountingManager.getSurfaceManager(mountItem.getSurfaceId())) != null) {
                        surfaceManager.printSurfaceState();
                    }
                    if (ReactIgnorableMountingException.isIgnorable(e)) {
                        ReactSoftExceptionLogger.logSoftException(TAG, e);
                        continue;
                    }
                    throw e;
                }
            }
            this.mBatchedExecutionTime += SystemClock.uptimeMillis() - l;
            Systrace.endSection(0L);
        }
        this.mItemDispatchListener.didMountItems(mountItemsToDispatch);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    @ThreadConfined(value="UI")
    public void dispatchPreMountItems(long frameTimeNanos) {
        if (this.mPreMountItems.isEmpty()) {
            return;
        }
        Systrace.beginSection(0L, "MountItemDispatcher::premountViews");
        this.mInDispatch = true;
        long frameTimeDeadline = frameTimeNanos + 8333333L;
        try {
            while (System.nanoTime() <= frameTimeDeadline) {
                MountItem preMountItemToDispatch = this.mPreMountItems.poll();
                if (preMountItemToDispatch == null) {
                    break;
                }
                if (ReactNativeFeatureFlags.enableFabricLogs()) {
                    MountItemDispatcher.printMountItem(preMountItemToDispatch, "dispatchPreMountItems");
                }
                this.executeOrEnqueue(preMountItemToDispatch);
            }
        }
        finally {
            this.mInDispatch = false;
        }
        Systrace.endSection(0L);
    }

    private void executeOrEnqueue(MountItem item) {
        if (this.mMountingManager.isWaitingForViewAttach(item.getSurfaceId())) {
            if (ReactNativeFeatureFlags.enableFabricLogs()) {
                FLog.e((String)TAG, (String)"executeOrEnqueue: Item execution delayed, surface %s is not ready yet", (Object[])new Object[]{item.getSurfaceId()});
            }
            SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManager(item.getSurfaceId());
            surfaceMountingManager.scheduleMountItemOnViewAttach(item);
        } else {
            item.execute(this.mMountingManager);
        }
    }

    @Nullable
    private static <E> List<E> drainConcurrentItemQueue(ConcurrentLinkedQueue<E> queue) {
        if (queue.isEmpty()) {
            return null;
        }
        ArrayList<E> result = new ArrayList<E>();
        do {
            E item;
            if ((item = queue.poll()) == null) continue;
            result.add(item);
        } while (!queue.isEmpty());
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    @UiThread
    @ThreadConfined(value="UI")
    @Nullable
    private List<DispatchCommandMountItem> getAndResetViewCommandMountItems() {
        return MountItemDispatcher.drainConcurrentItemQueue(this.mViewCommandMountItems);
    }

    @UiThread
    @ThreadConfined(value="UI")
    @Nullable
    private List<MountItem> getAndResetMountItems() {
        return MountItemDispatcher.drainConcurrentItemQueue(this.mMountItems);
    }

    @UiThread
    @ThreadConfined(value="UI")
    @Nullable
    private List<MountItem> getAndResetPreMountItems() {
        return MountItemDispatcher.drainConcurrentItemQueue(this.mPreMountItems);
    }

    public long getBatchedExecutionTime() {
        return this.mBatchedExecutionTime;
    }

    public long getRunStartTime() {
        return this.mRunStartTime;
    }

    private static void printMountItem(MountItem mountItem, String prefix) {
        String[] mountItemLines;
        for (String m : mountItemLines = mountItem.toString().split("\n")) {
            FLog.e((String)TAG, (String)(prefix + ": " + m));
        }
    }

    public static interface ItemDispatchListener {
        public void willMountItems(@Nullable List<MountItem> var1);

        public void didMountItems(@Nullable List<MountItem> var1);

        public void didDispatchMountItems();
    }
}

