/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.common.logging.FLog;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import java.util.Iterator;
import java.util.List;

class ReactPackageHelper {
    ReactPackageHelper() {
    }

    static Iterable<ModuleHolder> getNativeModuleIterator(ReactPackage reactPackage, ReactApplicationContext reactApplicationContext) {
        FLog.d((String)"ReactNative", (String)(reactPackage.getClass().getSimpleName() + " is not a LazyReactPackage, falling back to old version."));
        final List<NativeModule> nativeModules = reactPackage.createNativeModules(reactApplicationContext);
        return () -> new Iterator<ModuleHolder>(){
            int position = 0;

            @Override
            public ModuleHolder next() {
                return new ModuleHolder((NativeModule)nativeModules.get(this.position++));
            }

            @Override
            public boolean hasNext() {
                return this.position < nativeModules.size();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove methods ");
            }
        };
    }
}

