/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.debuggingoverlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import androidx.annotation.UiThread;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.views.debuggingoverlay.TraceUpdate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007J\u0016\u0010\u0019\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0011`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/views/debuggingoverlay/DebuggingOverlay;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "highlightedElementsPaint", "Landroid/graphics/Paint;", "highlightedElementsRectangles", "", "Landroid/graphics/RectF;", "traceUpdateIdToCleanupRunnableMap", "Ljava/util/HashMap;", "", "Ljava/lang/Runnable;", "Lkotlin/collections/HashMap;", "traceUpdatePaint", "traceUpdatesToDisplayMap", "Lcom/facebook/react/views/debuggingoverlay/TraceUpdate;", "clearElementsHighlights", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "setHighlightedElementsRectangles", "elementsRectangles", "setTraceUpdates", "traceUpdates", "", "ReactAndroid_release"})
public final class DebuggingOverlay
extends View {
    @NotNull
    private final Paint traceUpdatePaint;
    @NotNull
    private final HashMap<Integer, TraceUpdate> traceUpdatesToDisplayMap;
    @NotNull
    private final HashMap<Integer, Runnable> traceUpdateIdToCleanupRunnableMap;
    @NotNull
    private final Paint highlightedElementsPaint;
    @NotNull
    private List<RectF> highlightedElementsRectangles;

    public DebuggingOverlay(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.traceUpdatePaint = new Paint();
        this.traceUpdatesToDisplayMap = new HashMap();
        this.traceUpdateIdToCleanupRunnableMap = new HashMap();
        this.highlightedElementsPaint = new Paint();
        this.highlightedElementsRectangles = new ArrayList();
        this.traceUpdatePaint.setStyle(Paint.Style.STROKE);
        this.traceUpdatePaint.setStrokeWidth(6.0f);
        this.highlightedElementsPaint.setStyle(Paint.Style.FILL);
        this.highlightedElementsPaint.setColor(-859248897);
    }

    @UiThread
    public final void setTraceUpdates(@NotNull List<TraceUpdate> traceUpdates) {
        Intrinsics.checkNotNullParameter(traceUpdates, (String)"traceUpdates");
        for (TraceUpdate traceUpdate : traceUpdates) {
            int traceUpdateId = traceUpdate.getId();
            if (this.traceUpdateIdToCleanupRunnableMap.containsKey(traceUpdateId)) {
                UiThreadUtil.removeOnUiThread(this.traceUpdateIdToCleanupRunnableMap.get(traceUpdateId));
                this.traceUpdateIdToCleanupRunnableMap.remove(traceUpdateId);
            }
            Integer n = traceUpdateId;
            ((Map)this.traceUpdatesToDisplayMap).put(n, traceUpdate);
        }
        this.invalidate();
    }

    @UiThread
    public final void setHighlightedElementsRectangles(@NotNull List<RectF> elementsRectangles) {
        Intrinsics.checkNotNullParameter(elementsRectangles, (String)"elementsRectangles");
        this.highlightedElementsRectangles = elementsRectangles;
        this.invalidate();
    }

    @UiThread
    public final void clearElementsHighlights() {
        this.highlightedElementsRectangles.clear();
        this.invalidate();
    }

    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        for (TraceUpdate traceUpdate : this.traceUpdatesToDisplayMap.values()) {
            this.traceUpdatePaint.setColor(traceUpdate.getColor());
            canvas.drawRect(traceUpdate.getRectangle(), this.traceUpdatePaint);
            int traceUpdateId = traceUpdate.getId();
            Runnable block = () -> DebuggingOverlay.onDraw$lambda$0(this, traceUpdateId);
            if (this.traceUpdateIdToCleanupRunnableMap.containsKey(traceUpdateId)) continue;
            Integer n = traceUpdateId;
            ((Map)this.traceUpdateIdToCleanupRunnableMap).put(n, block);
            UiThreadUtil.runOnUiThread(block, 2000L);
        }
        for (RectF elementRectangle : this.highlightedElementsRectangles) {
            canvas.drawRect(elementRectangle, this.highlightedElementsPaint);
        }
    }

    private static final void onDraw$lambda$0(DebuggingOverlay this$0, int $traceUpdateId) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.traceUpdatesToDisplayMap.remove($traceUpdateId);
        this$0.traceUpdateIdToCleanupRunnableMap.remove($traceUpdateId);
        this$0.invalidate();
    }
}

