/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.TouchEvent;
import com.facebook.react.uimanager.events.TouchesHelper;

class ReactEventEmitter
implements RCTModernEventEmitter {
    private static final String TAG = "ReactEventEmitter";
    @Nullable
    private RCTModernEventEmitter mFabricEventEmitter = null;
    @Nullable
    private RCTEventEmitter mDefaultEventEmitter = null;
    private final ReactApplicationContext mReactContext;

    public ReactEventEmitter(ReactApplicationContext reactContext) {
        this.mReactContext = reactContext;
    }

    public void register(int uiManagerType, RCTModernEventEmitter eventEmitter) {
        assert (uiManagerType == 2);
        this.mFabricEventEmitter = eventEmitter;
    }

    public void register(int uiManagerType, RCTEventEmitter eventEmitter) {
        assert (uiManagerType == 1);
        this.mDefaultEventEmitter = eventEmitter;
    }

    public void unregister(int uiManagerType) {
        if (uiManagerType == 1) {
            this.mDefaultEventEmitter = null;
        } else {
            this.mFabricEventEmitter = null;
        }
    }

    @Override
    public void receiveEvent(int targetReactTag, String eventName, @Nullable WritableMap event) {
        this.receiveEvent(-1, targetReactTag, eventName, event);
    }

    @Override
    public void receiveEvent(int surfaceId, int targetTag, String eventName, @Nullable WritableMap event) {
        this.receiveEvent(surfaceId, targetTag, eventName, false, 0, event, 2);
    }

    @Override
    public void receiveTouches(String eventName, WritableArray touches, WritableArray changedIndices) {
        Assertions.assertCondition((touches.size() > 0 ? 1 : 0) != 0);
        int reactTag = touches.getMap(0).getInt("target");
        int uiManagerType = ViewUtil.getUIManagerType(reactTag);
        if (uiManagerType == 1 && this.getDefaultEventEmitter() != null) {
            this.mDefaultEventEmitter.receiveTouches(eventName, touches, changedIndices);
        }
    }

    @Override
    public void receiveTouches(TouchEvent event) {
        int reactTag = event.getViewTag();
        int uiManagerType = ViewUtil.getUIManagerType(event.getViewTag(), event.getSurfaceId());
        if (uiManagerType == 2 && this.mFabricEventEmitter != null) {
            TouchesHelper.sendTouchEvent(this.mFabricEventEmitter, event);
        } else if (uiManagerType == 1 && this.getDefaultEventEmitter() != null) {
            TouchesHelper.sendTouchesLegacy(this.mDefaultEventEmitter, event);
        } else {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot find EventEmitter for receivedTouches: ReactTag[" + reactTag + "] UIManagerType[" + uiManagerType + "] EventName[" + event.getEventName() + "]"));
        }
    }

    @Nullable
    private RCTEventEmitter getDefaultEventEmitter() {
        if (this.mDefaultEventEmitter == null) {
            if (this.mReactContext.hasActiveReactInstance()) {
                this.mDefaultEventEmitter = this.mReactContext.getJSModule(RCTEventEmitter.class);
            } else {
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get RCTEventEmitter from Context, no active Catalyst instance!"));
            }
        }
        return this.mDefaultEventEmitter;
    }

    @Override
    public void receiveEvent(int surfaceId, int targetReactTag, String eventName, boolean canCoalesceEvent, int customCoalesceKey, @Nullable WritableMap event, int category) {
        int uiManagerType = ViewUtil.getUIManagerType(targetReactTag, surfaceId);
        if (uiManagerType == 2 && this.mFabricEventEmitter != null) {
            this.mFabricEventEmitter.receiveEvent(surfaceId, targetReactTag, eventName, canCoalesceEvent, customCoalesceKey, event, category);
        } else if (uiManagerType == 1) {
            RCTEventEmitter defaultEmitter = this.getDefaultEventEmitter();
            if (defaultEmitter != null) {
                defaultEmitter.receiveEvent(targetReactTag, eventName, event);
            }
        } else {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot find EventEmitter for receiveEvent: SurfaceId[" + surfaceId + "] ReactTag[" + targetReactTag + "] UIManagerType[" + uiManagerType + "] EventName[" + eventName + "]"));
        }
    }
}

