/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport.inspector;

import com.facebook.react.devsupport.inspector.InspectorNetworkRequestListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class InspectorNetworkHelper {
    private static OkHttpClient client;

    private InspectorNetworkHelper() {
    }

    public static void loadNetworkResource(String url, final InspectorNetworkRequestListener listener) {
        Request request;
        if (client == null) {
            client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
        }
        try {
            request = new Request.Builder().url(url).build();
        }
        catch (IllegalArgumentException e) {
            listener.onError("Not a valid URL: " + url);
            return;
        }
        Call call = client.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (call.isCanceled()) {
                    return;
                }
                listener.onError(e.getMessage());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                Headers headers = response.headers();
                HashMap<String, String> headersMap = new HashMap<String, String>();
                for (String name : headers.names()) {
                    headersMap.put(name, headers.get(name));
                }
                listener.onHeaders(response.code(), headersMap);
                try (ResponseBody responseBody = response.body();){
                    if (responseBody != null) {
                        InputStream inputStream = responseBody.byteStream();
                        int chunkSize = 1024;
                        byte[] buffer = new byte[chunkSize];
                        try {
                            int bytesRead;
                            while ((bytesRead = inputStream.read(buffer)) != -1) {
                                String chunk = new String(buffer, 0, bytesRead);
                                listener.onData(chunk);
                            }
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    listener.onCompletion();
                }
                catch (IOException e) {
                    listener.onError(e.getMessage());
                }
            }
        });
    }
}

