/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.interop;

import androidx.annotation.Nullable;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import java.util.HashMap;

public class InteropModuleRegistry {
    private final HashMap<Class, Object> supportedModules = new HashMap();

    public <T extends JavaScriptModule> boolean shouldReturnInteropModule(Class<T> requestedModule) {
        return this.checkReactFeatureFlagsConditions() && this.supportedModules.containsKey(requestedModule);
    }

    @Nullable
    public <T extends JavaScriptModule> T getInteropModule(Class<T> requestedModule) {
        if (this.checkReactFeatureFlagsConditions()) {
            return (T)((JavaScriptModule)this.supportedModules.get(requestedModule));
        }
        return null;
    }

    public <T extends JavaScriptModule> void registerInteropModule(Class<T> interopModuleInterface, Object interopModule) {
        if (this.checkReactFeatureFlagsConditions()) {
            this.supportedModules.put(interopModuleInterface, interopModule);
        }
    }

    private boolean checkReactFeatureFlagsConditions() {
        return ReactFeatureFlags.enableFabricRenderer && ReactNativeFeatureFlags.useFabricInterop();
    }
}

