/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.CxxCallbackImpl;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.common.build.ReactBuildConfig;
import java.util.Map;

public abstract class BaseJavaModule
implements NativeModule {
    public static final String METHOD_TYPE_ASYNC = "async";
    public static final String METHOD_TYPE_PROMISE = "promise";
    public static final String METHOD_TYPE_SYNC = "sync";
    @Nullable
    protected CxxCallbackImpl mEventEmitterCallback;
    @Nullable
    private final ReactApplicationContext mReactApplicationContext;

    public BaseJavaModule() {
        this(null);
    }

    public BaseJavaModule(@Nullable ReactApplicationContext reactContext) {
        this.mReactApplicationContext = reactContext;
    }

    @Nullable
    public Map<String, Object> getConstants() {
        return null;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean canOverrideExistingModule() {
        return false;
    }

    @Override
    public void invalidate() {
    }

    protected final ReactApplicationContext getReactApplicationContext() {
        return (ReactApplicationContext)((Object)Assertions.assertNotNull((Object)((Object)this.mReactApplicationContext), (String)"Tried to get ReactApplicationContext even though NativeModule wasn't instantiated with one"));
    }

    @ThreadConfined(value="ANY")
    @Nullable
    protected final ReactApplicationContext getReactApplicationContextIfActiveOrWarn() {
        if (this.mReactApplicationContext.hasActiveReactInstance()) {
            return this.mReactApplicationContext;
        }
        String msg = "React Native Instance has already disappeared: requested by " + this.getName();
        if (ReactBuildConfig.DEBUG) {
            FLog.w((String)"ReactNative", (String)msg);
        } else {
            ReactSoftExceptionLogger.logSoftException("ReactNative", new RuntimeException(msg));
        }
        return null;
    }

    @DoNotStrip
    private final void setEventEmitterCallback(CxxCallbackImpl eventEmitterCallback) {
        this.mEventEmitterCallback = eventEmitterCallback;
    }
}

