/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import com.facebook.react.bridge.MemoryPressureListener;
import java.util.concurrent.CopyOnWriteArrayList;

public class MemoryPressureRouter
implements ComponentCallbacks2 {
    private final CopyOnWriteArrayList<MemoryPressureListener> mListeners = new CopyOnWriteArrayList();

    public MemoryPressureRouter(Context context) {
        context.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this);
    }

    public void destroy(Context context) {
        context.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this);
    }

    public void addMemoryPressureListener(MemoryPressureListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeMemoryPressureListener(MemoryPressureListener listener) {
        this.mListeners.remove(listener);
    }

    public void onTrimMemory(int level) {
        this.dispatchMemoryPressure(level);
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
    }

    private void dispatchMemoryPressure(int level) {
        for (MemoryPressureListener listener : this.mListeners) {
            listener.handleMemoryPressure(level);
        }
    }
}

