/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.util;

import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/util/JSStackTrace;", "", "()V", "COLUMN_KEY", "", "FILE_ID_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "FILE_KEY", "LINE_NUMBER_KEY", "METHOD_NAME_KEY", "format", "message", "stack", "Lcom/facebook/react/bridge/ReadableArray;", "parseFileId", "frame", "Lcom/facebook/react/bridge/ReadableMap;", "ReactAndroid_debug"})
public final class JSStackTrace {
    @NotNull
    public static final JSStackTrace INSTANCE = new JSStackTrace();
    @NotNull
    public static final String LINE_NUMBER_KEY = "lineNumber";
    @NotNull
    public static final String FILE_KEY = "file";
    @NotNull
    public static final String COLUMN_KEY = "column";
    @NotNull
    public static final String METHOD_NAME_KEY = "methodName";
    private static final Pattern FILE_ID_PATTERN = Pattern.compile("\\b((?:seg-\\d+(?:_\\d+)?|\\d+)\\.js)");

    private JSStackTrace() {
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull String message, @NotNull ReadableArray stack) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        StringBuilder stringBuilder = new StringBuilder(message).append(", stack:\n");
        int n = stack.size();
        for (int i = 0; i < n; ++i) {
            ReadableMap frame = stack.getMap(i);
            stringBuilder.append(frame.getString(METHOD_NAME_KEY)).append("@").append(INSTANCE.parseFileId(frame));
            if (frame.hasKey(LINE_NUMBER_KEY) && !frame.isNull(LINE_NUMBER_KEY) && frame.getType(LINE_NUMBER_KEY) == ReadableType.Number) {
                stringBuilder.append(frame.getInt(LINE_NUMBER_KEY));
            } else {
                stringBuilder.append(-1);
            }
            if (frame.hasKey(COLUMN_KEY) && !frame.isNull(COLUMN_KEY) && frame.getType(COLUMN_KEY) == ReadableType.Number) {
                stringBuilder.append(":").append(frame.getInt(COLUMN_KEY));
            }
            stringBuilder.append("\n");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String parseFileId(ReadableMap frame) {
        Matcher matcher;
        String file;
        if (frame.hasKey(FILE_KEY) && !frame.isNull(FILE_KEY) && frame.getType(FILE_KEY) == ReadableType.String && (file = frame.getString(FILE_KEY)) != null && (matcher = FILE_ID_PATTERN.matcher(file)).find()) {
            return matcher.group(1) + ":";
        }
        return "";
    }
}

