/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.annotation.TargetApi;
import android.graphics.BlendMode;
import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/uimanager/BlendModeHelper;", "", "()V", "parseMixBlendMode", "Landroid/graphics/BlendMode;", "mixBlendMode", "", "ReactAndroid_debug"})
@TargetApi(value=29)
public final class BlendModeHelper {
    @NotNull
    public static final BlendModeHelper INSTANCE = new BlendModeHelper();

    private BlendModeHelper() {
    }

    @JvmStatic
    @Nullable
    public static final BlendMode parseMixBlendMode(@Nullable String mixBlendMode) {
        if (mixBlendMode == null || Build.VERSION.SDK_INT < 29) {
            return null;
        }
        return switch (mixBlendMode) {
            case "normal" -> null;
            case "multiply" -> BlendMode.MULTIPLY;
            case "screen" -> BlendMode.SCREEN;
            case "overlay" -> BlendMode.OVERLAY;
            case "darken" -> BlendMode.DARKEN;
            case "lighten" -> BlendMode.LIGHTEN;
            case "color-dodge" -> BlendMode.COLOR_DODGE;
            case "color-burn" -> BlendMode.COLOR_BURN;
            case "hard-light" -> BlendMode.HARD_LIGHT;
            case "soft-light" -> BlendMode.SOFT_LIGHT;
            case "difference" -> BlendMode.DIFFERENCE;
            case "exclusion" -> BlendMode.EXCLUSION;
            case "hue" -> BlendMode.HUE;
            case "saturation" -> BlendMode.SATURATION;
            case "color" -> BlendMode.COLOR;
            case "luminosity" -> BlendMode.LUMINOSITY;
            default -> throw new IllegalArgumentException("Invalid mix-blend-mode name: " + mixBlendMode);
        };
    }
}

