/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.ReadableMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000 %2\u00020\u0001:\u0002%&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/facebook/react/animated/SpringAnimation;", "Lcom/facebook/react/animated/AnimationDriver;", "config", "Lcom/facebook/react/bridge/ReadableMap;", "(Lcom/facebook/react/bridge/ReadableMap;)V", "currentLoop", "", "currentState", "Lcom/facebook/react/animated/SpringAnimation$PhysicsState;", "displacementFromRestThreshold", "", "endValue", "initialVelocity", "isAtRest", "", "()Z", "isOvershooting", "iterations", "lastTime", "", "originalValue", "overshootClampingEnabled", "restSpeedThreshold", "springDamping", "springMass", "springStarted", "springStiffness", "startValue", "timeAccumulator", "advance", "", "realDeltaTime", "getDisplacementDistanceForState", "state", "resetConfig", "runAnimationStep", "frameTimeNanos", "Companion", "PhysicsState", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nSpringAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringAnimation.kt\ncom/facebook/react/animated/SpringAnimation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class SpringAnimation
extends AnimationDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long lastTime;
    private boolean springStarted;
    private double springStiffness;
    private double springDamping;
    private double springMass;
    private double initialVelocity;
    private boolean overshootClampingEnabled;
    @NotNull
    private final PhysicsState currentState;
    private double startValue;
    private double endValue;
    private double restSpeedThreshold;
    private double displacementFromRestThreshold;
    private double timeAccumulator;
    private int iterations;
    private int currentLoop;
    private double originalValue;
    private static final double MAX_DELTA_TIME_SEC = 0.064;

    public SpringAnimation(@NotNull ReadableMap config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.currentState = new PhysicsState(0.0, 0.0, 3, null);
        this.currentState.setVelocity(config.getDouble("initialVelocity"));
        this.resetConfig(config);
    }

    @Override
    public void resetConfig(@NotNull ReadableMap config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.springStiffness = config.getDouble("stiffness");
        this.springDamping = config.getDouble("damping");
        this.springMass = config.getDouble("mass");
        this.initialVelocity = this.currentState.getVelocity();
        this.endValue = config.getDouble("toValue");
        this.restSpeedThreshold = config.getDouble("restSpeedThreshold");
        this.displacementFromRestThreshold = config.getDouble("restDisplacementThreshold");
        this.overshootClampingEnabled = config.getBoolean("overshootClamping");
        this.iterations = config.hasKey("iterations") ? config.getInt("iterations") : 1;
        this.hasFinished = this.iterations == 0;
        this.currentLoop = 0;
        this.timeAccumulator = 0.0;
        this.springStarted = false;
    }

    @Override
    public void runAnimationStep(long frameTimeNanos) {
        ValueAnimatedNode valueAnimatedNode = this.animatedValue;
        if (valueAnimatedNode == null) {
            boolean bl = false;
            String string = "Animated value should not be null";
            throw new IllegalArgumentException(string.toString());
        }
        ValueAnimatedNode animatedValue = valueAnimatedNode;
        long frameTimeMillis = frameTimeNanos / (long)1000000;
        if (!this.springStarted) {
            if (this.currentLoop == 0) {
                this.originalValue = animatedValue.nodeValue;
                this.currentLoop = 1;
            }
            this.currentState.setPosition(animatedValue.nodeValue);
            this.startValue = this.currentState.getPosition();
            this.lastTime = frameTimeMillis;
            this.timeAccumulator = 0.0;
            this.springStarted = true;
        }
        this.advance((double)(frameTimeMillis - this.lastTime) / 1000.0);
        this.lastTime = frameTimeMillis;
        animatedValue.nodeValue = this.currentState.getPosition();
        if (this.isAtRest()) {
            if (this.iterations == -1 || this.currentLoop < this.iterations) {
                this.springStarted = false;
                animatedValue.nodeValue = this.originalValue;
                int n = this.currentLoop;
                this.currentLoop = n + 1;
            } else {
                this.hasFinished = true;
            }
        }
    }

    private final double getDisplacementDistanceForState(PhysicsState state) {
        return Math.abs(this.endValue - state.getPosition());
    }

    private final boolean isAtRest() {
        return Math.abs(this.currentState.getVelocity()) <= this.restSpeedThreshold && (this.getDisplacementDistanceForState(this.currentState) <= this.displacementFromRestThreshold || this.springStiffness == 0.0);
    }

    private final boolean isOvershooting() {
        return this.springStiffness > 0.0 && (this.startValue < this.endValue && this.currentState.getPosition() > this.endValue || this.startValue > this.endValue && this.currentState.getPosition() < this.endValue);
    }

    private final void advance(double realDeltaTime) {
        if (this.isAtRest()) {
            return;
        }
        double adjustedDeltaTime = realDeltaTime;
        if (realDeltaTime > 0.064) {
            adjustedDeltaTime = 0.064;
        }
        this.timeAccumulator += adjustedDeltaTime;
        double c = this.springDamping;
        double m = this.springMass;
        double k = this.springStiffness;
        double v0 = -this.initialVelocity;
        double zeta = c / ((double)2 * Math.sqrt(k * m));
        double omega0 = Math.sqrt(k / m);
        double omega1 = omega0 * Math.sqrt(1.0 - zeta * zeta);
        double x0 = this.endValue - this.startValue;
        double velocity = 0.0;
        double position = 0.0;
        double t = this.timeAccumulator;
        if (zeta < 1.0) {
            double envelope = Math.exp(-zeta * omega0 * t);
            position = this.endValue - envelope * ((v0 + zeta * omega0 * x0) / omega1 * Math.sin(omega1 * t) + x0 * Math.cos(omega1 * t));
            velocity = zeta * omega0 * envelope * (Math.sin(omega1 * t) * (v0 + zeta * omega0 * x0) / omega1 + x0 * Math.cos(omega1 * t)) - envelope * (Math.cos(omega1 * t) * (v0 + zeta * omega0 * x0) - omega1 * x0 * Math.sin(omega1 * t));
        } else {
            double envelope = Math.exp(-omega0 * t);
            position = this.endValue - envelope * (x0 + (v0 + omega0 * x0) * t);
            velocity = envelope * (v0 * (t * omega0 - 1.0) + t * x0 * (omega0 * omega0));
        }
        this.currentState.setPosition(position);
        this.currentState.setVelocity(velocity);
        if (this.isAtRest() || this.overshootClampingEnabled && this.isOvershooting()) {
            if (this.springStiffness > 0.0) {
                this.startValue = this.endValue;
                this.currentState.setPosition(this.endValue);
            } else {
                this.startValue = this.endValue = this.currentState.getPosition();
            }
            this.currentState.setVelocity(0.0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/react/animated/SpringAnimation$Companion;", "", "()V", "MAX_DELTA_TIME_SEC", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/animated/SpringAnimation$PhysicsState;", "", "position", "", "velocity", "(DD)V", "getPosition", "()D", "setPosition", "(D)V", "getVelocity", "setVelocity", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ReactAndroid_debug"})
    private static final class PhysicsState {
        private double position;
        private double velocity;

        public PhysicsState(double position, double velocity) {
            this.position = position;
            this.velocity = velocity;
        }

        public /* synthetic */ PhysicsState(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                d = 0.0;
            }
            if ((n & 2) != 0) {
                d2 = 0.0;
            }
            this(d, d2);
        }

        public final double getPosition() {
            return this.position;
        }

        public final void setPosition(double d) {
            this.position = d;
        }

        public final double getVelocity() {
            return this.velocity;
        }

        public final void setVelocity(double d) {
            this.velocity = d;
        }

        public final double component1() {
            return this.position;
        }

        public final double component2() {
            return this.velocity;
        }

        @NotNull
        public final PhysicsState copy(double position, double velocity) {
            return new PhysicsState(position, velocity);
        }

        public static /* synthetic */ PhysicsState copy$default(PhysicsState physicsState, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                d = physicsState.position;
            }
            if ((n & 2) != 0) {
                d2 = physicsState.velocity;
            }
            return physicsState.copy(d, d2);
        }

        @NotNull
        public String toString() {
            return "PhysicsState(position=" + this.position + ", velocity=" + this.velocity + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.position);
            result = result * 31 + Double.hashCode(this.velocity);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PhysicsState)) {
                return false;
            }
            PhysicsState physicsState = (PhysicsState)other;
            if (Double.compare(this.position, physicsState.position) != 0) {
                return false;
            }
            return Double.compare(this.velocity, physicsState.velocity) == 0;
        }

        public PhysicsState() {
            this(0.0, 0.0, 3, null);
        }
    }
}

