/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.appstate;

import com.facebook.fbreact.specs.NativeAppStateSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.WindowFocusChangeListener;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.module.annotations.ReactModule;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="AppState")
public class AppStateModule
extends NativeAppStateSpec
implements LifecycleEventListener,
WindowFocusChangeListener {
    public static final String APP_STATE_ACTIVE = "active";
    public static final String APP_STATE_BACKGROUND = "background";
    private static final String INITIAL_STATE = "initialAppState";
    private String mAppState;

    public AppStateModule(ReactApplicationContext reactContext) {
        super(reactContext);
        reactContext.addLifecycleEventListener(this);
        reactContext.addWindowFocusChangeListener(this);
        this.mAppState = reactContext.getLifecycleState() == LifecycleState.RESUMED ? APP_STATE_ACTIVE : APP_STATE_BACKGROUND;
    }

    @Override
    public Map<String, Object> getTypedExportedConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put(INITIAL_STATE, this.mAppState);
        return constants;
    }

    @Override
    public void getCurrentAppState(Callback success, Callback error) {
        success.invoke(this.createAppStateEventMap());
    }

    @Override
    public void onHostResume() {
        this.mAppState = APP_STATE_ACTIVE;
        this.sendAppStateChangeEvent();
    }

    @Override
    public void onHostPause() {
        this.mAppState = APP_STATE_BACKGROUND;
        this.sendAppStateChangeEvent();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void onWindowFocusChange(boolean hasFocus) {
        this.sendEvent("appStateFocusChange", hasFocus);
    }

    private WritableMap createAppStateEventMap() {
        WritableMap appState = Arguments.createMap();
        appState.putString("app_state", this.mAppState);
        return appState;
    }

    private void sendEvent(String eventName, @Nullable Object data) {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        if (reactApplicationContext == null) {
            return;
        }
        if (!reactApplicationContext.hasActiveReactInstance()) {
            return;
        }
        reactApplicationContext.emitDeviceEvent(eventName, data);
    }

    private void sendAppStateChangeEvent() {
        this.sendEvent("appStateDidChange", this.createAppStateEventMap());
    }

    @Override
    public void addListener(String eventName) {
    }

    @Override
    public void removeListeners(double count) {
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.getReactApplicationContext().removeLifecycleEventListener(this);
    }
}

