/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.mapbuffer.ReadableMapBuffer;
import com.facebook.react.fabric.FabricSoLoader;
import com.facebook.react.uimanager.StateWrapper;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@SuppressLint(value={"MissingNativeLoadLibrary"})
@DoNotStrip
public class StateWrapperImpl
implements StateWrapper {
    private static final String TAG = "StateWrapperImpl";
    @DoNotStrip
    private final HybridData mHybridData = StateWrapperImpl.initHybrid();
    private volatile boolean mDestroyed = false;

    private StateWrapperImpl() {
    }

    private static native HybridData initHybrid();

    private native ReadableNativeMap getStateDataImpl();

    private native ReadableMapBuffer getStateMapBufferDataImpl();

    public native void updateStateImpl(@NonNull NativeMap var1);

    @Override
    @Nullable
    public ReadableMapBuffer getStateDataMapBuffer() {
        if (this.mDestroyed) {
            FLog.e((String)TAG, (String)"Race between StateWrapperImpl destruction and getState");
            return null;
        }
        return this.getStateMapBufferDataImpl();
    }

    @Override
    @Nullable
    public ReadableNativeMap getStateData() {
        if (this.mDestroyed) {
            FLog.e((String)TAG, (String)"Race between StateWrapperImpl destruction and getState");
            return null;
        }
        return this.getStateDataImpl();
    }

    @Override
    public void updateState(@NonNull WritableMap map) {
        if (this.mDestroyed) {
            FLog.e((String)TAG, (String)"Race between StateWrapperImpl destruction and updateState");
            return;
        }
        this.updateStateImpl((NativeMap)((Object)map));
    }

    @Override
    public void destroyState() {
        if (!this.mDestroyed) {
            this.mDestroyed = true;
            this.mHybridData.resetNative();
        }
    }

    public String toString() {
        if (this.mDestroyed) {
            return "<destroyed>";
        }
        ReadableNativeMap map = this.getStateDataImpl();
        if (map == null) {
            return "<unexpected null>";
        }
        return map.toString();
    }

    static {
        FabricSoLoader.staticInit();
    }
}

