/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import android.view.Choreographer;
import androidx.annotation.NonNull;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.JSExceptionHandler;
import com.facebook.react.bridge.ReactContext;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public abstract class GuardedFrameCallback
implements Choreographer.FrameCallback {
    @NonNull
    private final JSExceptionHandler mExceptionHandler;

    protected GuardedFrameCallback(@NonNull ReactContext reactContext) {
        this(reactContext.getExceptionHandler());
    }

    protected GuardedFrameCallback(@NonNull JSExceptionHandler exceptionHandler) {
        this.mExceptionHandler = exceptionHandler;
    }

    public final void doFrame(long frameTimeNanos) {
        try {
            this.doFrameGuarded(frameTimeNanos);
        }
        catch (RuntimeException e) {
            this.mExceptionHandler.handleException(e);
        }
    }

    protected abstract void doFrameGuarded(long var1);
}

