/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.view.animation.Animation;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.touch.OnInterceptTouchEventListener;
import com.facebook.react.touch.ReactHitSlopView;
import com.facebook.react.touch.ReactInterceptingViewGroup;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.MeasureSpecAssertions;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactClippingProhibitedView;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import com.facebook.react.uimanager.ReactClippingViewGroupHelper;
import com.facebook.react.uimanager.ReactOverflowViewWithInset;
import com.facebook.react.uimanager.ReactPointerEventsView;
import com.facebook.react.uimanager.ReactZIndexedViewGroup;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.RootViewUtil;
import com.facebook.react.uimanager.ViewGroupDrawingOrderHelper;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.views.view.CanvasUtil;
import com.facebook.react.views.view.ReactViewBackgroundDrawable;
import com.facebook.yoga.YogaConstants;

public class ReactViewGroup
extends ViewGroup
implements ReactInterceptingViewGroup,
ReactClippingViewGroup,
ReactPointerEventsView,
ReactHitSlopView,
ReactZIndexedViewGroup,
ReactOverflowViewWithInset {
    private static final int ARRAY_CAPACITY_INCREMENT = 12;
    private static final int DEFAULT_BACKGROUND_COLOR = 0;
    private static final ViewGroup.LayoutParams sDefaultLayoutParam = new ViewGroup.LayoutParams(0, 0);
    private final Rect mOverflowInset = new Rect();
    private static final Rect sHelperRect = new Rect();
    private boolean mRemoveClippedSubviews;
    @Nullable
    private View[] mAllChildren;
    private int mAllChildrenCount;
    @Nullable
    private Rect mClippingRect;
    @Nullable
    private Rect mHitSlopRect;
    @Nullable
    private String mOverflow;
    private PointerEvents mPointerEvents;
    @Nullable
    private ChildrenLayoutChangeListener mChildrenLayoutChangeListener;
    @Nullable
    private ReactViewBackgroundDrawable mReactBackgroundDrawable;
    @Nullable
    private OnInterceptTouchEventListener mOnInterceptTouchEventListener;
    private boolean mNeedsOffscreenAlphaCompositing;
    @Nullable
    private ViewGroupDrawingOrderHelper mDrawingOrderHelper;
    @Nullable
    private Path mPath;
    private int mLayoutDirection;
    private float mBackfaceOpacity;
    private String mBackfaceVisibility;

    public ReactViewGroup(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.setClipChildren(false);
        this.mRemoveClippedSubviews = false;
        this.mAllChildren = null;
        this.mAllChildrenCount = 0;
        this.mClippingRect = null;
        this.mHitSlopRect = null;
        this.mOverflow = null;
        this.mPointerEvents = PointerEvents.AUTO;
        this.mChildrenLayoutChangeListener = null;
        this.mReactBackgroundDrawable = null;
        this.mOnInterceptTouchEventListener = null;
        this.mNeedsOffscreenAlphaCompositing = false;
        this.mDrawingOrderHelper = null;
        this.mPath = null;
        this.mLayoutDirection = 0;
        this.mBackfaceOpacity = 1.0f;
        this.mBackfaceVisibility = "visible";
    }

    void recycleView() {
        this.initView();
        this.mOverflowInset.setEmpty();
        sHelperRect.setEmpty();
        this.removeAllViews();
        this.updateBackgroundDrawable(null);
        this.resetPointerEvents();
    }

    private ViewGroupDrawingOrderHelper getDrawingOrderHelper() {
        if (this.mDrawingOrderHelper == null) {
            this.mDrawingOrderHelper = new ViewGroupDrawingOrderHelper(this);
        }
        return this.mDrawingOrderHelper;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecAssertions.assertExplicitMeasureSpec(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        if (this.mReactBackgroundDrawable != null) {
            this.mReactBackgroundDrawable.setResolvedLayoutDirection(this.mLayoutDirection);
        }
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void requestLayout() {
    }

    @TargetApi(value=23)
    public void dispatchProvideStructure(ViewStructure structure) {
        try {
            super.dispatchProvideStructure(structure);
        }
        catch (NullPointerException e) {
            FLog.e((String)"ReactNative", (String)"NullPointerException when executing dispatchProvideStructure", (Throwable)e);
        }
    }

    public void setBackgroundColor(int color) {
        if (color != 0 || this.mReactBackgroundDrawable != null) {
            this.getOrCreateReactViewBackground().setColor(color);
        }
    }

    public void setBackground(Drawable drawable) {
        throw new UnsupportedOperationException("This method is not supported for ReactViewGroup instances");
    }

    public void setTranslucentBackgroundDrawable(@Nullable Drawable background) {
        this.updateBackgroundDrawable(null);
        if (this.mReactBackgroundDrawable != null && background != null) {
            LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mReactBackgroundDrawable, background});
            this.updateBackgroundDrawable((Drawable)layerDrawable);
        } else if (background != null) {
            this.updateBackgroundDrawable(background);
        }
    }

    @Override
    public void setOnInterceptTouchEventListener(OnInterceptTouchEventListener listener) {
        this.mOnInterceptTouchEventListener = listener;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mOnInterceptTouchEventListener != null && this.mOnInterceptTouchEventListener.onInterceptTouchEvent(this, ev)) {
            return true;
        }
        if (!PointerEvents.canChildrenBeTouchTarget(this.mPointerEvents)) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        return PointerEvents.canBeTouchTarget(this.mPointerEvents);
    }

    public boolean dispatchGenericPointerEvent(MotionEvent ev) {
        if (!PointerEvents.canChildrenBeTouchTarget(this.mPointerEvents)) {
            return false;
        }
        return super.dispatchGenericPointerEvent(ev);
    }

    public boolean hasOverlappingRendering() {
        return this.mNeedsOffscreenAlphaCompositing;
    }

    public void setNeedsOffscreenAlphaCompositing(boolean needsOffscreenAlphaCompositing) {
        this.mNeedsOffscreenAlphaCompositing = needsOffscreenAlphaCompositing;
    }

    public void setBorderWidth(int position, float width) {
        this.getOrCreateReactViewBackground().setBorderWidth(position, width);
    }

    public void setBorderColor(int position, float rgb, float alpha) {
        this.getOrCreateReactViewBackground().setBorderColor(position, rgb, alpha);
    }

    public void setBorderRadius(float borderRadius) {
        ReactViewBackgroundDrawable backgroundDrawable = this.getOrCreateReactViewBackground();
        backgroundDrawable.setRadius(borderRadius);
    }

    public void setBorderRadius(float borderRadius, int position) {
        ReactViewBackgroundDrawable backgroundDrawable = this.getOrCreateReactViewBackground();
        backgroundDrawable.setRadius(borderRadius, position);
    }

    public void setBorderStyle(@Nullable String style2) {
        this.getOrCreateReactViewBackground().setBorderStyle(style2);
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (removeClippedSubviews == this.mRemoveClippedSubviews) {
            return;
        }
        this.mRemoveClippedSubviews = removeClippedSubviews;
        if (removeClippedSubviews) {
            this.mClippingRect = new Rect();
            ReactClippingViewGroupHelper.calculateClippingRect((View)this, this.mClippingRect);
            this.mAllChildrenCount = this.getChildCount();
            int initialSize = Math.max(12, this.mAllChildrenCount);
            this.mAllChildren = new View[initialSize];
            this.mChildrenLayoutChangeListener = new ChildrenLayoutChangeListener(this);
            for (int i = 0; i < this.mAllChildrenCount; ++i) {
                View child;
                this.mAllChildren[i] = child = this.getChildAt(i);
                child.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
            }
            this.updateClippingRect();
        } else {
            Assertions.assertNotNull((Object)this.mClippingRect);
            Assertions.assertNotNull((Object)this.mAllChildren);
            Assertions.assertNotNull((Object)this.mChildrenLayoutChangeListener);
            for (int i = 0; i < this.mAllChildrenCount; ++i) {
                this.mAllChildren[i].removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
            }
            this.getDrawingRect(this.mClippingRect);
            this.updateClippingToRect(this.mClippingRect);
            this.mAllChildren = null;
            this.mClippingRect = null;
            this.mAllChildrenCount = 0;
            this.mChildrenLayoutChangeListener = null;
        }
    }

    @Override
    public boolean getRemoveClippedSubviews() {
        return this.mRemoveClippedSubviews;
    }

    @Override
    public void getClippingRect(Rect outClippingRect) {
        outClippingRect.set(this.mClippingRect);
    }

    @Override
    public void updateClippingRect() {
        if (!this.mRemoveClippedSubviews) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        Assertions.assertNotNull((Object)this.mAllChildren);
        ReactClippingViewGroupHelper.calculateClippingRect((View)this, this.mClippingRect);
        this.updateClippingToRect(this.mClippingRect);
    }

    private void updateClippingToRect(Rect clippingRect) {
        Assertions.assertNotNull((Object)this.mAllChildren);
        int clippedSoFar = 0;
        for (int i = 0; i < this.mAllChildrenCount; ++i) {
            this.updateSubviewClipStatus(clippingRect, i, clippedSoFar);
            if (this.mAllChildren[i].getParent() != null) continue;
            ++clippedSoFar;
        }
    }

    private void updateSubviewClipStatus(Rect clippingRect, int idx, int clippedSoFar) {
        ReactClippingViewGroup clippingChild;
        boolean isAnimating;
        UiThreadUtil.assertOnUiThread();
        View child = ((View[])Assertions.assertNotNull((Object)this.mAllChildren))[idx];
        sHelperRect.set(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        boolean intersects = clippingRect.intersects(ReactViewGroup.sHelperRect.left, ReactViewGroup.sHelperRect.top, ReactViewGroup.sHelperRect.right, ReactViewGroup.sHelperRect.bottom);
        boolean needUpdateClippingRecursive = false;
        Animation animation = child.getAnimation();
        boolean bl = isAnimating = animation != null && !animation.hasEnded();
        if (!intersects && child.getParent() != null && !isAnimating) {
            super.removeViewsInLayout(idx - clippedSoFar, 1);
            needUpdateClippingRecursive = true;
        } else if (intersects && child.getParent() == null) {
            super.addViewInLayout(child, idx - clippedSoFar, sDefaultLayoutParam, true);
            this.invalidate();
            needUpdateClippingRecursive = true;
        } else if (intersects) {
            needUpdateClippingRecursive = true;
        }
        if (needUpdateClippingRecursive && child instanceof ReactClippingViewGroup && (clippingChild = (ReactClippingViewGroup)child).getRemoveClippedSubviews()) {
            clippingChild.updateClippingRect();
        }
    }

    private void updateSubviewClipStatus(View subview) {
        boolean oldIntersects;
        if (!this.mRemoveClippedSubviews || this.getParent() == null) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        Assertions.assertNotNull((Object)this.mAllChildren);
        sHelperRect.set(subview.getLeft(), subview.getTop(), subview.getRight(), subview.getBottom());
        boolean intersects = this.mClippingRect.intersects(ReactViewGroup.sHelperRect.left, ReactViewGroup.sHelperRect.top, ReactViewGroup.sHelperRect.right, ReactViewGroup.sHelperRect.bottom);
        boolean bl = oldIntersects = subview.getParent() != null;
        if (intersects != oldIntersects) {
            int clippedSoFar = 0;
            for (int i = 0; i < this.mAllChildrenCount; ++i) {
                if (this.mAllChildren[i] == subview) {
                    this.updateSubviewClipStatus(this.mClippingRect, i, clippedSoFar);
                    break;
                }
                if (this.mAllChildren[i].getParent() != null) continue;
                ++clippedSoFar;
            }
        }
    }

    public boolean getChildVisibleRect(View child, Rect r, Point offset) {
        return super.getChildVisibleRect(child, r, offset);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    private boolean customDrawOrderDisabled() {
        if (this.getId() == -1) {
            return false;
        }
        return ViewUtil.getUIManagerType(this.getId()) == 2;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (!this.customDrawOrderDisabled()) {
            this.getDrawingOrderHelper().handleAddView(child);
            this.setChildrenDrawingOrderEnabled(this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder());
        } else {
            this.setChildrenDrawingOrderEnabled(false);
        }
        super.addView(child, index, params);
    }

    public void removeView(View view) {
        UiThreadUtil.assertOnUiThread();
        if (!this.customDrawOrderDisabled()) {
            this.getDrawingOrderHelper().handleRemoveView(view);
            this.setChildrenDrawingOrderEnabled(this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder());
        } else {
            this.setChildrenDrawingOrderEnabled(false);
        }
        super.removeView(view);
    }

    public void removeViewAt(int index) {
        UiThreadUtil.assertOnUiThread();
        if (!this.customDrawOrderDisabled()) {
            this.getDrawingOrderHelper().handleRemoveView(this.getChildAt(index));
            this.setChildrenDrawingOrderEnabled(this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder());
        } else {
            this.setChildrenDrawingOrderEnabled(false);
        }
        super.removeViewAt(index);
    }

    protected int getChildDrawingOrder(int childCount, int index) {
        UiThreadUtil.assertOnUiThread();
        if (!this.customDrawOrderDisabled()) {
            return this.getDrawingOrderHelper().getChildDrawingOrder(childCount, index);
        }
        return index;
    }

    @Override
    public int getZIndexMappedChildIndex(int index) {
        UiThreadUtil.assertOnUiThread();
        if (!this.customDrawOrderDisabled() && this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder()) {
            return this.getDrawingOrderHelper().getChildDrawingOrder(this.getChildCount(), index);
        }
        return index;
    }

    @Override
    public void updateDrawingOrder() {
        if (this.customDrawOrderDisabled()) {
            return;
        }
        this.getDrawingOrderHelper().update();
        this.setChildrenDrawingOrderEnabled(this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder());
        this.invalidate();
    }

    @Override
    public PointerEvents getPointerEvents() {
        return this.mPointerEvents;
    }

    protected void dispatchSetPressed(boolean pressed) {
    }

    void setPointerEvents(PointerEvents pointerEvents) {
        this.mPointerEvents = pointerEvents;
    }

    void resetPointerEvents() {
        this.mPointerEvents = PointerEvents.AUTO;
    }

    int getAllChildrenCount() {
        return this.mAllChildrenCount;
    }

    View getChildAtWithSubviewClippingEnabled(int index) {
        return ((View[])Assertions.assertNotNull((Object)this.mAllChildren))[index];
    }

    void addViewWithSubviewClippingEnabled(View child, int index) {
        this.addViewWithSubviewClippingEnabled(child, index, sDefaultLayoutParam);
    }

    void addViewWithSubviewClippingEnabled(final View child, int index, ViewGroup.LayoutParams params) {
        Assertions.assertCondition((boolean)this.mRemoveClippedSubviews);
        Assertions.assertNotNull((Object)this.mClippingRect);
        Assertions.assertNotNull((Object)this.mAllChildren);
        this.addInArray(child, index);
        int clippedSoFar = 0;
        for (int i = 0; i < index; ++i) {
            if (this.mAllChildren[i].getParent() != null) continue;
            ++clippedSoFar;
        }
        this.updateSubviewClipStatus(this.mClippingRect, index, clippedSoFar);
        child.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
        if (child instanceof ReactClippingProhibitedView) {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!child.isShown()) {
                        ReactSoftExceptionLogger.logSoftException("ReactNative", new ReactNoCrashSoftException("Child view has been added to Parent view in which it is clipped and not visible. This is not legal for this particular child view. Child: [" + child.getId() + "] " + child.toString() + " Parent: [" + ReactViewGroup.this.getId() + "] " + this.toString()));
                    }
                }
            });
        }
    }

    void removeViewWithSubviewClippingEnabled(View view) {
        UiThreadUtil.assertOnUiThread();
        Assertions.assertCondition((boolean)this.mRemoveClippedSubviews);
        Assertions.assertNotNull((Object)this.mClippingRect);
        Assertions.assertNotNull((Object)this.mAllChildren);
        view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
        int index = this.indexOfChildInAllChildren(view);
        if (this.mAllChildren[index].getParent() != null) {
            int clippedSoFar = 0;
            for (int i = 0; i < index; ++i) {
                if (this.mAllChildren[i].getParent() != null) continue;
                ++clippedSoFar;
            }
            super.removeViewsInLayout(index - clippedSoFar, 1);
        }
        this.removeFromArray(index);
    }

    void removeAllViewsWithSubviewClippingEnabled() {
        Assertions.assertCondition((boolean)this.mRemoveClippedSubviews);
        Assertions.assertNotNull((Object)this.mAllChildren);
        for (int i = 0; i < this.mAllChildrenCount; ++i) {
            this.mAllChildren[i].removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
        }
        this.removeAllViewsInLayout();
        this.mAllChildrenCount = 0;
    }

    private int indexOfChildInAllChildren(View child) {
        int count = this.mAllChildrenCount;
        View[] children = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        for (int i = 0; i < count; ++i) {
            if (children[i] != child) continue;
            return i;
        }
        return -1;
    }

    private void addInArray(View child, int index) {
        View[] children = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        int count = this.mAllChildrenCount;
        int size = children.length;
        if (index == count) {
            if (size == count) {
                this.mAllChildren = new View[size + 12];
                System.arraycopy(children, 0, this.mAllChildren, 0, size);
                children = this.mAllChildren;
            }
            children[this.mAllChildrenCount++] = child;
        } else if (index < count) {
            if (size == count) {
                this.mAllChildren = new View[size + 12];
                System.arraycopy(children, 0, this.mAllChildren, 0, index);
                System.arraycopy(children, index, this.mAllChildren, index + 1, count - index);
                children = this.mAllChildren;
            } else {
                System.arraycopy(children, index, children, index + 1, count - index);
            }
            children[index] = child;
            ++this.mAllChildrenCount;
        } else {
            throw new IndexOutOfBoundsException("index=" + index + " count=" + count);
        }
    }

    private void removeFromArray(int index) {
        int count;
        View[] children = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        if (index == (count = this.mAllChildrenCount--) - 1) {
            children[this.mAllChildrenCount] = null;
        } else if (index >= 0 && index < count) {
            System.arraycopy(children, index + 1, children, index, count - index - 1);
            children[--this.mAllChildrenCount] = null;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @VisibleForTesting
    public int getBackgroundColor() {
        if (this.getBackground() != null) {
            return ((ReactViewBackgroundDrawable)this.getBackground()).getColor();
        }
        return 0;
    }

    ReactViewBackgroundDrawable getOrCreateReactViewBackground() {
        if (this.mReactBackgroundDrawable == null) {
            this.mReactBackgroundDrawable = new ReactViewBackgroundDrawable(this.getContext());
            Drawable backgroundDrawable = this.getBackground();
            this.updateBackgroundDrawable(null);
            if (backgroundDrawable == null) {
                this.updateBackgroundDrawable(this.mReactBackgroundDrawable);
            } else {
                LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mReactBackgroundDrawable, backgroundDrawable});
                this.updateBackgroundDrawable((Drawable)layerDrawable);
            }
            this.mLayoutDirection = I18nUtil.getInstance().isRTL(this.getContext()) ? 1 : 0;
            this.mReactBackgroundDrawable.setResolvedLayoutDirection(this.mLayoutDirection);
        }
        return this.mReactBackgroundDrawable;
    }

    @Override
    @Nullable
    public Rect getHitSlopRect() {
        return this.mHitSlopRect;
    }

    public void setHitSlopRect(@Nullable Rect rect) {
        this.mHitSlopRect = rect;
    }

    public void setOverflow(String overflow) {
        this.mOverflow = overflow;
        this.invalidate();
    }

    @Override
    @Nullable
    public String getOverflow() {
        return this.mOverflow;
    }

    @Override
    public void setOverflowInset(int left, int top, int right, int bottom) {
        this.mOverflowInset.set(left, top, right, bottom);
    }

    @Override
    public Rect getOverflowInset() {
        return this.mOverflowInset;
    }

    void updateBackgroundDrawable(Drawable drawable) {
        super.setBackground(drawable);
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            this.dispatchOverflowDraw(canvas);
            super.dispatchDraw(canvas);
        }
        catch (NullPointerException | StackOverflowError e) {
            RootView rootView = RootViewUtil.getRootView((View)this);
            if (rootView != null) {
                rootView.handleException(e);
            }
            if (this.getContext() instanceof ReactContext) {
                ReactContext reactContext = (ReactContext)this.getContext();
                reactContext.handleException(new IllegalViewOperationException("StackOverflowException", (View)this, e));
            }
            throw e;
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean drawWithZ;
        boolean bl = drawWithZ = child.getElevation() > 0.0f;
        if (drawWithZ) {
            CanvasUtil.enableZ(canvas, true);
        }
        boolean result = super.drawChild(canvas, child, drawingTime);
        if (drawWithZ) {
            CanvasUtil.enableZ(canvas, false);
        }
        return result;
    }

    private void dispatchOverflowDraw(Canvas canvas) {
        if (this.mOverflow != null) {
            switch (this.mOverflow) {
                case "visible": {
                    if (this.mPath == null) break;
                    this.mPath.rewind();
                    break;
                }
                case "hidden": 
                case "scroll": {
                    float left = 0.0f;
                    float top = 0.0f;
                    float right = this.getWidth();
                    float bottom = this.getHeight();
                    boolean hasClipPath = false;
                    if (this.mReactBackgroundDrawable != null) {
                        RectF borderWidth = this.mReactBackgroundDrawable.getDirectionAwareBorderInsets();
                        if (borderWidth.top > 0.0f || borderWidth.left > 0.0f || borderWidth.bottom > 0.0f || borderWidth.right > 0.0f) {
                            left += borderWidth.left;
                            top += borderWidth.top;
                            right -= borderWidth.right;
                            bottom -= borderWidth.bottom;
                        }
                        float borderRadius = this.mReactBackgroundDrawable.getFullBorderRadius();
                        float topLeftBorderRadius = this.mReactBackgroundDrawable.getBorderRadiusOrDefaultTo(borderRadius, ReactViewBackgroundDrawable.BorderRadiusLocation.TOP_LEFT);
                        float topRightBorderRadius = this.mReactBackgroundDrawable.getBorderRadiusOrDefaultTo(borderRadius, ReactViewBackgroundDrawable.BorderRadiusLocation.TOP_RIGHT);
                        float bottomLeftBorderRadius = this.mReactBackgroundDrawable.getBorderRadiusOrDefaultTo(borderRadius, ReactViewBackgroundDrawable.BorderRadiusLocation.BOTTOM_LEFT);
                        float bottomRightBorderRadius = this.mReactBackgroundDrawable.getBorderRadiusOrDefaultTo(borderRadius, ReactViewBackgroundDrawable.BorderRadiusLocation.BOTTOM_RIGHT);
                        boolean isRTL = this.mLayoutDirection == 1;
                        float topStartBorderRadius = this.mReactBackgroundDrawable.getBorderRadius(ReactViewBackgroundDrawable.BorderRadiusLocation.TOP_START);
                        float topEndBorderRadius = this.mReactBackgroundDrawable.getBorderRadius(ReactViewBackgroundDrawable.BorderRadiusLocation.TOP_END);
                        float bottomStartBorderRadius = this.mReactBackgroundDrawable.getBorderRadius(ReactViewBackgroundDrawable.BorderRadiusLocation.BOTTOM_START);
                        float bottomEndBorderRadius = this.mReactBackgroundDrawable.getBorderRadius(ReactViewBackgroundDrawable.BorderRadiusLocation.BOTTOM_END);
                        if (I18nUtil.getInstance().doLeftAndRightSwapInRTL(this.getContext())) {
                            if (YogaConstants.isUndefined(topStartBorderRadius)) {
                                topStartBorderRadius = topLeftBorderRadius;
                            }
                            if (YogaConstants.isUndefined(topEndBorderRadius)) {
                                topEndBorderRadius = topRightBorderRadius;
                            }
                            if (YogaConstants.isUndefined(bottomStartBorderRadius)) {
                                bottomStartBorderRadius = bottomLeftBorderRadius;
                            }
                            if (YogaConstants.isUndefined(bottomEndBorderRadius)) {
                                bottomEndBorderRadius = bottomRightBorderRadius;
                            }
                            float directionAwareTopLeftRadius = isRTL ? topEndBorderRadius : topStartBorderRadius;
                            float directionAwareTopRightRadius = isRTL ? topStartBorderRadius : topEndBorderRadius;
                            float directionAwareBottomLeftRadius = isRTL ? bottomEndBorderRadius : bottomStartBorderRadius;
                            float directionAwareBottomRightRadius = isRTL ? bottomStartBorderRadius : bottomEndBorderRadius;
                            topLeftBorderRadius = directionAwareTopLeftRadius;
                            topRightBorderRadius = directionAwareTopRightRadius;
                            bottomLeftBorderRadius = directionAwareBottomLeftRadius;
                            bottomRightBorderRadius = directionAwareBottomRightRadius;
                        } else {
                            float directionAwareBottomRightRadius;
                            float directionAwareTopLeftRadius = isRTL ? topEndBorderRadius : topStartBorderRadius;
                            float directionAwareTopRightRadius = isRTL ? topStartBorderRadius : topEndBorderRadius;
                            float directionAwareBottomLeftRadius = isRTL ? bottomEndBorderRadius : bottomStartBorderRadius;
                            float f = directionAwareBottomRightRadius = isRTL ? bottomStartBorderRadius : bottomEndBorderRadius;
                            if (!YogaConstants.isUndefined(directionAwareTopLeftRadius)) {
                                topLeftBorderRadius = directionAwareTopLeftRadius;
                            }
                            if (!YogaConstants.isUndefined(directionAwareTopRightRadius)) {
                                topRightBorderRadius = directionAwareTopRightRadius;
                            }
                            if (!YogaConstants.isUndefined(directionAwareBottomLeftRadius)) {
                                bottomLeftBorderRadius = directionAwareBottomLeftRadius;
                            }
                            if (!YogaConstants.isUndefined(directionAwareBottomRightRadius)) {
                                bottomRightBorderRadius = directionAwareBottomRightRadius;
                            }
                        }
                        if (topLeftBorderRadius > 0.0f || topRightBorderRadius > 0.0f || bottomRightBorderRadius > 0.0f || bottomLeftBorderRadius > 0.0f) {
                            if (this.mPath == null) {
                                this.mPath = new Path();
                            }
                            this.mPath.rewind();
                            this.mPath.addRoundRect(new RectF(left, top, right, bottom), new float[]{Math.max(topLeftBorderRadius - borderWidth.left, 0.0f), Math.max(topLeftBorderRadius - borderWidth.top, 0.0f), Math.max(topRightBorderRadius - borderWidth.right, 0.0f), Math.max(topRightBorderRadius - borderWidth.top, 0.0f), Math.max(bottomRightBorderRadius - borderWidth.right, 0.0f), Math.max(bottomRightBorderRadius - borderWidth.bottom, 0.0f), Math.max(bottomLeftBorderRadius - borderWidth.left, 0.0f), Math.max(bottomLeftBorderRadius - borderWidth.bottom, 0.0f)}, Path.Direction.CW);
                            canvas.clipPath(this.mPath);
                            hasClipPath = true;
                        }
                    }
                    if (hasClipPath) break;
                    canvas.clipRect(new RectF(left, top, right, bottom));
                    break;
                }
            }
        }
    }

    public void setOpacityIfPossible(float opacity) {
        this.mBackfaceOpacity = opacity;
        this.setBackfaceVisibilityDependantOpacity();
    }

    public void setBackfaceVisibility(String backfaceVisibility) {
        this.mBackfaceVisibility = backfaceVisibility;
        this.setBackfaceVisibilityDependantOpacity();
    }

    public void setBackfaceVisibilityDependantOpacity() {
        boolean isFrontfaceVisible;
        boolean isBackfaceVisible = this.mBackfaceVisibility.equals("visible");
        if (isBackfaceVisible) {
            this.setAlpha(this.mBackfaceOpacity);
            return;
        }
        float rotationX = this.getRotationX();
        float rotationY = this.getRotationY();
        boolean bl = isFrontfaceVisible = rotationX >= -90.0f && rotationX < 90.0f && rotationY >= -90.0f && rotationY < 90.0f;
        if (isFrontfaceVisible) {
            this.setAlpha(this.mBackfaceOpacity);
            return;
        }
        this.setAlpha(0.0f);
    }

    private static final class ChildrenLayoutChangeListener
    implements View.OnLayoutChangeListener {
        private final ReactViewGroup mParent;

        private ChildrenLayoutChangeListener(ReactViewGroup parent) {
            this.mParent = parent;
        }

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            if (this.mParent.getRemoveClippedSubviews()) {
                this.mParent.updateSubviewClipStatus(v);
            }
        }
    }
}

