/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.graphics.Rect;
import android.view.View;
import androidx.core.view.ViewCompat;
import com.facebook.react.R;
import com.facebook.react.bridge.DynamicFromObject;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.views.view.ReactViewGroup;
import com.facebook.react.views.view.ReactViewManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\bS\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^J\u001c\u0010_\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010`\u001a\u00020^H\u0002J\u001c\u0010a\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020^H\u0002J\u0014\u0010c\u001a\u00020X*\u00020Z2\u0006\u0010b\u001a\u00020\u0004H\u0002J\u001c\u0010d\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020^H\u0002J\u001c\u0010e\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020fH\u0002J\u001c\u0010g\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020\u0004H\u0002J\u001c\u0010h\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020\u0004H\u0002J\u001c\u0010i\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020^H\u0002J\u001c\u0010j\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020^H\u0002J\u001c\u0010k\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020\u0004H\u0002J\u001c\u0010l\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020^H\u0002J\u0014\u0010m\u001a\u00020X*\u00020Z2\u0006\u0010b\u001a\u00020^H\u0002J\u0014\u0010n\u001a\u00020X*\u00020Z2\u0006\u0010b\u001a\u00020\u0004H\u0002J\u001c\u0010o\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020^H\u0002J\u001c\u0010p\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020^H\u0002J\u001c\u0010q\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020\u0004H\u0002J\u0014\u0010r\u001a\u00020X*\u00020Z2\u0006\u0010b\u001a\u00020\u0004H\u0002J\u0014\u0010s\u001a\u00020X*\u00020Z2\u0006\u0010b\u001a\u00020\u0004H\u0002J\u001c\u0010t\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020\u0004H\u0002J\u000e\u0010u\u001a\u0004\u0018\u00010v*\u00020^H\u0002J\u001c\u0010w\u001a\u00020X*\u00020\\2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010b\u001a\u00020^H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010V\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006x"}, d2={"Lcom/facebook/react/views/view/ReactMapBufferPropSetter;", "", "()V", "ACCESSIBILITY_ACTION_LABEL", "", "ACCESSIBILITY_ACTION_NAME", "ACCESSIBILITY_STATE_BUSY", "ACCESSIBILITY_STATE_CHECKED", "ACCESSIBILITY_STATE_DISABLED", "ACCESSIBILITY_STATE_EXPANDED", "ACCESSIBILITY_STATE_SELECTED", "CORNER_ALL", "CORNER_BOTTOM_END", "CORNER_BOTTOM_LEFT", "CORNER_BOTTOM_RIGHT", "CORNER_BOTTOM_START", "CORNER_END_END", "CORNER_END_START", "CORNER_START_END", "CORNER_START_START", "CORNER_TOP_END", "CORNER_TOP_LEFT", "CORNER_TOP_RIGHT", "CORNER_TOP_START", "EDGE_ALL", "EDGE_BLOCK", "EDGE_BLOCK_END", "EDGE_BLOCK_START", "EDGE_BOTTOM", "EDGE_END", "EDGE_LEFT", "EDGE_RIGHT", "EDGE_START", "EDGE_TOP", "NATIVE_DRAWABLE_ATTRIBUTE", "NATIVE_DRAWABLE_BORDERLESS", "NATIVE_DRAWABLE_COLOR", "NATIVE_DRAWABLE_KIND", "NATIVE_DRAWABLE_RIPPLE_RADIUS", "UNDEF_COLOR", "VP_ACCESSIBILITY_ACTIONS", "VP_ACCESSIBILITY_HINT", "VP_ACCESSIBILITY_LABEL", "VP_ACCESSIBILITY_LABELLED_BY", "VP_ACCESSIBILITY_LIVE_REGION", "VP_ACCESSIBILITY_ROLE", "VP_ACCESSIBILITY_STATE", "VP_ACCESSIBILITY_VALUE", "VP_ACCESSIBLE", "VP_BACKFACE_VISIBILITY", "VP_BG_COLOR", "VP_BORDER_COLOR", "VP_BORDER_CURVES", "VP_BORDER_RADII", "VP_BORDER_STYLE", "VP_COLLAPSABLE", "VP_ELEVATION", "VP_FG_COLOR", "VP_FOCUSABLE", "VP_HAS_TV_FOCUS", "VP_HIT_SLOP", "VP_IMPORTANT_FOR_ACCESSIBILITY", "VP_NATIVE_BACKGROUND", "VP_NATIVE_FOREGROUND", "VP_NATIVE_ID", "VP_OFFSCREEN_ALPHA_COMPOSITING", "VP_OPACITY", "VP_POINTER_ENTER", "VP_POINTER_ENTER_CAPTURE", "VP_POINTER_EVENTS", "VP_POINTER_LEAVE", "VP_POINTER_LEAVE_CAPTURE", "VP_POINTER_MOVE", "VP_POINTER_MOVE_CAPTURE", "VP_POINTER_OUT", "VP_POINTER_OUT_CAPTURE", "VP_POINTER_OVER", "VP_POINTER_OVER_CAPTURE", "VP_REMOVE_CLIPPED_SUBVIEW", "VP_RENDER_TO_HARDWARE_TEXTURE", "VP_ROLE", "VP_SHADOW_COLOR", "VP_TEST_ID", "VP_TRANSFORM", "VP_ZINDEX", "YG_BORDER_WIDTH", "YG_OVERFLOW", "setProps", "", "view", "Lcom/facebook/react/views/view/ReactViewGroup;", "viewManager", "Lcom/facebook/react/views/view/ReactViewManager;", "props", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "accessibilityActions", "mapBuffer", "accessibilityLabelledBy", "value", "accessibilityLiveRegion", "accessibilityState", "accessibilityValue", "", "backfaceVisibility", "backgroundColor", "borderColor", "borderRadius", "borderStyle", "borderWidth", "hitSlop", "importantForAccessibility", "nativeBackground", "nativeForeground", "overflow", "pointerEvents", "role", "shadowColor", "toJsDrawableDescription", "Lcom/facebook/react/bridge/ReadableMap;", "transform", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nReactMapBufferPropSetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactMapBufferPropSetter.kt\ncom/facebook/react/views/view/ReactMapBufferPropSetter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,527:1\n1#2:528\n*E\n"})
public final class ReactMapBufferPropSetter {
    @NotNull
    public static final ReactMapBufferPropSetter INSTANCE = new ReactMapBufferPropSetter();
    private static final int VP_ACCESSIBILITY_ACTIONS = 0;
    private static final int VP_ACCESSIBILITY_HINT = 1;
    private static final int VP_ACCESSIBILITY_LABEL = 2;
    private static final int VP_ACCESSIBILITY_LABELLED_BY = 3;
    private static final int VP_ACCESSIBILITY_LIVE_REGION = 4;
    private static final int VP_ACCESSIBILITY_ROLE = 5;
    private static final int VP_ACCESSIBILITY_STATE = 6;
    private static final int VP_ACCESSIBILITY_VALUE = 7;
    private static final int VP_ACCESSIBLE = 8;
    private static final int VP_BACKFACE_VISIBILITY = 9;
    private static final int VP_BG_COLOR = 10;
    private static final int VP_BORDER_COLOR = 11;
    private static final int VP_BORDER_RADII = 12;
    private static final int VP_BORDER_STYLE = 13;
    private static final int VP_COLLAPSABLE = 14;
    private static final int VP_ELEVATION = 15;
    private static final int VP_FOCUSABLE = 16;
    private static final int VP_HAS_TV_FOCUS = 17;
    private static final int VP_HIT_SLOP = 18;
    private static final int VP_IMPORTANT_FOR_ACCESSIBILITY = 19;
    private static final int VP_NATIVE_BACKGROUND = 20;
    private static final int VP_NATIVE_FOREGROUND = 21;
    private static final int VP_NATIVE_ID = 22;
    private static final int VP_OFFSCREEN_ALPHA_COMPOSITING = 23;
    private static final int VP_OPACITY = 24;
    private static final int VP_POINTER_EVENTS = 25;
    private static final int VP_POINTER_ENTER = 26;
    private static final int VP_POINTER_LEAVE = 27;
    private static final int VP_POINTER_MOVE = 28;
    private static final int VP_REMOVE_CLIPPED_SUBVIEW = 29;
    private static final int VP_RENDER_TO_HARDWARE_TEXTURE = 30;
    private static final int VP_SHADOW_COLOR = 31;
    private static final int VP_TEST_ID = 32;
    private static final int VP_TRANSFORM = 33;
    private static final int VP_ZINDEX = 34;
    private static final int VP_POINTER_ENTER_CAPTURE = 38;
    private static final int VP_POINTER_LEAVE_CAPTURE = 39;
    private static final int VP_POINTER_MOVE_CAPTURE = 40;
    private static final int VP_POINTER_OUT = 41;
    private static final int VP_POINTER_OUT_CAPTURE = 42;
    private static final int VP_POINTER_OVER = 43;
    private static final int VP_POINTER_OVER_CAPTURE = 44;
    private static final int VP_BORDER_CURVES = 45;
    private static final int VP_FG_COLOR = 46;
    private static final int VP_ROLE = 47;
    private static final int YG_BORDER_WIDTH = 100;
    private static final int YG_OVERFLOW = 101;
    private static final int ACCESSIBILITY_ACTION_NAME = 0;
    private static final int ACCESSIBILITY_ACTION_LABEL = 1;
    private static final int ACCESSIBILITY_STATE_BUSY = 0;
    private static final int ACCESSIBILITY_STATE_DISABLED = 1;
    private static final int ACCESSIBILITY_STATE_EXPANDED = 2;
    private static final int ACCESSIBILITY_STATE_SELECTED = 3;
    private static final int ACCESSIBILITY_STATE_CHECKED = 4;
    private static final int EDGE_TOP = 0;
    private static final int EDGE_LEFT = 1;
    private static final int EDGE_RIGHT = 2;
    private static final int EDGE_BOTTOM = 3;
    private static final int EDGE_START = 4;
    private static final int EDGE_END = 5;
    private static final int EDGE_ALL = 6;
    private static final int EDGE_BLOCK = 7;
    private static final int EDGE_BLOCK_END = 8;
    private static final int EDGE_BLOCK_START = 9;
    private static final int CORNER_TOP_LEFT = 0;
    private static final int CORNER_TOP_RIGHT = 1;
    private static final int CORNER_BOTTOM_RIGHT = 2;
    private static final int CORNER_BOTTOM_LEFT = 3;
    private static final int CORNER_TOP_START = 4;
    private static final int CORNER_TOP_END = 5;
    private static final int CORNER_BOTTOM_END = 6;
    private static final int CORNER_BOTTOM_START = 7;
    private static final int CORNER_ALL = 8;
    private static final int CORNER_END_END = 9;
    private static final int CORNER_END_START = 10;
    private static final int CORNER_START_END = 11;
    private static final int CORNER_START_START = 12;
    private static final int NATIVE_DRAWABLE_KIND = 0;
    private static final int NATIVE_DRAWABLE_ATTRIBUTE = 1;
    private static final int NATIVE_DRAWABLE_COLOR = 2;
    private static final int NATIVE_DRAWABLE_BORDERLESS = 3;
    private static final int NATIVE_DRAWABLE_RIPPLE_RADIUS = 4;
    private static final int UNDEF_COLOR = Integer.MAX_VALUE;

    private ReactMapBufferPropSetter() {
    }

    public final void setProps(@NotNull ReactViewGroup view, @NotNull ReactViewManager viewManager, @NotNull MapBuffer props) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)viewManager, (String)"viewManager");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        for (MapBuffer.Entry entry : props) {
            switch (entry.getKey()) {
                case 0: {
                    this.accessibilityActions(viewManager, view, entry.getMapBufferValue());
                    break;
                }
                case 1: {
                    String it;
                    String string2;
                    String string3 = string2 = entry.getStringValue();
                    View view2 = (View)view;
                    ReactViewManager reactViewManager = viewManager;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)it).length() > 0;
                    reactViewManager.setAccessibilityHint(view2, bl2 ? string2 : null);
                    break;
                }
                case 2: {
                    String string2;
                    String it = string2 = entry.getStringValue();
                    View view2 = (View)view;
                    ReactViewManager reactViewManager = viewManager;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)it).length() > 0;
                    reactViewManager.setAccessibilityLabel(view2, bl2 ? string2 : null);
                    break;
                }
                case 3: {
                    this.accessibilityLabelledBy(viewManager, view, entry.getMapBufferValue());
                    break;
                }
                case 4: {
                    this.accessibilityLiveRegion(view, entry.getIntValue());
                    break;
                }
                case 5: {
                    String string2;
                    String it = string2 = entry.getStringValue();
                    View view2 = (View)view;
                    ReactViewManager reactViewManager = viewManager;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)it).length() > 0;
                    reactViewManager.setAccessibilityRole(view2, bl2 ? string2 : null);
                    break;
                }
                case 6: {
                    this.accessibilityState(viewManager, view, entry.getMapBufferValue());
                    break;
                }
                case 7: {
                    this.accessibilityValue(viewManager, view, entry.getStringValue());
                    break;
                }
                case 8: {
                    viewManager.setAccessible(view, entry.getBooleanValue());
                    break;
                }
                case 9: {
                    this.backfaceVisibility(viewManager, view, entry.getIntValue());
                    break;
                }
                case 10: {
                    this.backgroundColor(viewManager, view, entry.getIntValue());
                    break;
                }
                case 46: {
                    break;
                }
                case 11: {
                    this.borderColor(viewManager, view, entry.getMapBufferValue());
                    break;
                }
                case 12: {
                    this.borderRadius(viewManager, view, entry.getMapBufferValue());
                    break;
                }
                case 13: {
                    MapBuffer styleBuffer = entry.getMapBufferValue();
                    if (!styleBuffer.contains(8)) break;
                    this.borderStyle(viewManager, view, (int)styleBuffer.getDouble(8));
                    break;
                }
                case 15: {
                    viewManager.setElevation((View)view, (float)entry.getDoubleValue());
                    break;
                }
                case 16: {
                    viewManager.setFocusable(view, entry.getBooleanValue());
                    break;
                }
                case 17: {
                    viewManager.setTVPreferredFocus(view, entry.getBooleanValue());
                    break;
                }
                case 18: {
                    this.hitSlop(view, entry.getMapBufferValue());
                    break;
                }
                case 19: {
                    this.importantForAccessibility(view, entry.getIntValue());
                    break;
                }
                case 47: {
                    this.role(view, entry.getIntValue());
                    break;
                }
                case 20: {
                    this.nativeBackground(viewManager, view, entry.getMapBufferValue());
                    break;
                }
                case 21: {
                    this.nativeForeground(viewManager, view, entry.getMapBufferValue());
                    break;
                }
                case 22: {
                    String string2;
                    String it = string2 = entry.getStringValue();
                    View view2 = (View)view;
                    ReactViewManager reactViewManager = viewManager;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)it).length() > 0;
                    reactViewManager.setNativeId(view2, bl2 ? string2 : null);
                    break;
                }
                case 23: {
                    viewManager.setNeedsOffscreenAlphaCompositing(view, entry.getBooleanValue());
                    break;
                }
                case 24: {
                    viewManager.setOpacity(view, (float)entry.getDoubleValue());
                    break;
                }
                case 25: {
                    this.pointerEvents(view, entry.getIntValue());
                    break;
                }
                case 26: {
                    viewManager.setPointerEnter((View)view, entry.getBooleanValue());
                    break;
                }
                case 27: {
                    viewManager.setPointerLeave((View)view, entry.getBooleanValue());
                    break;
                }
                case 28: {
                    viewManager.setPointerMove((View)view, entry.getBooleanValue());
                    break;
                }
                case 38: {
                    viewManager.setPointerEnterCapture((View)view, entry.getBooleanValue());
                    break;
                }
                case 39: {
                    viewManager.setPointerLeaveCapture((View)view, entry.getBooleanValue());
                    break;
                }
                case 40: {
                    viewManager.setPointerMoveCapture((View)view, entry.getBooleanValue());
                    break;
                }
                case 41: {
                    viewManager.setPointerOut((View)view, entry.getBooleanValue());
                    break;
                }
                case 42: {
                    viewManager.setPointerOutCapture((View)view, entry.getBooleanValue());
                    break;
                }
                case 43: {
                    viewManager.setPointerOver((View)view, entry.getBooleanValue());
                    break;
                }
                case 44: {
                    viewManager.setPointerOverCapture((View)view, entry.getBooleanValue());
                    break;
                }
                case 29: {
                    viewManager.setRemoveClippedSubviews(view, entry.getBooleanValue());
                    break;
                }
                case 30: {
                    viewManager.setRenderToHardwareTexture((View)view, entry.getBooleanValue());
                    break;
                }
                case 31: {
                    this.shadowColor(viewManager, view, entry.getIntValue());
                    break;
                }
                case 32: {
                    String string2;
                    String it = string2 = entry.getStringValue();
                    View view2 = (View)view;
                    ReactViewManager reactViewManager = viewManager;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)it).length() > 0;
                    reactViewManager.setTestId(view2, bl2 ? string2 : null);
                    break;
                }
                case 33: {
                    this.transform(viewManager, view, entry.getMapBufferValue());
                    break;
                }
                case 34: {
                    viewManager.setZIndex((View)view, entry.getIntValue());
                    break;
                }
                case 100: {
                    this.borderWidth(viewManager, view, entry.getMapBufferValue());
                    break;
                }
                case 101: {
                    this.overflow(viewManager, view, entry.getIntValue());
                }
            }
        }
    }

    private final void accessibilityActions(ReactViewManager $this$accessibilityActions, ReactViewGroup view, MapBuffer mapBuffer) {
        List actions = new ArrayList();
        for (MapBuffer.Entry entry : mapBuffer) {
            JavaOnlyMap map = new JavaOnlyMap();
            MapBuffer action = entry.getMapBufferValue();
            map.putString("name", action.getString(0));
            if (action.contains(1)) {
                map.putString("label", action.getString(1));
            }
            actions.add(map);
        }
        $this$accessibilityActions.setAccessibilityActions((View)view, JavaOnlyArray.from(actions));
    }

    private final void accessibilityLiveRegion(ReactViewGroup $this$accessibilityLiveRegion, int value) {
        int mode = switch (value) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            default -> 0;
        };
        ViewCompat.setAccessibilityLiveRegion((View)((View)$this$accessibilityLiveRegion), (int)mode);
    }

    private final void accessibilityState(ReactViewManager $this$accessibilityState, ReactViewGroup view, MapBuffer value) {
        JavaOnlyMap accessibilityState = new JavaOnlyMap();
        accessibilityState.putBoolean("selected", value.getBoolean(3));
        accessibilityState.putBoolean("busy", value.getBoolean(0));
        accessibilityState.putBoolean("expanded", value.getBoolean(2));
        accessibilityState.putBoolean("disabled", value.getBoolean(1));
        switch (value.getInt(4)) {
            case 0: {
                accessibilityState.putBoolean("checked", false);
                break;
            }
            case 1: {
                accessibilityState.putBoolean("checked", true);
                break;
            }
            case 2: {
                accessibilityState.putString("checked", "mixed");
            }
        }
        $this$accessibilityState.setViewState((View)view, accessibilityState);
    }

    private final void accessibilityValue(ReactViewManager $this$accessibilityValue, ReactViewGroup view, String value) {
        JavaOnlyMap map = new JavaOnlyMap();
        if (((CharSequence)value).length() > 0) {
            map.putString("text", value);
        }
        $this$accessibilityValue.setAccessibilityValue((View)view, map);
    }

    private final void accessibilityLabelledBy(ReactViewManager $this$accessibilityLabelledBy, ReactViewGroup view, MapBuffer value) {
        DynamicFromObject dynamicFromObject;
        if (value.getCount() == 0) {
            dynamicFromObject = new DynamicFromObject(null);
        } else {
            JavaOnlyArray array = new JavaOnlyArray();
            for (MapBuffer.Entry label : value) {
                array.pushString(label.getStringValue());
            }
            dynamicFromObject = new DynamicFromObject(array);
        }
        DynamicFromObject converted = dynamicFromObject;
        $this$accessibilityLabelledBy.setAccessibilityLabelledBy((View)view, converted);
    }

    private final void backfaceVisibility(ReactViewManager $this$backfaceVisibility, ReactViewGroup view, int value) {
        String stringName = switch (value) {
            case 1 -> "visible";
            case 2 -> "hidden";
            default -> "auto";
        };
        $this$backfaceVisibility.setBackfaceVisibility(view, stringName);
    }

    private final void backgroundColor(ReactViewManager $this$backgroundColor, ReactViewGroup view, int value) {
        Integer n = value;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it != Integer.MAX_VALUE ? n : null;
        int color = n2 != null ? n2 : 0;
        $this$backgroundColor.setBackgroundColor((View)view, color);
    }

    /*
     * WARNING - void declaration
     */
    private final void borderColor(ReactViewManager $this$borderColor, ReactViewGroup view, MapBuffer value) {
        for (MapBuffer.Entry entry : value) {
            void it;
            int key = entry.getKey();
            int index = switch (key) {
                case 6 -> 0;
                case 1 -> 1;
                case 2 -> 2;
                case 0 -> 3;
                case 3 -> 4;
                case 4 -> 5;
                case 5 -> 6;
                case 7 -> 7;
                case 8 -> 8;
                case 9 -> 9;
                default -> throw new IllegalArgumentException("Unknown key for border color: " + key);
            };
            int colorValue = entry.getIntValue();
            Integer n = colorValue;
            int n2 = ((Number)n).intValue();
            int n3 = index;
            ReactViewGroup reactViewGroup = view;
            ReactViewManager reactViewManager = $this$borderColor;
            boolean bl = false;
            boolean bl2 = it != -1;
            reactViewManager.setBorderColor(reactViewGroup, n3, bl2 ? n : null);
        }
    }

    private final void borderRadius(ReactViewManager $this$borderRadius, ReactViewGroup view, MapBuffer value) {
        for (MapBuffer.Entry entry : value) {
            int key = entry.getKey();
            int index = switch (key) {
                case 8 -> 0;
                case 0 -> 1;
                case 1 -> 2;
                case 2 -> 3;
                case 3 -> 4;
                case 4 -> 5;
                case 5 -> 6;
                case 7 -> 7;
                case 6 -> 8;
                case 9 -> 9;
                case 10 -> 10;
                case 11 -> 11;
                case 12 -> 12;
                default -> throw new IllegalArgumentException("Unknown key for border style: " + key);
            };
            double borderRadius = entry.getDoubleValue();
            if (Double.isNaN(borderRadius)) continue;
            $this$borderRadius.setBorderRadius(view, index, (float)borderRadius);
        }
    }

    private final void borderStyle(ReactViewManager $this$borderStyle, ReactViewGroup view, int value) {
        String stringValue = switch (value) {
            case 0 -> "solid";
            case 1 -> "dotted";
            case 2 -> "dashed";
            default -> null;
        };
        $this$borderStyle.setBorderStyle(view, stringValue);
    }

    private final void hitSlop(ReactViewGroup $this$hitSlop, MapBuffer value) {
        Rect rect = new Rect((int)PixelUtil.toPixelFromDIP(value.getDouble(1)), (int)PixelUtil.toPixelFromDIP(value.getDouble(0)), (int)PixelUtil.toPixelFromDIP(value.getDouble(2)), (int)PixelUtil.toPixelFromDIP(value.getDouble(3)));
        $this$hitSlop.setHitSlopRect(rect);
    }

    private final void importantForAccessibility(ReactViewGroup $this$importantForAccessibility, int value) {
        int mode = switch (value) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 4;
            default -> 0;
        };
        ViewCompat.setImportantForAccessibility((View)((View)$this$importantForAccessibility), (int)mode);
    }

    private final void role(ReactViewGroup $this$role, int value) {
        $this$role.setTag(R.id.role, (Object)ReactAccessibilityDelegate.Role.values()[value]);
    }

    private final void pointerEvents(ReactViewGroup $this$pointerEvents, int value) {
        PointerEvents pointerEvents = switch (value) {
            case 0 -> PointerEvents.AUTO;
            case 1 -> PointerEvents.NONE;
            case 2 -> PointerEvents.BOX_NONE;
            case 3 -> PointerEvents.BOX_ONLY;
            default -> throw new IllegalArgumentException("Unknown value for pointer events: " + value);
        };
        $this$pointerEvents.setPointerEvents(pointerEvents);
    }

    private final void transform(ReactViewManager $this$transform, ReactViewGroup view, MapBuffer value) {
        JavaOnlyArray list = new JavaOnlyArray();
        for (MapBuffer.Entry entry : value) {
            list.pushDouble(entry.getDoubleValue());
        }
        $this$transform.setTransform((View)view, list);
    }

    private final void borderWidth(ReactViewManager $this$borderWidth, ReactViewGroup view, MapBuffer value) {
        for (MapBuffer.Entry entry : value) {
            int key = entry.getKey();
            int index = switch (key) {
                case 6 -> 0;
                case 1 -> 1;
                case 2 -> 2;
                case 0 -> 3;
                case 3 -> 4;
                case 4 -> 5;
                case 5 -> 6;
                default -> throw new IllegalArgumentException("Unknown key for border width: " + key);
            };
            double borderWidth = entry.getDoubleValue();
            if (Double.isNaN(borderWidth)) continue;
            $this$borderWidth.setBorderWidth(view, index, (float)borderWidth);
        }
    }

    private final void overflow(ReactViewManager $this$overflow, ReactViewGroup view, int value) {
        String stringValue = switch (value) {
            case 0 -> "visible";
            case 1 -> "hidden";
            case 2 -> "scroll";
            default -> throw new IllegalArgumentException("Unknown overflow value: " + value);
        };
        $this$overflow.setOverflow(view, stringValue);
    }

    private final void shadowColor(ReactViewManager $this$shadowColor, ReactViewGroup view, int value) {
        Integer n = value;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it != Integer.MAX_VALUE ? n : null;
        int color = n2 != null ? n2 : -16777216;
        $this$shadowColor.setShadowColor((View)view, color);
    }

    private final void nativeBackground(ReactViewManager $this$nativeBackground, ReactViewGroup view, MapBuffer value) {
        $this$nativeBackground.setNativeBackground(view, this.toJsDrawableDescription(value));
    }

    private final void nativeForeground(ReactViewManager $this$nativeForeground, ReactViewGroup view, MapBuffer value) {
        $this$nativeForeground.setNativeForeground(view, this.toJsDrawableDescription(value));
    }

    private final ReadableMap toJsDrawableDescription(MapBuffer $this$toJsDrawableDescription) {
        if ($this$toJsDrawableDescription.getCount() == 0) {
            return null;
        }
        int kind = $this$toJsDrawableDescription.getInt(0);
        JavaOnlyMap result = new JavaOnlyMap();
        switch (kind) {
            case 0: {
                result.putString("type", "ThemeAttrAndroid");
                result.putString("attribute", $this$toJsDrawableDescription.getString(1));
                break;
            }
            case 1: {
                result.putString("type", "RippleAndroid");
                if ($this$toJsDrawableDescription.contains(2)) {
                    result.putInt("color", $this$toJsDrawableDescription.getInt(2));
                }
                result.putBoolean("borderless", $this$toJsDrawableDescription.getBoolean(3));
                if (!$this$toJsDrawableDescription.contains(4)) break;
                result.putDouble("rippleRadius", $this$toJsDrawableDescription.getDouble(4));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown native drawable: " + kind);
            }
        }
        return result;
    }
}

