/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.os.Build;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public class CanvasUtil {
    @Nullable
    private static Method mReorderBarrierMethod = null;
    @Nullable
    private static Method mInorderBarrierMethod = null;
    private static boolean mOrderMethodsFetched = false;

    private CanvasUtil() {
    }

    @SuppressLint(value={"SoonBlockedPrivateApi", "PrivateApi"})
    public static void enableZ(Canvas canvas, boolean enable) {
        if (Build.VERSION.SDK_INT >= 29) {
            if (enable) {
                canvas.enableZ();
            } else {
                canvas.disableZ();
            }
        } else {
            CanvasUtil.fetchOrderMethods();
            try {
                if (enable && mReorderBarrierMethod != null) {
                    mReorderBarrierMethod.invoke((Object)canvas, new Object[0]);
                }
                if (!enable && mInorderBarrierMethod != null) {
                    mInorderBarrierMethod.invoke((Object)canvas, new Object[0]);
                }
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    private static void fetchOrderMethods() {
        if (!mOrderMethodsFetched) {
            try {
                if (Build.VERSION.SDK_INT == 28) {
                    Method getDeclaredMethod = Class.class.getDeclaredMethod("getDeclaredMethod", String.class, Class[].class);
                    mReorderBarrierMethod = (Method)getDeclaredMethod.invoke(Canvas.class, "insertReorderBarrier", new Class[0]);
                    mInorderBarrierMethod = (Method)getDeclaredMethod.invoke(Canvas.class, "insertInorderBarrier", new Class[0]);
                } else {
                    mReorderBarrierMethod = Canvas.class.getDeclaredMethod("insertReorderBarrier", new Class[0]);
                    mInorderBarrierMethod = Canvas.class.getDeclaredMethod("insertInorderBarrier", new Class[0]);
                }
                if (mReorderBarrierMethod == null || mInorderBarrierMethod == null) {
                    return;
                }
                mReorderBarrierMethod.setAccessible(true);
                mInorderBarrierMethod.setAccessible(true);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            mOrderMethodsFetched = true;
        }
    }
}

