/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.traceupdateoverlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import androidx.annotation.UiThread;
import com.facebook.react.uimanager.PixelUtil;
import java.util.ArrayList;
import java.util.List;

public class TraceUpdateOverlay
extends View {
    private final Paint mOverlayPaint = new Paint();
    private List<Overlay> mOverlays = new ArrayList<Overlay>();

    public TraceUpdateOverlay(Context context) {
        super(context);
        this.mOverlayPaint.setStyle(Paint.Style.STROKE);
        this.mOverlayPaint.setStrokeWidth(6.0f);
    }

    @UiThread
    public void setOverlays(List<Overlay> overlays) {
        this.mOverlays = overlays;
        this.invalidate();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mOverlays.isEmpty()) {
            for (Overlay overlay : this.mOverlays) {
                this.mOverlayPaint.setColor(overlay.getColor());
                canvas.drawRect(overlay.getPixelRect(), this.mOverlayPaint);
            }
        }
    }

    public static class Overlay {
        private final int mColor;
        private final RectF mRect;

        public Overlay(int color, RectF rect) {
            this.mColor = color;
            this.mRect = rect;
        }

        public int getColor() {
            return this.mColor;
        }

        public RectF getPixelRect() {
            return new RectF(PixelUtil.toPixelFromDIP(this.mRect.left), PixelUtil.toPixelFromDIP(this.mRect.top), PixelUtil.toPixelFromDIP(this.mRect.right), PixelUtil.toPixelFromDIP(this.mRect.bottom));
        }
    }
}

