/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.graphics.Shader;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.react.views.image.ScaleTypeStartInside;

public class ImageResizeMode {
    private static final String RESIZE_MODE_CONTAIN = "contain";
    private static final String RESIZE_MODE_COVER = "cover";
    private static final String RESIZE_MODE_STRETCH = "stretch";
    private static final String RESIZE_MODE_CENTER = "center";
    private static final String RESIZE_MODE_REPEAT = "repeat";

    public static ScalingUtils.ScaleType toScaleType(@Nullable String resizeModeValue) {
        if (RESIZE_MODE_CONTAIN.equals(resizeModeValue)) {
            return ScalingUtils.ScaleType.FIT_CENTER;
        }
        if (RESIZE_MODE_COVER.equals(resizeModeValue)) {
            return ScalingUtils.ScaleType.CENTER_CROP;
        }
        if (RESIZE_MODE_STRETCH.equals(resizeModeValue)) {
            return ScalingUtils.ScaleType.FIT_XY;
        }
        if (RESIZE_MODE_CENTER.equals(resizeModeValue)) {
            return ScalingUtils.ScaleType.CENTER_INSIDE;
        }
        if (RESIZE_MODE_REPEAT.equals(resizeModeValue)) {
            return ScaleTypeStartInside.INSTANCE;
        }
        if (resizeModeValue != null) {
            FLog.w((String)"ReactNative", (String)("Invalid resize mode: '" + resizeModeValue + "'"));
        }
        return ImageResizeMode.defaultValue();
    }

    public static Shader.TileMode toTileMode(@Nullable String resizeModeValue) {
        if (RESIZE_MODE_CONTAIN.equals(resizeModeValue) || RESIZE_MODE_COVER.equals(resizeModeValue) || RESIZE_MODE_STRETCH.equals(resizeModeValue) || RESIZE_MODE_CENTER.equals(resizeModeValue)) {
            return Shader.TileMode.CLAMP;
        }
        if (RESIZE_MODE_REPEAT.equals(resizeModeValue)) {
            return Shader.TileMode.REPEAT;
        }
        if (resizeModeValue != null) {
            FLog.w((String)"ReactNative", (String)("Invalid resize mode: '" + resizeModeValue + "'"));
        }
        return ImageResizeMode.defaultTileMode();
    }

    public static ScalingUtils.ScaleType defaultValue() {
        return ScalingUtils.ScaleType.CENTER_CROP;
    }

    public static Shader.TileMode defaultTileMode() {
        return Shader.TileMode.CLAMP;
    }
}

