/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.react.R;

public class PointerEventHelper {
    public static final String POINTER_TYPE_TOUCH = "touch";
    public static final String POINTER_TYPE_PEN = "pen";
    public static final String POINTER_TYPE_MOUSE = "mouse";
    public static final String POINTER_TYPE_UNKNOWN = "";
    private static final int X_FLAG_SUPPORTS_HOVER = 0x1000000;
    public static final String POINTER_CANCEL = "topPointerCancel";
    public static final String POINTER_DOWN = "topPointerDown";
    public static final String POINTER_ENTER = "topPointerEnter";
    public static final String POINTER_LEAVE = "topPointerLeave";
    public static final String POINTER_MOVE = "topPointerMove";
    public static final String POINTER_UP = "topPointerUp";
    public static final String POINTER_OVER = "topPointerOver";
    public static final String POINTER_OUT = "topPointerOut";
    public static final String CLICK = "topClick";

    public static int getButtons(String eventName, String pointerType, int buttonState) {
        if (PointerEventHelper.isExitEvent(eventName)) {
            return 0;
        }
        if (POINTER_TYPE_TOUCH.equals(pointerType)) {
            return 1;
        }
        return buttonState;
    }

    public static int getButtonChange(String pointerType, int lastButtonState, int currentButtonState) {
        if (POINTER_TYPE_TOUCH.equals(pointerType)) {
            return 0;
        }
        int changedMask = currentButtonState ^ lastButtonState;
        if (changedMask == 0) {
            return -1;
        }
        switch (changedMask) {
            case 1: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
        }
        return -1;
    }

    public static String getW3CPointerType(int toolType) {
        switch (toolType) {
            case 1: {
                return POINTER_TYPE_TOUCH;
            }
            case 2: {
                return POINTER_TYPE_PEN;
            }
            case 3: {
                return POINTER_TYPE_MOUSE;
            }
        }
        return POINTER_TYPE_UNKNOWN;
    }

    public static boolean isListening(@Nullable View view, EVENT event) {
        if (view == null) {
            return true;
        }
        switch (event) {
            case DOWN: 
            case DOWN_CAPTURE: 
            case UP: 
            case UP_CAPTURE: 
            case CANCEL: 
            case CANCEL_CAPTURE: 
            case CLICK: 
            case CLICK_CAPTURE: {
                return true;
            }
        }
        Integer pointerEvents = (Integer)view.getTag(R.id.pointer_events);
        if (pointerEvents != null) {
            return (pointerEvents & 1 << event.ordinal()) != 0;
        }
        return false;
    }

    public static int getEventCategory(String pointerEventType) {
        if (pointerEventType == null) {
            return 2;
        }
        switch (pointerEventType) {
            case "topPointerDown": 
            case "topPointerCancel": 
            case "topPointerUp": {
                return 3;
            }
            case "topPointerMove": 
            case "topPointerEnter": 
            case "topPointerLeave": 
            case "topPointerOver": 
            case "topPointerOut": {
                return 4;
            }
        }
        return 2;
    }

    public static boolean supportsHover(MotionEvent motionEvent) {
        boolean supportsHoverFlag;
        boolean bl = supportsHoverFlag = (motionEvent.getFlags() & 0x1000000) != 0;
        if (supportsHoverFlag) {
            return true;
        }
        return motionEvent.isFromSource(8194);
    }

    public static boolean isExitEvent(String eventName) {
        switch (eventName) {
            case "topPointerUp": 
            case "topPointerLeave": 
            case "topPointerOut": {
                return true;
            }
        }
        return false;
    }

    public static double getPressure(int buttonState, String eventName) {
        if (PointerEventHelper.isExitEvent(eventName)) {
            return 0.0;
        }
        boolean inActiveButtonState = buttonState != 0;
        return inActiveButtonState ? 0.5 : 0.0;
    }

    public static boolean isBubblingEvent(String eventName) {
        switch (eventName) {
            case "topPointerUp": 
            case "topPointerDown": 
            case "topPointerOver": 
            case "topPointerOut": 
            case "topPointerMove": 
            case "topPointerCancel": {
                return true;
            }
        }
        return false;
    }

    public static enum EVENT {
        CANCEL,
        CANCEL_CAPTURE,
        CLICK,
        CLICK_CAPTURE,
        DOWN,
        DOWN_CAPTURE,
        ENTER,
        ENTER_CAPTURE,
        LEAVE,
        LEAVE_CAPTURE,
        MOVE,
        MOVE_CAPTURE,
        UP,
        UP_CAPTURE,
        OUT,
        OUT_CAPTURE,
        OVER,
        OVER_CAPTURE;

    }
}

