/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.content.Context;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JSIModule;
import com.facebook.react.bridge.JSIModuleType;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistry;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactNoCrashBridgeNotAllowedSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.runtime.ReactHostImpl;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class BridgelessReactContext
extends ReactApplicationContext
implements EventDispatcherProvider {
    private final ReactHostImpl mReactHost;
    private final AtomicReference<String> mSourceURL = new AtomicReference();
    private final String TAG = this.getClass().getSimpleName();

    BridgelessReactContext(Context context, ReactHostImpl host) {
        super(context);
        this.mReactHost = host;
        if (ReactFeatureFlags.unstable_useFabricInterop) {
            this.initializeInteropModules();
        }
    }

    @Override
    public boolean isBridgeless() {
        return true;
    }

    @Override
    public EventDispatcher getEventDispatcher() {
        return this.mReactHost.getEventDispatcher();
    }

    public void setSourceURL(String sourceURL) {
        this.mSourceURL.set(sourceURL);
    }

    @Override
    @Nullable
    public String getSourceURL() {
        return this.mSourceURL.get();
    }

    @Override
    @Nullable
    public JSIModule getJSIModule(JSIModuleType moduleType) {
        if (moduleType == JSIModuleType.UIManager) {
            return this.mReactHost.getUIManager();
        }
        throw new UnsupportedOperationException("getJSIModule is not implemented for bridgeless mode. Trying to get module: " + moduleType.name());
    }

    @Override
    public CatalystInstance getCatalystInstance() {
        ReactSoftExceptionLogger.logSoftExceptionVerbose(this.TAG, new ReactNoCrashBridgeNotAllowedSoftException("getCatalystInstance() cannot be called when the bridge is disabled"));
        throw new UnsupportedOperationException("There is no Catalyst instance in bridgeless mode.");
    }

    @Override
    public boolean hasActiveReactInstance() {
        return this.mReactHost.isInstanceInitialized();
    }

    DevSupportManager getDevSupportManager() {
        return this.mReactHost.getDevSupportManager();
    }

    @Override
    public void registerSegment(int segmentId, String path, Callback callback) {
        this.mReactHost.registerSegment(segmentId, path, callback);
    }

    @Override
    public <T extends JavaScriptModule> T getJSModule(Class<T> jsInterface) {
        if (this.mInteropModuleRegistry != null && this.mInteropModuleRegistry.shouldReturnInteropModule(jsInterface)) {
            return this.mInteropModuleRegistry.getInteropModule(jsInterface);
        }
        JavaScriptModule interfaceProxy = (JavaScriptModule)Proxy.newProxyInstance(jsInterface.getClassLoader(), new Class[]{jsInterface}, (InvocationHandler)new BridgelessJSModuleInvocationHandler(this.mReactHost, jsInterface));
        return (T)interfaceProxy;
    }

    @Override
    public <T extends NativeModule> boolean hasNativeModule(Class<T> nativeModuleInterface) {
        return this.mReactHost.hasNativeModule(nativeModuleInterface);
    }

    @Override
    public Collection<NativeModule> getNativeModules() {
        return this.mReactHost.getNativeModules();
    }

    @Override
    @Nullable
    public <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        return this.mReactHost.getNativeModule(nativeModuleInterface);
    }

    @Override
    public void handleException(Exception e) {
        this.mReactHost.handleHostException(e);
    }

    DefaultHardwareBackBtnHandler getDefaultHardwareBackBtnHandler() {
        return this.mReactHost.getDefaultBackButtonHandler();
    }

    private static class BridgelessJSModuleInvocationHandler
    implements InvocationHandler {
        private final ReactHostImpl mReactHost;
        private final Class<? extends JavaScriptModule> mJSModuleInterface;

        public BridgelessJSModuleInvocationHandler(ReactHostImpl reactHost, Class<? extends JavaScriptModule> jsModuleInterface) {
            this.mReactHost = reactHost;
            this.mJSModuleInterface = jsModuleInterface;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, @Nullable Object[] args) {
            WritableNativeArray jsArgs = args != null ? Arguments.fromJavaArgs(args) : new WritableNativeArray();
            this.mReactHost.callFunctionOnModule(JavaScriptModuleRegistry.getJSModuleName(this.mJSModuleInterface), method.getName(), jsArgs);
            return null;
        }
    }
}

