/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.modules.core.ChoreographerCompat;
import java.util.ArrayDeque;

public class ReactChoreographer {
    private static ReactChoreographer sInstance;
    @Nullable
    private volatile ChoreographerCompat mChoreographer;
    private final ReactChoreographerDispatcher mReactChoreographerDispatcher;
    private final Object mCallbackQueuesLock = new Object();
    @GuardedBy(value="mCallbackQueuesLock")
    private final ArrayDeque<ChoreographerCompat.FrameCallback>[] mCallbackQueues;
    private int mTotalCallbacks = 0;
    private boolean mHasPostedCallback = false;

    public static void initialize() {
        if (sInstance == null) {
            sInstance = new ReactChoreographer();
        }
    }

    public static ReactChoreographer getInstance() {
        Assertions.assertNotNull((Object)sInstance, (String)"ReactChoreographer needs to be initialized.");
        return sInstance;
    }

    private ReactChoreographer() {
        this.mReactChoreographerDispatcher = new ReactChoreographerDispatcher();
        this.mCallbackQueues = new ArrayDeque[CallbackType.values().length];
        for (int i = 0; i < this.mCallbackQueues.length; ++i) {
            this.mCallbackQueues[i] = new ArrayDeque();
        }
        this.initializeChoreographer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFrameCallback(CallbackType type, ChoreographerCompat.FrameCallback frameCallback) {
        Object object = this.mCallbackQueuesLock;
        synchronized (object) {
            this.mCallbackQueues[type.getOrder()].addLast(frameCallback);
            ++this.mTotalCallbacks;
            Assertions.assertCondition((this.mTotalCallbacks > 0 ? 1 : 0) != 0);
            if (!this.mHasPostedCallback) {
                if (this.mChoreographer == null) {
                    this.initializeChoreographer(new Runnable(){

                        @Override
                        public void run() {
                            ReactChoreographer.this.postFrameCallbackOnChoreographer();
                        }
                    });
                } else {
                    this.postFrameCallbackOnChoreographer();
                }
            }
        }
    }

    private void postFrameCallbackOnChoreographer() {
        this.mChoreographer.postFrameCallback(this.mReactChoreographerDispatcher);
        this.mHasPostedCallback = true;
    }

    public void initializeChoreographer(final @Nullable Runnable runnable) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<ReactChoreographer> clazz = ReactChoreographer.class;
                synchronized (ReactChoreographer.class) {
                    if (ReactChoreographer.this.mChoreographer == null) {
                        ReactChoreographer.this.mChoreographer = ChoreographerCompat.getInstance();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    if (runnable != null) {
                        runnable.run();
                    }
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameCallback(CallbackType type, ChoreographerCompat.FrameCallback frameCallback) {
        Object object = this.mCallbackQueuesLock;
        synchronized (object) {
            if (this.mCallbackQueues[type.getOrder()].removeFirstOccurrence(frameCallback)) {
                --this.mTotalCallbacks;
                this.maybeRemoveFrameCallback();
            } else {
                FLog.e((String)"ReactNative", (String)"Tried to remove non-existent frame callback");
            }
        }
    }

    private void maybeRemoveFrameCallback() {
        Assertions.assertCondition((this.mTotalCallbacks >= 0 ? 1 : 0) != 0);
        if (this.mTotalCallbacks == 0 && this.mHasPostedCallback) {
            if (this.mChoreographer != null) {
                this.mChoreographer.removeFrameCallback(this.mReactChoreographerDispatcher);
            }
            this.mHasPostedCallback = false;
        }
    }

    private class ReactChoreographerDispatcher
    extends ChoreographerCompat.FrameCallback {
        private ReactChoreographerDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFrame(long frameTimeNanos) {
            Object object = ReactChoreographer.this.mCallbackQueuesLock;
            synchronized (object) {
                ReactChoreographer.this.mHasPostedCallback = false;
                for (int i = 0; i < ReactChoreographer.this.mCallbackQueues.length; ++i) {
                    ArrayDeque<ChoreographerCompat.FrameCallback> callbackQueue = ReactChoreographer.this.mCallbackQueues[i];
                    int initialLength = callbackQueue.size();
                    for (int callback = 0; callback < initialLength; ++callback) {
                        ChoreographerCompat.FrameCallback frameCallback = callbackQueue.pollFirst();
                        if (frameCallback != null) {
                            frameCallback.doFrame(frameTimeNanos);
                            --ReactChoreographer.this.mTotalCallbacks;
                            continue;
                        }
                        FLog.e((String)"ReactNative", (String)"Tried to execute non-existent frame callback");
                    }
                }
                ReactChoreographer.this.maybeRemoveFrameCallback();
            }
        }
    }

    public static enum CallbackType {
        PERF_MARKERS(0),
        DISPATCH_UI(1),
        NATIVE_ANIMATED_MODULE(2),
        TIMERS_EVENTS(3),
        IDLE_EVENT(4);

        private final int mOrder;

        private CallbackType(int order) {
            this.mOrder = order;
        }

        int getOrder() {
            return this.mOrder;
        }
    }
}

