/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.fabric.LongStreamingStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DevToolsReactPerfLogger
implements ReactMarker.FabricMarkerListener {
    private final Map<Integer, FabricCommitPoint> mFabricCommitMarkers = new HashMap<Integer, FabricCommitPoint>();
    private final List<DevToolsReactPerfLoggerListener> mDevToolsReactPerfLoggerListeners = new ArrayList<DevToolsReactPerfLoggerListener>();
    public static final LongStreamingStats mStreamingCommitStats = new LongStreamingStats();
    public static final LongStreamingStats mStreamingLayoutStats = new LongStreamingStats();
    public static final LongStreamingStats mStreamingDiffStats = new LongStreamingStats();
    public static final LongStreamingStats mStreamingTransactionEndStats = new LongStreamingStats();
    public static final LongStreamingStats mStreamingBatchExecutionStats = new LongStreamingStats();

    public void addDevToolsReactPerfLoggerListener(DevToolsReactPerfLoggerListener listener) {
        this.mDevToolsReactPerfLoggerListeners.add(listener);
    }

    public void removeDevToolsReactPerfLoggerListener(DevToolsReactPerfLoggerListener listener) {
        this.mDevToolsReactPerfLoggerListeners.remove(listener);
    }

    @Override
    public void logFabricMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp) {
        this.logFabricMarker(name, tag, instanceKey, timestamp, 0);
    }

    @Override
    public void logFabricMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp, int counter) {
        if (DevToolsReactPerfLogger.isFabricCommitMarker(name)) {
            FabricCommitPoint commitPoint = this.mFabricCommitMarkers.get(instanceKey);
            if (commitPoint == null) {
                commitPoint = new FabricCommitPoint(instanceKey);
                this.mFabricCommitMarkers.put(instanceKey, commitPoint);
            }
            commitPoint.addPoint(name, new FabricCommitPointData(timestamp, counter));
            if (name == ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END && timestamp > 0L) {
                this.onFabricCommitEnd(commitPoint);
                this.mFabricCommitMarkers.remove(instanceKey);
            }
        }
    }

    private void onFabricCommitEnd(FabricCommitPoint commitPoint) {
        for (DevToolsReactPerfLoggerListener listener : this.mDevToolsReactPerfLoggerListeners) {
            listener.onFabricCommitEnd(commitPoint);
        }
    }

    private static boolean isFabricCommitMarker(ReactMarkerConstants name) {
        return name == ReactMarkerConstants.FABRIC_COMMIT_START || name == ReactMarkerConstants.FABRIC_COMMIT_END || name == ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_START || name == ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_END || name == ReactMarkerConstants.FABRIC_DIFF_START || name == ReactMarkerConstants.FABRIC_DIFF_END || name == ReactMarkerConstants.FABRIC_LAYOUT_START || name == ReactMarkerConstants.FABRIC_LAYOUT_END || name == ReactMarkerConstants.FABRIC_BATCH_EXECUTION_START || name == ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END || name == ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_START || name == ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_END || name == ReactMarkerConstants.FABRIC_LAYOUT_AFFECTED_NODES;
    }

    public static class FabricCommitPoint {
        private final long mCommitNumber;
        private final Map<ReactMarkerConstants, FabricCommitPointData> mPoints = new HashMap<ReactMarkerConstants, FabricCommitPointData>();

        private FabricCommitPoint(int commitNumber) {
            this.mCommitNumber = commitNumber;
        }

        private void addPoint(ReactMarkerConstants key, FabricCommitPointData data) {
            this.mPoints.put(key, data);
        }

        private long getTimestamp(ReactMarkerConstants marker) {
            FabricCommitPointData data = this.mPoints.get((Object)marker);
            return data != null ? data.getTimeStamp() : -1L;
        }

        private int getCounter(ReactMarkerConstants marker) {
            FabricCommitPointData data = this.mPoints.get((Object)marker);
            return data != null ? data.getCounter() : 0;
        }

        public long getCommitNumber() {
            return this.mCommitNumber;
        }

        public long getCommitStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_COMMIT_START);
        }

        public long getCommitEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_COMMIT_END);
        }

        public long getFinishTransactionStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_START);
        }

        public long getFinishTransactionEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_END);
        }

        public long getDiffStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_DIFF_START);
        }

        public long getDiffEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_DIFF_END);
        }

        public long getLayoutStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_LAYOUT_START);
        }

        public long getLayoutEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_LAYOUT_END);
        }

        public int getAffectedLayoutNodesCount() {
            return this.getCounter(ReactMarkerConstants.FABRIC_LAYOUT_AFFECTED_NODES);
        }

        public long getBatchExecutionStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_START);
        }

        public long getBatchExecutionEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END);
        }

        public long getUpdateUIMainThreadStart() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_START);
        }

        public long getUpdateUIMainThreadEnd() {
            return this.getTimestamp(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_END);
        }

        public long getCommitDuration() {
            return this.getCommitEnd() - this.getCommitStart();
        }

        public long getLayoutDuration() {
            return this.getLayoutEnd() - this.getLayoutStart();
        }

        public long getDiffDuration() {
            return this.getDiffEnd() - this.getDiffStart();
        }

        public long getTransactionEndDuration() {
            return this.getFinishTransactionEnd() - this.getFinishTransactionStart();
        }

        public long getBatchExecutionDuration() {
            return this.getBatchExecutionEnd() - this.getBatchExecutionStart();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("FabricCommitPoint{");
            builder.append("mCommitNumber=").append(this.mCommitNumber);
            builder.append(", mPoints=").append(this.mPoints);
            builder.append('}');
            return builder.toString();
        }
    }

    public static class FabricCommitPointData {
        private final long mTimeStamp;
        private final int mCounter;

        public FabricCommitPointData(long timeStamp, int counter) {
            this.mTimeStamp = timeStamp;
            this.mCounter = counter;
        }

        public long getTimeStamp() {
            return this.mTimeStamp;
        }

        public int getCounter() {
            return this.mCounter;
        }
    }

    public static interface DevToolsReactPerfLoggerListener {
        public void onFabricCommitEnd(FabricCommitPoint var1);
    }
}

