/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.defaults;

import android.app.Application;
import android.content.Context;
import com.facebook.react.JSEngineResolutionAlgorithm;
import com.facebook.react.ReactHost;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageTurboModuleManagerDelegate;
import com.facebook.react.bridge.JSIModulePackage;
import com.facebook.react.defaults.DefaultJSIModulePackage;
import com.facebook.react.defaults.DefaultReactHost;
import com.facebook.react.defaults.DefaultTurboModuleManagerDelegate;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/defaults/DefaultReactNativeHost;", "Lcom/facebook/react/ReactNativeHost;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "isHermesEnabled", "", "()Ljava/lang/Boolean;", "isNewArchEnabled", "()Z", "getJSEngineResolutionAlgorithm", "Lcom/facebook/react/JSEngineResolutionAlgorithm;", "getJSIModulePackage", "Lcom/facebook/react/bridge/JSIModulePackage;", "getReactPackageTurboModuleManagerDelegateBuilder", "Lcom/facebook/react/ReactPackageTurboModuleManagerDelegate$Builder;", "toReactHost", "Lcom/facebook/react/ReactHost;", "context", "Landroid/content/Context;", "ReactAndroid_release"})
public abstract class DefaultReactNativeHost
extends ReactNativeHost {
    protected DefaultReactNativeHost(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
    }

    @Override
    @Nullable
    protected ReactPackageTurboModuleManagerDelegate.Builder getReactPackageTurboModuleManagerDelegateBuilder() {
        return this.isNewArchEnabled() ? (ReactPackageTurboModuleManagerDelegate.Builder)new DefaultTurboModuleManagerDelegate.Builder() : null;
    }

    @Override
    @Nullable
    protected JSIModulePackage getJSIModulePackage() {
        return this.isNewArchEnabled() ? (JSIModulePackage)new DefaultJSIModulePackage(this) : null;
    }

    @Override
    @Nullable
    protected JSEngineResolutionAlgorithm getJSEngineResolutionAlgorithm() {
        JSEngineResolutionAlgorithm jSEngineResolutionAlgorithm;
        Boolean bl = this.isHermesEnabled();
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            jSEngineResolutionAlgorithm = JSEngineResolutionAlgorithm.HERMES;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            jSEngineResolutionAlgorithm = JSEngineResolutionAlgorithm.JSC;
        } else if (bl == null) {
            jSEngineResolutionAlgorithm = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jSEngineResolutionAlgorithm;
    }

    protected boolean isNewArchEnabled() {
        return false;
    }

    @Nullable
    protected Boolean isHermesEnabled() {
        return null;
    }

    @NotNull
    public final ReactHost toReactHost(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<ReactPackage> list = this.getPackages();
        Intrinsics.checkNotNullExpressionValue(list, (String)"packages");
        String string = this.getJSMainModuleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsMainModuleName");
        String string2 = this.getBundleAssetName();
        if (string2 == null) {
            string2 = "index";
        }
        Boolean bl = this.isHermesEnabled();
        return DefaultReactHost.getDefaultReactHost(context, list, string, string2, bl != null ? bl : true);
    }
}

