/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.text.SpannableStringBuilder;
import com.facebook.common.logging.FLog;
import com.facebook.react.views.text.ReactSpan;

class SetSpanOperation {
    private static final String TAG = "SetSpanOperation";
    static final int SPAN_MAX_PRIORITY = 255;
    protected int start;
    protected int end;
    protected ReactSpan what;

    SetSpanOperation(int start, int end, ReactSpan what) {
        this.start = start;
        this.end = end;
        this.what = what;
    }

    public void execute(SpannableStringBuilder sb, int priorityIndex) {
        int priority;
        assert (priorityIndex >= 0);
        int spanFlags = 34;
        if (this.start == 0) {
            spanFlags = 18;
        }
        if ((priority = 255 - priorityIndex) < 0) {
            FLog.w((String)TAG, (String)"Text tree size exceeded the limit, styling may become unpredictable");
        }
        int effectivePriority = Math.max(priority, 0);
        spanFlags &= 0xFF00FFFF;
        sb.setSpan((Object)this.what, this.start, this.end, spanFlags |= effectivePriority << 16 & 0xFF0000);
    }
}

