/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.deviceinfo;

import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.fbreact.specs.NativeDeviceInfoSpec;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import java.util.HashMap;
import java.util.Map;

@ReactModule(name="DeviceInfo")
public class DeviceInfoModule
extends NativeDeviceInfoSpec
implements LifecycleEventListener {
    @Nullable
    private final ReactApplicationContext mReactApplicationContext;
    private float mFontScale;
    @Nullable
    private ReadableMap mPreviousDisplayMetrics;

    public DeviceInfoModule(ReactApplicationContext reactContext) {
        super(reactContext);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)reactContext);
        this.mFontScale = reactContext.getResources().getConfiguration().fontScale;
        this.mReactApplicationContext = reactContext;
        this.mReactApplicationContext.addLifecycleEventListener(this);
    }

    public DeviceInfoModule(Context context) {
        super(null);
        this.mReactApplicationContext = null;
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized(context);
        this.mFontScale = context.getResources().getConfiguration().fontScale;
    }

    @Override
    @Nullable
    public Map<String, Object> getTypedExportedConstants() {
        WritableMap displayMetrics = DisplayMetricsHolder.getDisplayMetricsWritableMap(this.mFontScale);
        this.mPreviousDisplayMetrics = displayMetrics.copy();
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("Dimensions", displayMetrics.toHashMap());
        return constants;
    }

    @Override
    public void onHostResume() {
        if (this.mReactApplicationContext == null) {
            return;
        }
        float fontScale = this.mReactApplicationContext.getResources().getConfiguration().fontScale;
        if (this.mFontScale != fontScale) {
            this.mFontScale = fontScale;
            this.emitUpdateDimensionsEvent();
        }
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
    }

    public void emitUpdateDimensionsEvent() {
        if (this.mReactApplicationContext == null) {
            return;
        }
        if (this.mReactApplicationContext.hasActiveReactInstance()) {
            WritableMap displayMetrics = DisplayMetricsHolder.getDisplayMetricsWritableMap(this.mFontScale);
            if (this.mPreviousDisplayMetrics == null) {
                this.mPreviousDisplayMetrics = displayMetrics.copy();
            } else if (!displayMetrics.equals(this.mPreviousDisplayMetrics)) {
                this.mPreviousDisplayMetrics = displayMetrics.copy();
                this.mReactApplicationContext.emitDeviceEvent("didUpdateDimensions", displayMetrics);
            }
        } else {
            ReactSoftExceptionLogger.logSoftException("DeviceInfo", new ReactNoCrashSoftException("No active CatalystInstance, cannot emitUpdateDimensionsEvent"));
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.mReactApplicationContext != null) {
            this.mReactApplicationContext.removeLifecycleEventListener(this);
        }
    }
}

