/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.ColorAnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ObjectAnimatedNode;
import com.facebook.react.animated.StyleAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.common.ViewUtil;
import java.util.HashMap;
import java.util.Map;

class PropsAnimatedNode
extends AnimatedNode {
    private int mConnectedViewTag = -1;
    private final NativeAnimatedNodesManager mNativeAnimatedNodesManager;
    private final Map<String, Integer> mPropNodeMapping;
    private final JavaOnlyMap mPropMap;
    @Nullable
    private UIManager mUIManager;

    PropsAnimatedNode(ReadableMap config, NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        ReadableMap props = config.getMap("props");
        ReadableMapKeySetIterator iter = props.keySetIterator();
        this.mPropNodeMapping = new HashMap<String, Integer>();
        while (iter.hasNextKey()) {
            String propKey = iter.nextKey();
            int nodeIndex = props.getInt(propKey);
            this.mPropNodeMapping.put(propKey, nodeIndex);
        }
        this.mPropMap = new JavaOnlyMap();
        this.mNativeAnimatedNodesManager = nativeAnimatedNodesManager;
    }

    public void connectToView(int viewTag, UIManager uiManager) {
        if (this.mConnectedViewTag != -1) {
            throw new JSApplicationIllegalArgumentException("Animated node " + this.mTag + " is already attached to a view: " + this.mConnectedViewTag);
        }
        this.mConnectedViewTag = viewTag;
        this.mUIManager = uiManager;
    }

    public void disconnectFromView(int viewTag) {
        if (this.mConnectedViewTag != viewTag && this.mConnectedViewTag != -1) {
            throw new JSApplicationIllegalArgumentException("Attempting to disconnect view that has not been connected with the given animated node: " + viewTag + " but is connected to view " + this.mConnectedViewTag);
        }
        this.mConnectedViewTag = -1;
    }

    public void restoreDefaultValues() {
        if (this.mConnectedViewTag == -1) {
            return;
        }
        if (ViewUtil.getUIManagerType(this.mConnectedViewTag) == 2) {
            return;
        }
        ReadableMapKeySetIterator it = this.mPropMap.keySetIterator();
        while (it.hasNextKey()) {
            this.mPropMap.putNull(it.nextKey());
        }
        this.mUIManager.synchronouslyUpdateViewOnUIThread(this.mConnectedViewTag, this.mPropMap);
    }

    public final void updateView() {
        if (this.mConnectedViewTag == -1) {
            return;
        }
        for (Map.Entry<String, Integer> entry : this.mPropNodeMapping.entrySet()) {
            AnimatedNode node = this.mNativeAnimatedNodesManager.getNodeById(entry.getValue());
            if (node == null) {
                throw new IllegalArgumentException("Mapped property node does not exist");
            }
            if (node instanceof StyleAnimatedNode) {
                ((StyleAnimatedNode)node).collectViewUpdates(this.mPropMap);
                continue;
            }
            if (node instanceof ValueAnimatedNode) {
                Object animatedObject = ((ValueAnimatedNode)node).getAnimatedObject();
                if (animatedObject instanceof Integer) {
                    this.mPropMap.putInt(entry.getKey(), (Integer)animatedObject);
                    continue;
                }
                if (animatedObject instanceof String) {
                    this.mPropMap.putString(entry.getKey(), (String)animatedObject);
                    continue;
                }
                this.mPropMap.putDouble(entry.getKey(), ((ValueAnimatedNode)node).getValue());
                continue;
            }
            if (node instanceof ColorAnimatedNode) {
                this.mPropMap.putInt(entry.getKey(), ((ColorAnimatedNode)node).getColor());
                continue;
            }
            if (node instanceof ObjectAnimatedNode) {
                ((ObjectAnimatedNode)node).collectViewUpdates(entry.getKey(), this.mPropMap);
                continue;
            }
            throw new IllegalArgumentException("Unsupported type of node used in property node " + node.getClass());
        }
        this.mUIManager.synchronouslyUpdateViewOnUIThread(this.mConnectedViewTag, this.mPropMap);
    }

    public View getConnectedView() {
        try {
            return this.mUIManager.resolveView(this.mConnectedViewTag);
        }
        catch (IllegalViewOperationException ex) {
            return null;
        }
    }

    @Override
    public String prettyPrint() {
        return "PropsAnimatedNode[" + this.mTag + "] connectedViewTag: " + this.mConnectedViewTag + " mPropNodeMapping: " + (this.mPropNodeMapping != null ? this.mPropNodeMapping.toString() : "null") + " mPropMap: " + (this.mPropMap != null ? this.mPropMap.toString() : "null");
    }
}

