/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.devtoolssettings;

import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import com.facebook.fbreact.specs.NativeDevToolsSettingsManagerSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="DevToolsSettingsManager")
public class DevToolsSettingsManagerModule
extends NativeDevToolsSettingsManagerSpec {
    private static final String SHARED_PREFERENCES_PREFIX = "ReactNative__DevToolsSettings";
    private static final String KEY_CONSOLE_PATCH_SETTINGS = "ConsolePatchSettings";
    private static final String KEY_PROFILING_SETTINGS = "ProfilingSettings";
    private final SharedPreferences mSharedPreferences;

    public DevToolsSettingsManagerModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mSharedPreferences = reactContext.getSharedPreferences(SHARED_PREFERENCES_PREFIX, 0);
    }

    @Override
    @Nullable
    public String getConsolePatchSettings() {
        return this.mSharedPreferences.getString(KEY_CONSOLE_PATCH_SETTINGS, null);
    }

    @Override
    public void setConsolePatchSettings(String newSettings) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(KEY_CONSOLE_PATCH_SETTINGS, newSettings);
        editor.apply();
    }

    @Override
    @Nullable
    public String getProfilingSettings() {
        return this.mSharedPreferences.getString(KEY_PROFILING_SETTINGS, null);
    }

    @Override
    public void setProfilingSettings(String newSettings) {
        this.mSharedPreferences.edit().putString(KEY_PROFILING_SETTINGS, newSettings).apply();
    }
}

