/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.core.util.Pools;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.TouchTargetHelper;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.PointerEventHelper;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PointerEvent
extends Event<PointerEvent> {
    private static final String TAG = PointerEvent.class.getSimpleName();
    private static final int POINTER_EVENTS_POOL_SIZE = 6;
    private static final Pools.SynchronizedPool<PointerEvent> EVENTS_POOL = new Pools.SynchronizedPool(6);
    private static final short UNSET_COALESCING_KEY = -1;
    @Nullable
    private MotionEvent mMotionEvent;
    @Nullable
    private String mEventName;
    private short mCoalescingKey = (short)-1;
    @Nullable
    private List<WritableMap> mPointersEventData;
    private PointerEventState mEventState;
    @Nullable
    private Event.EventAnimationDriverMatchSpec mEventAnimationDriverMatchSpec;

    public static PointerEvent obtain(String eventName, int targetTag, PointerEventState eventState, MotionEvent motionEventToCopy) {
        PointerEvent event = (PointerEvent)EVENTS_POOL.acquire();
        if (event == null) {
            event = new PointerEvent();
        }
        event.init(eventName, targetTag, eventState, (MotionEvent)Assertions.assertNotNull((Object)motionEventToCopy), (short)0);
        return event;
    }

    public static PointerEvent obtain(String eventName, int targetTag, PointerEventState eventState, MotionEvent motionEventToCopy, short coalescingKey) {
        PointerEvent event = (PointerEvent)EVENTS_POOL.acquire();
        if (event == null) {
            event = new PointerEvent();
        }
        event.init(eventName, targetTag, eventState, (MotionEvent)Assertions.assertNotNull((Object)motionEventToCopy), coalescingKey);
        return event;
    }

    private void init(String eventName, int targetTag, PointerEventState eventState, MotionEvent motionEventToCopy, short coalescingKey) {
        super.init(eventState.getSurfaceId(), targetTag, motionEventToCopy.getEventTime());
        this.mEventName = eventName;
        this.mMotionEvent = MotionEvent.obtain((MotionEvent)motionEventToCopy);
        this.mCoalescingKey = coalescingKey;
        this.mEventState = eventState;
    }

    private PointerEvent() {
    }

    @Override
    public String getEventName() {
        return this.mEventName;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        if (this.mMotionEvent == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot dispatch a Pointer that has no MotionEvent; the PointerEvehas been recycled"));
            return;
        }
        if (this.mPointersEventData == null) {
            this.mPointersEventData = this.createPointersEventData();
        }
        if (this.mPointersEventData == null) {
            return;
        }
        boolean shouldCopy = this.mPointersEventData.size() > 1;
        for (WritableMap pointerEventData : this.mPointersEventData) {
            WritableMap eventData = shouldCopy ? pointerEventData.copy() : pointerEventData;
            rctEventEmitter.receiveEvent(this.getViewTag(), this.mEventName, eventData);
        }
    }

    @Override
    public Event.EventAnimationDriverMatchSpec getEventAnimationDriverMatchSpec() {
        if (this.mEventAnimationDriverMatchSpec == null) {
            this.mEventAnimationDriverMatchSpec = new Event.EventAnimationDriverMatchSpec(){

                @Override
                public boolean match(int viewTag, String eventName) {
                    if (!PointerEventHelper.isBubblingEvent(eventName)) {
                        return false;
                    }
                    List<TouchTargetHelper.ViewTarget> viewTargets = PointerEvent.this.mEventState.getHitPathForActivePointer();
                    for (TouchTargetHelper.ViewTarget viewTarget : viewTargets) {
                        if (viewTarget.getViewId() != viewTag || !eventName.equals(PointerEvent.this.mEventName)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.mEventAnimationDriverMatchSpec;
    }

    @Override
    public void onDispose() {
        this.mPointersEventData = null;
        MotionEvent motionEvent = this.mMotionEvent;
        this.mMotionEvent = null;
        if (motionEvent != null) {
            motionEvent.recycle();
        }
        try {
            EVENTS_POOL.release((Object)this);
        }
        catch (IllegalStateException e) {
            ReactSoftExceptionLogger.logSoftException(TAG, e);
        }
    }

    private List<WritableMap> createW3CPointerEvents() {
        ArrayList<WritableMap> w3cPointerEvents = new ArrayList<WritableMap>();
        for (int index = 0; index < this.mMotionEvent.getPointerCount(); ++index) {
            w3cPointerEvents.add(this.createW3CPointerEvent(index));
        }
        return w3cPointerEvents;
    }

    private WritableMap createW3CPointerEvent(int index) {
        WritableMap pointerEvent = Arguments.createMap();
        int pointerId = this.mMotionEvent.getPointerId(index);
        pointerEvent.putDouble("pointerId", pointerId);
        String pointerType = PointerEventHelper.getW3CPointerType(this.mMotionEvent.getToolType(index));
        pointerEvent.putString("pointerType", pointerType);
        pointerEvent.putBoolean("isPrimary", PointerEventHelper.isPrimary(pointerId, this.mEventState.getPrimaryPointerId(), this.mMotionEvent));
        float[] eventCoords = this.mEventState.getEventCoordinatesByPointerId().get(pointerId);
        double clientX = PixelUtil.toDIPFromPixel(eventCoords[0]);
        double clientY = PixelUtil.toDIPFromPixel(eventCoords[1]);
        pointerEvent.putDouble("clientX", clientX);
        pointerEvent.putDouble("clientY", clientY);
        pointerEvent.putDouble("x", clientX);
        pointerEvent.putDouble("y", clientY);
        pointerEvent.putDouble("pageX", clientX);
        pointerEvent.putDouble("pageY", clientY);
        float[] offsetCoords = this.mEventState.getOffsetByPointerId().get(pointerId);
        pointerEvent.putDouble("offsetX", PixelUtil.toDIPFromPixel(offsetCoords[0]));
        pointerEvent.putDouble("offsetY", PixelUtil.toDIPFromPixel(offsetCoords[1]));
        pointerEvent.putInt("target", this.getViewTag());
        pointerEvent.putDouble("timestamp", this.getTimestampMs());
        pointerEvent.putInt("detail", 0);
        pointerEvent.putDouble("tiltX", 0.0);
        pointerEvent.putDouble("tiltY", 0.0);
        if (pointerType.equals("mouse")) {
            pointerEvent.putDouble("width", 1.0);
            pointerEvent.putDouble("height", 1.0);
        } else {
            float majorAxis = PixelUtil.toDIPFromPixel(this.mMotionEvent.getTouchMajor(index));
            pointerEvent.putDouble("width", majorAxis);
            pointerEvent.putDouble("height", majorAxis);
        }
        int buttonState = this.mMotionEvent.getButtonState();
        pointerEvent.putInt("button", PointerEventHelper.getButtonChange(pointerType, this.mEventState.getLastButtonState(), buttonState));
        pointerEvent.putInt("buttons", PointerEventHelper.getButtons(this.mEventName, pointerType, buttonState));
        pointerEvent.putDouble("pressure", PointerEventHelper.getPressure(pointerEvent.getInt("buttons"), this.mEventName));
        return pointerEvent;
    }

    private List<WritableMap> createPointersEventData() {
        int activePointerIndex = this.mMotionEvent.getActionIndex();
        List<WritableMap> pointersEventData = null;
        switch (this.mEventName) {
            case "topPointerMove": 
            case "topPointerCancel": {
                pointersEventData = this.createW3CPointerEvents();
                break;
            }
            case "topPointerEnter": 
            case "topPointerDown": 
            case "topPointerUp": 
            case "topPointerLeave": 
            case "topPointerOut": 
            case "topPointerOver": {
                pointersEventData = Arrays.asList(this.createW3CPointerEvent(activePointerIndex));
            }
        }
        return pointersEventData;
    }

    @Override
    public short getCoalescingKey() {
        return this.mCoalescingKey;
    }

    @Override
    public void dispatchModern(RCTModernEventEmitter rctEventEmitter) {
        if (this.mMotionEvent == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot dispatch a Pointer that has no MotionEvent; the PointerEvehas been recycled"));
            return;
        }
        if (this.mPointersEventData == null) {
            this.mPointersEventData = this.createPointersEventData();
        }
        if (this.mPointersEventData == null) {
            return;
        }
        boolean shouldCopy = this.mPointersEventData.size() > 1;
        for (WritableMap pointerEventData : this.mPointersEventData) {
            WritableMap eventData = shouldCopy ? pointerEventData.copy() : pointerEventData;
            rctEventEmitter.receiveEvent(this.getSurfaceId(), this.getViewTag(), this.mEventName, this.mCoalescingKey != -1, this.mCoalescingKey, eventData, PointerEventHelper.getEventCategory(this.mEventName));
        }
    }

    public static class PointerEventState {
        private int mPrimaryPointerId;
        private int mActivePointerId;
        private int mLastButtonState;
        private int mSurfaceId;
        private Map<Integer, float[]> mOffsetByPointerId;
        private Map<Integer, List<TouchTargetHelper.ViewTarget>> mHitPathByPointerId;
        private Map<Integer, float[]> mEventCoordinatesByPointerId;

        public PointerEventState(int primaryPointerId, int activePointerId, int lastButtonState, int surfaceId, Map<Integer, float[]> offsetByPointerId, Map<Integer, List<TouchTargetHelper.ViewTarget>> hitPathByPointerId, Map<Integer, float[]> eventCoordinatesByPointerId) {
            this.mPrimaryPointerId = primaryPointerId;
            this.mActivePointerId = activePointerId;
            this.mLastButtonState = lastButtonState;
            this.mSurfaceId = surfaceId;
            this.mOffsetByPointerId = offsetByPointerId;
            this.mHitPathByPointerId = hitPathByPointerId;
            this.mEventCoordinatesByPointerId = eventCoordinatesByPointerId;
        }

        public int getLastButtonState() {
            return this.mLastButtonState;
        }

        public int getPrimaryPointerId() {
            return this.mPrimaryPointerId;
        }

        public int getSurfaceId() {
            return this.mSurfaceId;
        }

        public int getActivePointerId() {
            return this.mActivePointerId;
        }

        public final Map<Integer, float[]> getOffsetByPointerId() {
            return this.mOffsetByPointerId;
        }

        public final Map<Integer, List<TouchTargetHelper.ViewTarget>> getHitPathByPointerId() {
            return this.mHitPathByPointerId;
        }

        public final Map<Integer, float[]> getEventCoordinatesByPointerId() {
            return this.mEventCoordinatesByPointerId;
        }

        public final List<TouchTargetHelper.ViewTarget> getHitPathForActivePointer() {
            return this.mHitPathByPointerId.get(this.mActivePointerId);
        }
    }
}

