/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.debug;

import com.facebook.fbreact.specs.NativeDevSettingsSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.devsupport.interfaces.DevOptionHandler;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;

@ReactModule(name="DevSettings")
public class DevSettingsModule
extends NativeDevSettingsSpec {
    public static final String NAME = "DevSettings";
    private final DevSupportManager mDevSupportManager;

    public DevSettingsModule(ReactApplicationContext reactContext, DevSupportManager devSupportManager) {
        super(reactContext);
        this.mDevSupportManager = devSupportManager;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void reload() {
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DevSettingsModule.this.mDevSupportManager.handleReloadJS();
                }
            });
        }
    }

    @Override
    public void reloadWithReason(String reason) {
        this.reload();
    }

    @Override
    public void onFastRefresh() {
    }

    @Override
    public void setHotLoadingEnabled(boolean isHotLoadingEnabled) {
        this.mDevSupportManager.setHotModuleReplacementEnabled(isHotLoadingEnabled);
    }

    @Override
    public void setIsDebuggingRemotely(boolean isDebugginRemotelyEnabled) {
        this.mDevSupportManager.setRemoteJSDebugEnabled(isDebugginRemotelyEnabled);
    }

    @Override
    public void setProfilingEnabled(boolean isProfilingEnabled) {
        this.mDevSupportManager.setFpsDebugEnabled(isProfilingEnabled);
    }

    @Override
    public void toggleElementInspector() {
        this.mDevSupportManager.toggleElementInspector();
    }

    @Override
    public void addMenuItem(final String title) {
        this.mDevSupportManager.addCustomDevOption(title, new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                WritableMap data = Arguments.createMap();
                data.putString("title", title);
                ReactApplicationContext reactApplicationContext = DevSettingsModule.this.getReactApplicationContextIfActiveOrWarn();
                if (reactApplicationContext != null) {
                    reactApplicationContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("didPressMenuItem", data);
                }
            }
        });
    }

    @Override
    public void setIsShakeToShowDevMenuEnabled(boolean enabled) {
    }

    @Override
    public void addListener(String eventName) {
    }

    @Override
    public void removeListeners(double count) {
    }
}

