/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.os.Build;
import com.facebook.hermes.intl.Constants;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.IPlatformDateTimeFormatter;
import com.facebook.hermes.intl.IntlTextUtils;
import com.facebook.hermes.intl.JSObjects;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LocaleMatcher;
import com.facebook.hermes.intl.LocaleResolver;
import com.facebook.hermes.intl.OptionHelpers;
import com.facebook.hermes.intl.PlatformDateTimeFormatterAndroid;
import com.facebook.hermes.intl.PlatformDateTimeFormatterICU;
import com.facebook.proguard.annotations.DoNotStrip;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

@DoNotStrip
public class DateTimeFormat {
    IPlatformDateTimeFormatter mPlatformDateTimeFormatter = Build.VERSION.SDK_INT >= 24 ? new PlatformDateTimeFormatterICU() : new PlatformDateTimeFormatterAndroid();
    private ILocaleObject<?> mResolvedLocaleObject = null;
    private ILocaleObject<?> mResolvedLocaleObjectForResolvedOptions = null;
    private boolean useDefaultCalendar;
    private String mCalendar;
    private boolean useDefaultNumberSystem;
    private String mNumberingSystem;
    private Object mHour12;
    private IPlatformDateTimeFormatter.HourCycle mHourCycle;
    private IPlatformDateTimeFormatter.FormatMatcher mFormatMatcher;
    private IPlatformDateTimeFormatter.WeekDay mWeekDay;
    private IPlatformDateTimeFormatter.Era mEra;
    private IPlatformDateTimeFormatter.Year mYear;
    private IPlatformDateTimeFormatter.Month mMonth;
    private IPlatformDateTimeFormatter.Day mDay;
    private IPlatformDateTimeFormatter.Hour mHour;
    private IPlatformDateTimeFormatter.Minute mMinute;
    private IPlatformDateTimeFormatter.Second mSecond;
    private IPlatformDateTimeFormatter.TimeZoneName mTimeZoneName;
    private IPlatformDateTimeFormatter.DateStyle mDateStyle;
    private IPlatformDateTimeFormatter.TimeStyle mTimeStyle;
    private Object mTimeZone = null;

    private boolean isLocaleIdType(String token) {
        return IntlTextUtils.isUnicodeExtensionKeyTypeItem(token, 0, token.length() - 1);
    }

    private Object ToDateTimeOptions(Object options, String required, String defaults) throws JSRangeErrorException {
        if (!JSObjects.isObject(options)) {
            throw new JSRangeErrorException("Invalid options object !");
        }
        boolean needDefaults = true;
        if (required.equals("date") || required.equals("any")) {
            for (String property : new String[]{"weekday", "year", "month", "day"}) {
                if (JSObjects.isUndefined(JSObjects.Get(options, property))) continue;
                needDefaults = false;
            }
        }
        if (required.equals("time") || required.equals("any")) {
            for (String property : new String[]{"hour", "minute", "second"}) {
                if (JSObjects.isUndefined(JSObjects.Get(options, property))) continue;
                needDefaults = false;
            }
        }
        if (!JSObjects.isUndefined(JSObjects.Get(options, "dateStyle")) || !JSObjects.isUndefined(JSObjects.Get(options, "timeStyle"))) {
            needDefaults = false;
        }
        if (needDefaults && (defaults.equals("date") || defaults.equals("all"))) {
            for (String property : new String[]{"year", "month", "day"}) {
                JSObjects.Put(options, property, "numeric");
            }
        }
        if (needDefaults && (defaults.equals("time") || defaults.equals("all"))) {
            for (String property : new String[]{"hour", "minute", "second"}) {
                JSObjects.Put(options, property, "numeric");
            }
        }
        return options;
    }

    public String normalizeTimeZoneName(String timeZoneName) {
        StringBuilder normalized = new StringBuilder(timeZoneName.length());
        int offset = 32;
        for (int idx = 0; idx < timeZoneName.length(); ++idx) {
            char c = timeZoneName.charAt(idx);
            if (c >= 'A' && c <= 'Z') {
                normalized.append((char)(c + offset));
                continue;
            }
            normalized.append(c);
        }
        return normalized.toString();
    }

    public String normalizeTimeZone(String timeZone) throws JSRangeErrorException {
        for (String id : TimeZone.getAvailableIDs()) {
            if (!this.normalizeTimeZoneName(id).equals(this.normalizeTimeZoneName(timeZone))) continue;
            return id;
        }
        throw new JSRangeErrorException("Invalid timezone name!");
    }

    private Object DefaultTimeZone() throws JSRangeErrorException {
        return this.mPlatformDateTimeFormatter.getDefaultTimeZone(this.mResolvedLocaleObject);
    }

    private void initializeDateTimeFormat(List<String> locales, Map<String, Object> inOptions) throws JSRangeErrorException {
        List<String> relevantExtensionKeys = Arrays.asList("ca", "nu", "hc");
        Object options = this.ToDateTimeOptions(inOptions, "any", "date");
        Object opt = JSObjects.newObject();
        Object matcher = OptionHelpers.GetOption(options, "localeMatcher", OptionHelpers.OptionType.STRING, Constants.LOCALEMATCHER_POSSIBLE_VALUES, "best fit");
        JSObjects.Put(opt, "localeMatcher", matcher);
        Object calendar = OptionHelpers.GetOption(options, "calendar", OptionHelpers.OptionType.STRING, JSObjects.Undefined(), JSObjects.Undefined());
        if (!JSObjects.isUndefined(calendar) && !this.isLocaleIdType(JSObjects.getJavaString(calendar))) {
            throw new JSRangeErrorException("Invalid calendar option !");
        }
        JSObjects.Put(opt, "ca", calendar);
        Object numberingSystem = OptionHelpers.GetOption(options, "numberingSystem", OptionHelpers.OptionType.STRING, JSObjects.Undefined(), JSObjects.Undefined());
        if (!JSObjects.isUndefined(numberingSystem) && !this.isLocaleIdType(JSObjects.getJavaString(numberingSystem))) {
            throw new JSRangeErrorException("Invalid numbering system !");
        }
        JSObjects.Put(opt, "nu", numberingSystem);
        Object hour12 = OptionHelpers.GetOption(options, "hour12", OptionHelpers.OptionType.BOOLEAN, JSObjects.Undefined(), JSObjects.Undefined());
        Object hourCycle = OptionHelpers.GetOption(options, "hourCycle", OptionHelpers.OptionType.STRING, new String[]{"h11", "h12", "h23", "h24"}, JSObjects.Undefined());
        if (!JSObjects.isUndefined(hour12)) {
            hourCycle = JSObjects.Null();
        }
        JSObjects.Put(opt, "hc", hourCycle);
        HashMap<String, Object> r = LocaleResolver.resolveLocale(locales, opt, relevantExtensionKeys);
        this.mResolvedLocaleObject = (ILocaleObject)JSObjects.getJavaMap(r).get("locale");
        this.mResolvedLocaleObjectForResolvedOptions = this.mResolvedLocaleObject.cloneObject();
        Object calendarResolved = JSObjects.Get(r, "ca");
        if (!JSObjects.isNull(calendarResolved)) {
            this.useDefaultCalendar = false;
            this.mCalendar = JSObjects.getJavaString(calendarResolved);
        } else {
            this.useDefaultCalendar = true;
            this.mCalendar = this.mPlatformDateTimeFormatter.getDefaultCalendarName(this.mResolvedLocaleObject);
        }
        Object numeringSystemResolved = JSObjects.Get(r, "nu");
        if (!JSObjects.isNull(numeringSystemResolved)) {
            this.useDefaultNumberSystem = false;
            this.mNumberingSystem = JSObjects.getJavaString(numeringSystemResolved);
        } else {
            this.useDefaultNumberSystem = true;
            this.mNumberingSystem = this.mPlatformDateTimeFormatter.getDefaultNumberingSystem(this.mResolvedLocaleObject);
        }
        Object hourCycleResolved = JSObjects.Get(r, "hc");
        Object timeZone = JSObjects.Get(options, "timeZone");
        timeZone = JSObjects.isUndefined(timeZone) ? this.DefaultTimeZone() : this.normalizeTimeZone(timeZone.toString());
        this.mTimeZone = timeZone;
        Object formatMatcher = OptionHelpers.GetOption(options, "formatMatcher", OptionHelpers.OptionType.STRING, new String[]{"basic", "best fit"}, "best fit");
        this.mFormatMatcher = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.FormatMatcher.class, JSObjects.getJavaString(formatMatcher));
        Object weekDay = OptionHelpers.GetOption(options, "weekday", OptionHelpers.OptionType.STRING, new String[]{"long", "short", "narrow"}, JSObjects.Undefined());
        this.mWeekDay = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.WeekDay.class, weekDay);
        Object era = OptionHelpers.GetOption(options, "era", OptionHelpers.OptionType.STRING, new String[]{"long", "short", "narrow"}, JSObjects.Undefined());
        this.mEra = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.Era.class, era);
        Object year = OptionHelpers.GetOption(options, "year", OptionHelpers.OptionType.STRING, new String[]{"numeric", "2-digit"}, JSObjects.Undefined());
        this.mYear = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.Year.class, year);
        Object month = OptionHelpers.GetOption(options, "month", OptionHelpers.OptionType.STRING, new String[]{"numeric", "2-digit", "long", "short", "narrow"}, JSObjects.Undefined());
        this.mMonth = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.Month.class, month);
        Object day = OptionHelpers.GetOption(options, "day", OptionHelpers.OptionType.STRING, new String[]{"numeric", "2-digit"}, JSObjects.Undefined());
        this.mDay = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.Day.class, day);
        Object hour = OptionHelpers.GetOption(options, "hour", OptionHelpers.OptionType.STRING, new String[]{"numeric", "2-digit"}, JSObjects.Undefined());
        this.mHour = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.Hour.class, hour);
        Object minute = OptionHelpers.GetOption(options, "minute", OptionHelpers.OptionType.STRING, new String[]{"numeric", "2-digit"}, JSObjects.Undefined());
        this.mMinute = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.Minute.class, minute);
        Object second = OptionHelpers.GetOption(options, "second", OptionHelpers.OptionType.STRING, new String[]{"numeric", "2-digit"}, JSObjects.Undefined());
        this.mSecond = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.Second.class, second);
        Object timeZoneName = OptionHelpers.GetOption(options, "timeZoneName", OptionHelpers.OptionType.STRING, new String[]{"long", "longOffset", "longGeneric", "short", "shortOffset", "shortGeneric"}, JSObjects.Undefined());
        this.mTimeZoneName = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.TimeZoneName.class, timeZoneName);
        Object dateStyle = OptionHelpers.GetOption(options, "dateStyle", OptionHelpers.OptionType.STRING, new String[]{"full", "long", "medium", "short"}, JSObjects.Undefined());
        this.mDateStyle = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.DateStyle.class, dateStyle);
        Object timeStyle = OptionHelpers.GetOption(options, "timeStyle", OptionHelpers.OptionType.STRING, new String[]{"full", "long", "medium", "short"}, JSObjects.Undefined());
        this.mTimeStyle = OptionHelpers.searchEnum(IPlatformDateTimeFormatter.TimeStyle.class, timeStyle);
        if (JSObjects.isUndefined(hour) && JSObjects.isUndefined(timeStyle)) {
            this.mHourCycle = IPlatformDateTimeFormatter.HourCycle.UNDEFINED;
        } else {
            IPlatformDateTimeFormatter.HourCycle hcDefault = this.mPlatformDateTimeFormatter.getDefaultHourCycle(this.mResolvedLocaleObject);
            IPlatformDateTimeFormatter.HourCycle hc = JSObjects.isNull(hourCycleResolved) ? hcDefault : OptionHelpers.searchEnum(IPlatformDateTimeFormatter.HourCycle.class, hourCycleResolved);
            if (!JSObjects.isUndefined(hour12)) {
                hc = JSObjects.getJavaBoolean(hour12) ? (hcDefault == IPlatformDateTimeFormatter.HourCycle.H11 || hcDefault == IPlatformDateTimeFormatter.HourCycle.H23 ? IPlatformDateTimeFormatter.HourCycle.H11 : IPlatformDateTimeFormatter.HourCycle.H12) : (hcDefault == IPlatformDateTimeFormatter.HourCycle.H11 || hcDefault == IPlatformDateTimeFormatter.HourCycle.H23 ? IPlatformDateTimeFormatter.HourCycle.H23 : IPlatformDateTimeFormatter.HourCycle.H24);
            }
            this.mHourCycle = hc;
        }
        this.mHour12 = hour12;
    }

    @DoNotStrip
    public DateTimeFormat(List<String> locales, Map<String, Object> options) throws JSRangeErrorException {
        this.initializeDateTimeFormat(locales, options);
        this.mPlatformDateTimeFormatter.configure(this.mResolvedLocaleObject, this.useDefaultCalendar ? "" : this.mCalendar, this.useDefaultNumberSystem ? "" : this.mNumberingSystem, this.mFormatMatcher, this.mWeekDay, this.mEra, this.mYear, this.mMonth, this.mDay, this.mHour, this.mMinute, this.mSecond, this.mTimeZoneName, this.mHourCycle, this.mTimeZone, this.mDateStyle, this.mTimeStyle, this.mHour12);
    }

    @DoNotStrip
    public static List<String> supportedLocalesOf(List<String> locales, Map<String, Object> options) throws JSRangeErrorException {
        String matcher = JSObjects.getJavaString(OptionHelpers.GetOption(options, "localeMatcher", OptionHelpers.OptionType.STRING, Constants.LOCALEMATCHER_POSSIBLE_VALUES, "best fit"));
        String[] localeArray = new String[locales.size()];
        if (Build.VERSION.SDK_INT >= 24 && matcher.equals("best fit")) {
            return Arrays.asList(LocaleMatcher.bestFitSupportedLocales(locales.toArray(localeArray)));
        }
        return Arrays.asList(LocaleMatcher.lookupSupportedLocales(locales.toArray(localeArray)));
    }

    @DoNotStrip
    public Map<String, Object> resolvedOptions() throws JSRangeErrorException {
        LinkedHashMap<String, Object> finalResolvedOptions = new LinkedHashMap<String, Object>();
        finalResolvedOptions.put("locale", this.mResolvedLocaleObjectForResolvedOptions.toCanonicalTag());
        finalResolvedOptions.put("numberingSystem", this.mNumberingSystem);
        finalResolvedOptions.put("calendar", this.mCalendar);
        finalResolvedOptions.put("timeZone", this.mTimeZone);
        if (this.mHourCycle != IPlatformDateTimeFormatter.HourCycle.UNDEFINED) {
            finalResolvedOptions.put("hourCycle", this.mHourCycle.toString());
            if (this.mHourCycle == IPlatformDateTimeFormatter.HourCycle.H11 || this.mHourCycle == IPlatformDateTimeFormatter.HourCycle.H12) {
                finalResolvedOptions.put("hour12", true);
            } else {
                finalResolvedOptions.put("hour12", false);
            }
        }
        if (this.mWeekDay != IPlatformDateTimeFormatter.WeekDay.UNDEFINED) {
            finalResolvedOptions.put("weekday", this.mWeekDay.toString());
        }
        if (this.mEra != IPlatformDateTimeFormatter.Era.UNDEFINED) {
            finalResolvedOptions.put("era", this.mEra.toString());
        }
        if (this.mYear != IPlatformDateTimeFormatter.Year.UNDEFINED) {
            finalResolvedOptions.put("year", this.mYear.toString());
        }
        if (this.mMonth != IPlatformDateTimeFormatter.Month.UNDEFINED) {
            finalResolvedOptions.put("month", this.mMonth.toString());
        }
        if (this.mDay != IPlatformDateTimeFormatter.Day.UNDEFINED) {
            finalResolvedOptions.put("day", this.mDay.toString());
        }
        if (this.mHour != IPlatformDateTimeFormatter.Hour.UNDEFINED) {
            finalResolvedOptions.put("hour", this.mHour.toString());
        }
        if (this.mMinute != IPlatformDateTimeFormatter.Minute.UNDEFINED) {
            finalResolvedOptions.put("minute", this.mMinute.toString());
        }
        if (this.mSecond != IPlatformDateTimeFormatter.Second.UNDEFINED) {
            finalResolvedOptions.put("second", this.mSecond.toString());
        }
        if (this.mTimeZoneName != IPlatformDateTimeFormatter.TimeZoneName.UNDEFINED) {
            finalResolvedOptions.put("timeZoneName", this.mTimeZoneName.toString());
        }
        if (this.mDateStyle != IPlatformDateTimeFormatter.DateStyle.UNDEFINED) {
            finalResolvedOptions.put("dateStyle", this.mDateStyle.toString());
        }
        if (this.mTimeStyle != IPlatformDateTimeFormatter.TimeStyle.UNDEFINED) {
            finalResolvedOptions.put("timeStyle", this.mTimeStyle.toString());
        }
        return finalResolvedOptions;
    }

    @DoNotStrip
    public String format(double jsTimeValue) throws JSRangeErrorException {
        return this.mPlatformDateTimeFormatter.format(jsTimeValue);
    }

    @DoNotStrip
    public List<Map<String, String>> formatToParts(double jsTimeValue) throws JSRangeErrorException {
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
        AttributedCharacterIterator iterator = this.mPlatformDateTimeFormatter.formatToParts(jsTimeValue);
        StringBuilder sb = new StringBuilder();
        char ch = iterator.first();
        while (ch != '\uffff') {
            sb.append(ch);
            if (iterator.getIndex() + 1 == iterator.getRunLimit()) {
                Iterator<AttributedCharacterIterator.Attribute> keyIterator = iterator.getAttributes().keySet().iterator();
                String key = keyIterator.hasNext() ? this.mPlatformDateTimeFormatter.fieldToString(keyIterator.next(), sb.toString()) : "literal";
                String value = sb.toString();
                sb.setLength(0);
                HashMap<String, String> part = new HashMap<String, String>();
                part.put("type", key);
                part.put("value", value);
                ret.add(part);
            }
            ch = iterator.next();
        }
        return ret;
    }
}

