/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.os.Build;
import com.facebook.hermes.intl.JSObjects;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LocaleMatcher;
import com.facebook.hermes.intl.UnicodeExtensionKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class LocaleResolver {
    public static HashMap<String, Object> resolveLocale(List<String> requestedLocales, Object options, List<String> relevantExtensionKeys) throws JSRangeErrorException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String optionLocaleMatcher = JSObjects.getJavaString(JSObjects.Get(options, "localeMatcher"));
        LocaleMatcher.LocaleMatchResult localeMatchResult = Build.VERSION.SDK_INT < 24 || optionLocaleMatcher.equals("lookup") ? LocaleMatcher.lookupMatch(requestedLocales.toArray(new String[requestedLocales.size()])) : LocaleMatcher.bestFitMatch(requestedLocales.toArray(new String[requestedLocales.size()]));
        HashSet<String> supportedExtensionAdditionKeys = new HashSet<String>();
        for (String key : relevantExtensionKeys) {
            Object value = JSObjects.Null();
            if (!localeMatchResult.extensions.isEmpty() && localeMatchResult.extensions.containsKey(key)) {
                String requestedValue = localeMatchResult.extensions.get(key);
                value = !requestedValue.isEmpty() ? requestedValue : JSObjects.newString("true");
                supportedExtensionAdditionKeys.add(key);
            }
            if (JSObjects.getJavaMap(options).containsKey(key)) {
                Object optionsValue = JSObjects.Get(options, key);
                if (JSObjects.isString(optionsValue) && JSObjects.getJavaString(optionsValue).isEmpty()) {
                    optionsValue = JSObjects.newBoolean(true);
                }
                if (!JSObjects.isUndefined(optionsValue) && !optionsValue.equals(value)) {
                    supportedExtensionAdditionKeys.remove(key);
                    value = optionsValue;
                }
            }
            if (!JSObjects.isNull(value)) {
                value = UnicodeExtensionKeys.resolveKnownAliases(key, value);
            }
            if (JSObjects.isString(value) && !UnicodeExtensionKeys.isValidKeyword(key, JSObjects.getJavaString(value), localeMatchResult.matchedLocale)) {
                result.put(key, JSObjects.Null());
                continue;
            }
            result.put(key, value);
        }
        for (String supportedExtendionKey : supportedExtensionAdditionKeys) {
            ArrayList<String> valueList = new ArrayList<String>();
            String keyValue = localeMatchResult.extensions.get(supportedExtendionKey);
            if (JSObjects.isString(keyValue = JSObjects.getJavaString(UnicodeExtensionKeys.resolveKnownAliases(supportedExtendionKey, JSObjects.newString(keyValue)))) && !UnicodeExtensionKeys.isValidKeyword(supportedExtendionKey, JSObjects.getJavaString(keyValue), localeMatchResult.matchedLocale)) continue;
            valueList.add(keyValue);
            localeMatchResult.matchedLocale.setUnicodeExtensions(supportedExtendionKey, valueList);
        }
        result.put("locale", localeMatchResult.matchedLocale);
        return result;
    }
}

