/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.icu.lang.UCharacter;
import android.icu.util.ULocale;
import android.os.Build;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LocaleIdentifier;
import com.facebook.hermes.intl.LocaleMatcher;
import com.facebook.proguard.annotations.DoNotStrip;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@DoNotStrip
public class Intl {
    private static List<String> canonicalizeLocaleList(List<String> locales) throws JSRangeErrorException {
        if (locales.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> seen = new ArrayList<String>();
        for (String locale : locales) {
            if (locale == null) {
                throw new JSRangeErrorException("Incorrect locale information provided");
            }
            if (locale.isEmpty()) {
                throw new JSRangeErrorException("Incorrect locale information provided");
            }
            String canonicalizedTag = LocaleIdentifier.canonicalizeLocaleId(locale);
            if (canonicalizedTag.isEmpty() || seen.contains(canonicalizedTag)) continue;
            seen.add(canonicalizedTag);
        }
        return seen;
    }

    @DoNotStrip
    public static List<String> getCanonicalLocales(List<String> locales) throws JSRangeErrorException {
        return Intl.canonicalizeLocaleList(locales);
    }

    @DoNotStrip
    public static String toLocaleLowerCase(List<String> locales, String str) throws JSRangeErrorException {
        String[] localesArray = new String[locales.size()];
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleMatcher.LocaleMatchResult localeMatchResult = LocaleMatcher.bestFitMatch(locales.toArray(localesArray));
            return UCharacter.toLowerCase((ULocale)((ULocale)localeMatchResult.matchedLocale.getLocale()), (String)str);
        }
        LocaleMatcher.LocaleMatchResult localeMatchResult = LocaleMatcher.lookupMatch(locales.toArray(localesArray));
        return str.toLowerCase((Locale)localeMatchResult.matchedLocale.getLocale());
    }

    @DoNotStrip
    public static String toLocaleUpperCase(List<String> locales, String str) throws JSRangeErrorException {
        String[] localesArray = new String[locales.size()];
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleMatcher.LocaleMatchResult localeMatchResult = LocaleMatcher.bestFitMatch(locales.toArray(localesArray));
            return UCharacter.toUpperCase((ULocale)((ULocale)localeMatchResult.matchedLocale.getLocale()), (String)str);
        }
        LocaleMatcher.LocaleMatchResult localeMatchResult = LocaleMatcher.lookupMatch(locales.toArray(localesArray));
        return str.toUpperCase((Locale)localeMatchResult.matchedLocale.getLocale());
    }
}

