/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

public class IntlTextUtils {
    public static boolean isASCIILetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isASCIIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isASCIILetterOrDigit(char c) {
        return IntlTextUtils.isASCIILetter(c) || IntlTextUtils.isASCIIDigit(c);
    }

    public static boolean isAlphaNum(CharSequence name, int start, int end, int min, int max) {
        assert (start >= 0 && end >= 0 && start <= name.length() && end <= name.length());
        if (end >= name.length()) {
            return false;
        }
        int length = end - start + 1;
        if (length < min || length > max) {
            return false;
        }
        for (int idx = start; idx <= end; ++idx) {
            char c = name.charAt(idx);
            if (IntlTextUtils.isASCIILetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(CharSequence name, int start, int end, int min, int max) {
        assert (start >= 0 && end >= 0 && start <= name.length() && end <= name.length());
        if (end >= name.length()) {
            return false;
        }
        int length = end - start + 1;
        if (length < min || length > max) {
            return false;
        }
        for (int idx = start; idx <= end; ++idx) {
            char c = name.charAt(idx);
            if (IntlTextUtils.isASCIILetter(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigit(CharSequence name, int start, int end, int min, int max) {
        assert (start >= 0 && end >= 0 && start <= name.length() && end <= name.length());
        if (end >= name.length()) {
            return false;
        }
        int length = end - start + 1;
        if (length < min || length > max) {
            return false;
        }
        for (int idx = start; idx <= end; ++idx) {
            char c = name.charAt(idx);
            if (IntlTextUtils.isASCIIDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigitAlphanum3(CharSequence token, int start, int end) {
        return end - start + 1 == 4 && IntlTextUtils.isASCIILetter(token.charAt(start)) && IntlTextUtils.isAlphaNum(token, start + 1, end, 3, 3);
    }

    public static boolean isUnicodeLanguageSubtag(CharSequence token, int start, int end) {
        return IntlTextUtils.isAlpha(token, start, end, 2, 3) || IntlTextUtils.isAlpha(token, start, end, 5, 8) || end - start + 1 == 4 && token.charAt(start) == 'r' && token.charAt(start + 1) == 'o' && token.charAt(start + 2) == 'o' && token.charAt(start + 3) == 't';
    }

    public static boolean isExtensionSingleton(CharSequence token, int start, int end) {
        return IntlTextUtils.isAlphaNum(token, start, end, 1, 1);
    }

    public static boolean isUnicodeScriptSubtag(CharSequence token, int start, int end) {
        return IntlTextUtils.isAlpha(token, start, end, 4, 4);
    }

    public static boolean isUnicodeRegionSubtag(CharSequence token, int start, int end) {
        return IntlTextUtils.isAlpha(token, start, end, 2, 2) || IntlTextUtils.isDigit(token, start, end, 3, 3);
    }

    public static boolean isUnicodeVariantSubtag(CharSequence token, int start, int end) {
        return IntlTextUtils.isAlphaNum(token, start, end, 5, 8) || IntlTextUtils.isDigitAlphanum3(token, start, end);
    }

    public static boolean isUnicodeExtensionAttribute(CharSequence token, int start, int end) {
        return IntlTextUtils.isAlphaNum(token, start, end, 3, 8);
    }

    public static boolean isUnicodeExtensionKey(CharSequence token, int start, int end) {
        if (end != start + 1) {
            return false;
        }
        return IntlTextUtils.isASCIILetterOrDigit(token.charAt(start)) && IntlTextUtils.isASCIILetter(token.charAt(end));
    }

    public static boolean isUnicodeExtensionKeyTypeItem(CharSequence token, int start, int end) {
        return IntlTextUtils.isAlphaNum(token, start, end, 3, 8);
    }

    public static boolean isTranformedExtensionTKey(CharSequence token, int start, int end) {
        if (end != start + 1) {
            return false;
        }
        return IntlTextUtils.isASCIILetter(token.charAt(start)) && IntlTextUtils.isASCIIDigit(token.charAt(end));
    }

    public static boolean isTranformedExtensionTValueItem(CharSequence token, int start, int end) {
        return IntlTextUtils.isAlphaNum(token, start, end, 3, 8);
    }

    public static boolean isPrivateUseExtension(CharSequence token, int start, int end) {
        return IntlTextUtils.isAlphaNum(token, start, end, 1, 8);
    }

    public static boolean isOtherExtension(CharSequence token, int start, int end) {
        return IntlTextUtils.isAlphaNum(token, start, end, 2, 8);
    }
}

