/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import com.facebook.hermes.intl.JSObjects;
import com.facebook.hermes.intl.JSRangeErrorException;
import java.util.Arrays;

public class OptionHelpers {
    public static Object DefaultNumberOption(Object value, Object minimum, Object maximum, Object fallback) throws JSRangeErrorException {
        if (JSObjects.isUndefined(value)) {
            return fallback;
        }
        if (!JSObjects.isNumber(value)) {
            throw new JSRangeErrorException("Invalid number value !");
        }
        double d = JSObjects.getJavaDouble(value);
        if (Double.isNaN(d) || d > JSObjects.getJavaDouble(maximum) || d < JSObjects.getJavaDouble(minimum)) {
            throw new JSRangeErrorException("Invalid number value !");
        }
        return value;
    }

    public static Object GetNumberOption(Object options, String property, Object minimum, Object maximum, Object fallback) throws JSRangeErrorException {
        Object value = JSObjects.Get(options, property);
        return OptionHelpers.DefaultNumberOption(value, minimum, maximum, fallback);
    }

    public static Object GetOption(Object options, String property, OptionType type, Object validValues, Object fallback) throws JSRangeErrorException {
        Object value = JSObjects.Get(options, property);
        if (JSObjects.isUndefined(value)) {
            return fallback;
        }
        if (JSObjects.isNull(value)) {
            value = "";
        }
        if (type == OptionType.BOOLEAN && !JSObjects.isBoolean(value)) {
            throw new JSRangeErrorException("Boolean option expected but not found");
        }
        if (type == OptionType.STRING && !JSObjects.isString(value)) {
            throw new JSRangeErrorException("String option expected but not found");
        }
        if (!JSObjects.isUndefined(validValues) && !Arrays.asList((Object[])validValues).contains(value)) {
            throw new JSRangeErrorException("String option expected but not found");
        }
        return value;
    }

    public static <T extends Enum<T>> T searchEnum(Class<T> enumeration, Object value) {
        try {
            if (JSObjects.isUndefined(value)) {
                return Enum.valueOf(enumeration, "UNDEFINED");
            }
            if (JSObjects.isNull(value)) {
                return null;
            }
            String valueString = JSObjects.getJavaString(value);
            if (valueString.equals("2-digit")) {
                return Enum.valueOf(enumeration, "DIGIT2");
            }
            for (Enum each : (Enum[])enumeration.getEnumConstants()) {
                if (each.name().compareToIgnoreCase(valueString) != 0) continue;
                return (T)each;
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static enum OptionType {
        BOOLEAN,
        STRING;

    }
}

