/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import com.facebook.hermes.intl.IntlTextUtils;

class LocaleIdTokenizer {
    private CharSequence mLocaleIdBuffer;
    int mCurrentSubtagStart = 0;
    int mCurrentSubtagEnd = -1;

    private static boolean isSubtagSeparator(char c) {
        return c == '-';
    }

    public LocaleIdTokenizer(CharSequence localeIdBuffer) {
        this.mLocaleIdBuffer = localeIdBuffer;
    }

    public boolean hasMoreSubtags() {
        return this.mLocaleIdBuffer.length() > 0 && this.mCurrentSubtagEnd < this.mLocaleIdBuffer.length() - 1;
    }

    public LocaleIdSubtag nextSubtag() throws LocaleIdSubtagIterationFailed {
        if (!this.hasMoreSubtags()) {
            throw new LocaleIdSubtagIterationFailed();
        }
        if (this.mCurrentSubtagEnd >= this.mCurrentSubtagStart) {
            if (!LocaleIdTokenizer.isSubtagSeparator(this.mLocaleIdBuffer.charAt(this.mCurrentSubtagEnd + 1))) {
                throw new LocaleIdSubtagIterationFailed();
            }
            if (this.mCurrentSubtagEnd + 2 == this.mLocaleIdBuffer.length()) {
                throw new LocaleIdSubtagIterationFailed();
            }
            this.mCurrentSubtagStart = this.mCurrentSubtagEnd + 2;
        }
        this.mCurrentSubtagEnd = this.mCurrentSubtagStart;
        while (this.mCurrentSubtagEnd < this.mLocaleIdBuffer.length() && !LocaleIdTokenizer.isSubtagSeparator(this.mLocaleIdBuffer.charAt(this.mCurrentSubtagEnd))) {
            ++this.mCurrentSubtagEnd;
        }
        if (this.mCurrentSubtagEnd > this.mCurrentSubtagStart) {
            --this.mCurrentSubtagEnd;
            return new LocaleIdSubtag(this.mLocaleIdBuffer, this.mCurrentSubtagStart, this.mCurrentSubtagEnd);
        }
        throw new LocaleIdSubtagIterationFailed();
    }

    public class LocaleIdSubtagIterationFailed
    extends Exception {
    }

    public class LocaleIdSubtag {
        private CharSequence mLocaleIdBuffer = "";
        private int mSubtagStart = 0;
        private int mSubtagEnd = 0;

        LocaleIdSubtag(CharSequence localeIdBuffer, int subtagStart, int subtagEnd) {
            this.mLocaleIdBuffer = localeIdBuffer;
            this.mSubtagStart = subtagStart;
            this.mSubtagEnd = subtagEnd;
        }

        public void reset() {
            this.mLocaleIdBuffer = "";
            this.mSubtagStart = 0;
            this.mSubtagEnd = 0;
        }

        public String toString() {
            return this.mLocaleIdBuffer.subSequence(this.mSubtagStart, this.mSubtagEnd + 1).toString();
        }

        public String toLowerString() {
            StringBuffer destination = new StringBuffer();
            for (int idx = this.mSubtagStart; idx <= this.mSubtagEnd; ++idx) {
                destination.append(Character.toLowerCase(this.mLocaleIdBuffer.charAt(idx)));
            }
            return destination.toString();
        }

        public String toUpperString() {
            StringBuffer destination = new StringBuffer();
            for (int idx = this.mSubtagStart; idx <= this.mSubtagEnd; ++idx) {
                destination.append(Character.toUpperCase(this.mLocaleIdBuffer.charAt(idx)));
            }
            return destination.toString();
        }

        public String toTitleString() {
            StringBuffer destination = new StringBuffer();
            for (int idx = this.mSubtagStart; idx <= this.mSubtagEnd; ++idx) {
                if (idx == this.mSubtagStart) {
                    destination.append(Character.toUpperCase(this.mLocaleIdBuffer.charAt(idx)));
                    continue;
                }
                destination.append(Character.toLowerCase(this.mLocaleIdBuffer.charAt(idx)));
            }
            return destination.toString();
        }

        public boolean isUnicodeLanguageSubtag() {
            return IntlTextUtils.isUnicodeLanguageSubtag(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }

        public boolean isExtensionSingleton() {
            return IntlTextUtils.isExtensionSingleton(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }

        public boolean isUnicodeScriptSubtag() {
            return IntlTextUtils.isUnicodeScriptSubtag(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }

        public boolean isUnicodeRegionSubtag() {
            return IntlTextUtils.isUnicodeRegionSubtag(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }

        public boolean isUnicodeVariantSubtag() {
            return IntlTextUtils.isUnicodeVariantSubtag(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }

        public boolean isUnicodeExtensionAttribute() {
            return IntlTextUtils.isUnicodeExtensionAttribute(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }

        public boolean isUnicodeExtensionKey() {
            return IntlTextUtils.isUnicodeExtensionKey(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }

        public boolean isUnicodeExtensionKeyTypeItem() {
            return IntlTextUtils.isUnicodeExtensionKeyTypeItem(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }

        public boolean isTranformedExtensionTKey() {
            return IntlTextUtils.isTranformedExtensionTKey(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }

        public boolean isTranformedExtensionTValueItem() {
            return IntlTextUtils.isTranformedExtensionTValueItem(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }

        public boolean isPrivateUseExtension() {
            return IntlTextUtils.isPrivateUseExtension(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }

        public boolean isOtherExtension() {
            return IntlTextUtils.isOtherExtension(this.mLocaleIdBuffer, this.mSubtagStart, this.mSubtagEnd);
        }
    }
}

