/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flipper;

import android.content.Context;
import com.facebook.flipper.android.AndroidFlipperClient;
import com.facebook.flipper.android.utils.FlipperUtils;
import com.facebook.flipper.core.FlipperClient;
import com.facebook.flipper.core.FlipperPlugin;
import com.facebook.flipper.plugins.crashreporter.CrashReporterPlugin;
import com.facebook.flipper.plugins.databases.DatabasesFlipperPlugin;
import com.facebook.flipper.plugins.fresco.FrescoFlipperPlugin;
import com.facebook.flipper.plugins.inspector.DescriptorMapping;
import com.facebook.flipper.plugins.inspector.InspectorFlipperPlugin;
import com.facebook.flipper.plugins.network.FlipperOkhttpInterceptor;
import com.facebook.flipper.plugins.network.NetworkFlipperPlugin;
import com.facebook.flipper.plugins.sharedpreferences.SharedPreferencesFlipperPlugin;
import com.facebook.react.ReactInstanceEventListener;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.flipper.ReactNativeFlipper;
import com.facebook.react.modules.network.NetworkingModule;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/facebook/react/flipper/ReactNativeFlipper;", "", "()V", "initializeFlipper", "", "context", "Landroid/content/Context;", "reactInstanceManager", "Lcom/facebook/react/ReactInstanceManager;", "flipper-integration_debug"})
public final class ReactNativeFlipper {
    @NotNull
    public static final ReactNativeFlipper INSTANCE = new ReactNativeFlipper();

    private ReactNativeFlipper() {
    }

    @JvmStatic
    public static final void initializeFlipper(@NotNull Context context, @NotNull ReactInstanceManager reactInstanceManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reactInstanceManager, (String)"reactInstanceManager");
        if (ReactFeatureFlags.enableBridgelessArchitecture) {
            return;
        }
        if (FlipperUtils.shouldEnableFlipper((Context)context)) {
            FlipperClient client = AndroidFlipperClient.getInstance((Context)context);
            client.addPlugin((FlipperPlugin)new InspectorFlipperPlugin(context, DescriptorMapping.withDefaults()));
            client.addPlugin((FlipperPlugin)new DatabasesFlipperPlugin(context));
            client.addPlugin((FlipperPlugin)new SharedPreferencesFlipperPlugin(context));
            client.addPlugin((FlipperPlugin)CrashReporterPlugin.getInstance());
            NetworkFlipperPlugin networkFlipperPlugin = new NetworkFlipperPlugin();
            NetworkingModule.setCustomClientBuilder(arg_0 -> ReactNativeFlipper.initializeFlipper$lambda$0(networkFlipperPlugin, arg_0));
            client.addPlugin((FlipperPlugin)networkFlipperPlugin);
            client.start();
            ReactContext currentReactContext = reactInstanceManager.getCurrentReactContext();
            if (currentReactContext == null) {
                reactInstanceManager.addReactInstanceEventListener(new ReactInstanceEventListener(reactInstanceManager, client){
                    final /* synthetic */ ReactInstanceManager $reactInstanceManager;
                    final /* synthetic */ FlipperClient $client;
                    {
                        this.$reactInstanceManager = $reactInstanceManager;
                        this.$client = $client;
                    }

                    public void onReactContextInitialized(@NotNull ReactContext context) {
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        this.$reactInstanceManager.removeReactInstanceEventListener((ReactInstanceEventListener)this);
                        context.runOnNativeModulesQueueThread(() -> initializeFlipper.2.onReactContextInitialized$lambda$0(this.$client));
                    }

                    private static final void onReactContextInitialized$lambda$0(FlipperClient $client) {
                        $client.addPlugin((FlipperPlugin)new FrescoFlipperPlugin());
                    }
                });
            } else {
                client.addPlugin((FlipperPlugin)new FrescoFlipperPlugin());
            }
        }
    }

    private static final void initializeFlipper$lambda$0(NetworkFlipperPlugin $networkFlipperPlugin, OkHttpClient.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)$networkFlipperPlugin, (String)"$networkFlipperPlugin");
        builder.addNetworkInterceptor((Interceptor)new FlipperOkhttpInterceptor($networkFlipperPlugin));
    }
}

