/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.verifier.VerifierConfig;
import com.facebook.presto.verifier.VerifierQueryEvent;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.event.client.AbstractEventClient;
import io.airlift.event.client.JsonEventSerializer;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.inject.Inject;

public class JsonEventClient
extends AbstractEventClient {
    private final JsonEventSerializer serializer = new JsonEventSerializer(new Class[]{VerifierQueryEvent.class});
    private final JsonFactory factory = new JsonFactory();
    private final PrintStream out;

    @Inject
    public JsonEventClient(VerifierConfig config) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)config.getEventLogFile(), (Object)"event log file path is null");
        this.out = new PrintStream(config.getEventLogFile());
    }

    public <T> void postEvent(T event) throws IOException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            JsonGenerator generator = this.factory.createGenerator((OutputStream)buffer, JsonEncoding.UTF8);
            this.serializer.serialize(event, generator);
            this.out.println(buffer.toString().trim());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

