/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.util.Types;
import com.facebook.presto.verifier.VerifierConfig;
import com.facebook.presto.verifier.VerifierQueryEvent;
import io.airlift.event.client.AbstractEventClient;
import java.io.IOException;
import javax.inject.Inject;

public class HumanReadableEventClient
extends AbstractEventClient {
    private final boolean alwaysPrint;

    @Inject
    public HumanReadableEventClient(VerifierConfig config) {
        this.alwaysPrint = config.isAlwaysReport();
    }

    public <T> void postEvent(T event) throws IOException {
        VerifierQueryEvent queryEvent = (VerifierQueryEvent)Types.checkType(event, VerifierQueryEvent.class, (String)"event");
        if (this.alwaysPrint || queryEvent.isFailed()) {
            HumanReadableEventClient.printEvent(queryEvent);
        }
    }

    private static void printEvent(VerifierQueryEvent queryEvent) {
        System.out.println("----------");
        System.out.println("Name: " + queryEvent.getName());
        System.out.println("Schema (control): " + queryEvent.getControlSchema());
        System.out.println("Schema (test): " + queryEvent.getTestSchema());
        System.out.println("Valid: " + !queryEvent.isFailed());
        System.out.println("Query (test): " + queryEvent.getTestQuery());
        if (queryEvent.isFailed()) {
            System.out.println("\nError message:\n" + queryEvent.getErrorMessage());
        } else {
            System.out.println("Control Duration (secs): " + queryEvent.getControlWallTimeSecs());
            System.out.println("   Test Duration (secs): " + queryEvent.getTestWallTimeSecs());
        }
        System.out.println("----------");
    }
}

