/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

public class Query {
    private final String catalog;
    private final String schema;
    private final String query;

    public Query(String catalog, String schema, String query) {
        this.catalog = catalog;
        this.schema = schema;
        this.query = Query.clean(query);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getQuery() {
        return this.query;
    }

    private static String clean(String sql) {
        sql = sql.replaceAll("\t", "  ");
        sql = sql.replaceAll("\n+", "\n");
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        return sql;
    }
}

