/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.util.IterableTransformer;
import com.facebook.presto.verifier.ForwardingDriver;
import com.facebook.presto.verifier.PrestoVerifierModule;
import com.facebook.presto.verifier.Query;
import com.facebook.presto.verifier.QueryPair;
import com.facebook.presto.verifier.Verifier;
import com.facebook.presto.verifier.VerifierConfig;
import com.facebook.presto.verifier.VerifierDao;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.event.client.EventClient;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.List;
import java.util.Set;
import org.skife.jdbi.v2.DBI;

public class PrestoVerifier {
    public static final String SUPPORTED_EVENT_CLIENTS = "SUPPORTED_EVENT_CLIENTS";

    protected PrestoVerifier() {
    }

    public static void main(String[] args) throws Exception {
        new PrestoVerifier().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) throws Exception {
        if (args.length > 0) {
            System.setProperty("config", args[0]);
        }
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)new PrestoVerifierModule()).addAll(this.getAdditionalModules());
        Bootstrap app = new Bootstrap((Iterable)builder.build());
        Injector injector = app.strictConfig().initialize();
        try {
            VerifierConfig config = (VerifierConfig)injector.getInstance(VerifierConfig.class);
            injector.injectMembers((Object)this);
            Set supportedEventClients = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<String>>(){}, (Annotation)Names.named((String)SUPPORTED_EVENT_CLIENTS)));
            for (String clientType : config.getEventClients()) {
                Preconditions.checkArgument((boolean)supportedEventClients.contains(clientType), (String)"Unsupported event client: %s", (Object[])new Object[]{clientType});
            }
            Set eventClients = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<EventClient>>(){}));
            VerifierDao dao = (VerifierDao)new DBI(config.getQueryDatabase()).onDemand(VerifierDao.class);
            List<QueryPair> queries = dao.getQueriesBySuite(config.getSuite(), config.getMaxQueries());
            queries = PrestoVerifier.applyOverrides(config, queries);
            queries = this.filterQueries(queries);
            if (config.getAdditionalJdbcDriverPath() != null) {
                List<URL> urlList = PrestoVerifier.getUrls(config.getAdditionalJdbcDriverPath());
                URL[] urls = new URL[urlList.size()];
                urlList.toArray(urls);
                if (config.getTestJdbcDriverName() != null) {
                    PrestoVerifier.loadJdbcDriver(urls, config.getTestJdbcDriverName());
                }
                if (config.getControlJdbcDriverName() != null) {
                    PrestoVerifier.loadJdbcDriver(urls, config.getControlJdbcDriverName());
                }
            }
            Verifier verifier = new Verifier(System.out, config, eventClients);
            verifier.run(queries);
        }
        finally {
            ((LifeCycleManager)injector.getInstance(LifeCycleManager.class)).stop();
        }
    }

    private static void loadJdbcDriver(URL[] urls, String jdbcClassName) {
        try (URLClassLoader classLoader = new URLClassLoader(urls);){
            Driver driver = (Driver)Class.forName(jdbcClassName, true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            DriverManager.registerDriver(new ForwardingDriver(driver));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static List<URL> getUrls(String path) throws MalformedURLException {
        ImmutableList.Builder urlList = ImmutableList.builder();
        File driverPath = new File(path);
        if (!driverPath.isDirectory()) {
            urlList.add((Object)Paths.get(path, new String[0]).toUri().toURL());
            return urlList.build();
        }
        File[] files = driverPath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files == null) {
            return urlList.build();
        }
        for (File file : files) {
            if (file.isDirectory()) continue;
            urlList.add((Object)Paths.get(file.getAbsolutePath(), new String[0]).toUri().toURL());
        }
        return urlList.build();
    }

    protected List<QueryPair> filterQueries(List<QueryPair> queries) {
        return queries;
    }

    protected Iterable<Module> getAdditionalModules() {
        return ImmutableList.of();
    }

    private static List<QueryPair> applyOverrides(final VerifierConfig config, List<QueryPair> queries) {
        return IterableTransformer.on(queries).transform((Function)new Function<QueryPair, QueryPair>(){

            public QueryPair apply(QueryPair input) {
                Query test = new Query((String)Optional.fromNullable((Object)config.getTestCatalogOverride()).or((Object)input.getTest().getCatalog()), (String)Optional.fromNullable((Object)config.getTestSchemaOverride()).or((Object)input.getTest().getSchema()), input.getTest().getQuery());
                Query control = new Query((String)Optional.fromNullable((Object)config.getControlCatalogOverride()).or((Object)input.getControl().getCatalog()), (String)Optional.fromNullable((Object)config.getControlSchemaOverride()).or((Object)input.getControl().getSchema()), input.getControl().getQuery());
                return new QueryPair(input.getSuite(), input.getName(), test, control);
            }
        }).list();
    }
}

