/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.util.IterableTransformer;
import com.facebook.presto.verifier.HumanReadableEventClient;
import com.facebook.presto.verifier.JsonEventClient;
import com.facebook.presto.verifier.Query;
import com.facebook.presto.verifier.QueryPair;
import com.facebook.presto.verifier.Verifier;
import com.facebook.presto.verifier.VerifierConfig;
import com.facebook.presto.verifier.VerifierDao;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.event.client.EventClient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.v2.DBI;

public class PrestoVerifier {
    private final VerifierConfig config;

    protected PrestoVerifier(VerifierConfig config) {
        this.config = (VerifierConfig)Preconditions.checkNotNull((Object)config, (Object)"config is null");
    }

    public static void main(String[] args) throws Exception {
        Optional configPath = Optional.fromNullable(args.length > 0 ? args[0] : null);
        VerifierConfig config = PrestoVerifier.loadConfig(VerifierConfig.class, (Optional<String>)configPath);
        PrestoVerifier verifier = new PrestoVerifier(config);
        verifier.run();
        System.exit(0);
    }

    public void run() throws Exception {
        EventClient eventClient = this.getEventClient(this.config);
        VerifierDao dao = (VerifierDao)new DBI(this.config.getQueryDatabase()).onDemand(VerifierDao.class);
        List<QueryPair> queries = dao.getQueriesBySuite(this.config.getSuite(), this.config.getMaxQueries());
        queries = PrestoVerifier.applyOverrides(this.config, queries);
        queries = this.filterQueries(queries);
        Verifier verifier = new Verifier(System.out, this.config, eventClient);
        verifier.run(queries);
    }

    protected List<QueryPair> filterQueries(List<QueryPair> queries) {
        return queries;
    }

    private static List<QueryPair> applyOverrides(final VerifierConfig config, List<QueryPair> queries) {
        return IterableTransformer.on(queries).transform((Function)new Function<QueryPair, QueryPair>(){

            public QueryPair apply(QueryPair input) {
                Query test = new Query((String)Optional.fromNullable((Object)config.getTestCatalogOverride()).or((Object)input.getTest().getCatalog()), (String)Optional.fromNullable((Object)config.getTestSchemaOverride()).or((Object)input.getTest().getSchema()), input.getTest().getQuery());
                Query control = new Query((String)Optional.fromNullable((Object)config.getControlCatalogOverride()).or((Object)input.getControl().getCatalog()), (String)Optional.fromNullable((Object)config.getControlSchemaOverride()).or((Object)input.getControl().getSchema()), input.getControl().getQuery());
                return new QueryPair(input.getSuite(), input.getName(), test, control);
            }
        }).list();
    }

    private EventClient getEventClient(VerifierConfig config) throws FileNotFoundException {
        switch (config.getEventClient()) {
            case "human-readable": {
                return new HumanReadableEventClient(System.out, config.isAlwaysReport());
            }
            case "file": {
                Preconditions.checkNotNull((Object)config.getEventLogFile(), (Object)"event log file path is null");
                return new JsonEventClient(new PrintStream(config.getEventLogFile()));
            }
        }
        EventClient client = this.getEventClient(config.getEventClient());
        if (client != null) {
            return client;
        }
        throw new RuntimeException(String.format("Unsupported event client %s", config.getEventClient()));
    }

    protected EventClient getEventClient(String name) {
        return null;
    }

    public static <T> T loadConfig(Class<T> clazz, Optional<String> path) throws IOException {
        ImmutableMap.Builder map = ImmutableMap.builder();
        ConfigurationLoader loader = new ConfigurationLoader();
        if (path.isPresent()) {
            map.putAll(loader.loadPropertiesFrom((String)path.get()));
        }
        map.putAll(loader.getSystemProperties());
        return (T)new ConfigurationFactory((Map)map.build()).build(clazz);
    }
}

