/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.util.Types;
import com.facebook.presto.verifier.VerifierQueryEvent;
import com.google.common.base.Preconditions;
import io.airlift.event.client.AbstractEventClient;
import java.io.IOException;
import java.io.PrintStream;

public class HumanReadableEventClient
extends AbstractEventClient {
    private final PrintStream out;
    private final boolean alwaysPrint;

    public HumanReadableEventClient(PrintStream out, boolean alwaysPrint) {
        this.out = (PrintStream)Preconditions.checkNotNull((Object)out, (Object)"out is null");
        this.alwaysPrint = alwaysPrint;
    }

    public <T> void postEvent(T event) throws IOException {
        VerifierQueryEvent queryEvent = (VerifierQueryEvent)Types.checkType(event, VerifierQueryEvent.class, (String)"event");
        if (this.alwaysPrint || queryEvent.isFailed()) {
            this.printEvent(queryEvent);
        }
    }

    private void printEvent(VerifierQueryEvent queryEvent) {
        this.out.println("----------");
        this.out.println("Name: " + queryEvent.getName());
        this.out.println("Schema (control): " + queryEvent.getControlSchema());
        this.out.println("Schema (test): " + queryEvent.getTestSchema());
        this.out.println("Valid: " + !queryEvent.isFailed());
        this.out.println("Query (test): " + queryEvent.getTestQuery());
        if (queryEvent.isFailed()) {
            this.out.println("\nError message:\n" + queryEvent.getErrorMessage());
        } else {
            this.out.println("Control Duration (secs): " + queryEvent.getControlWallTimeSecs());
            this.out.println("   Test Duration (secs): " + queryEvent.getTestWallTimeSecs());
        }
        this.out.println("----------");
    }
}

