/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class VerifierConfig {
    private String testUsername = "verifier-test";
    private String controlUsername = "verifier-test";
    private String testPassword;
    private String controlPassword;
    private String suite;
    private String source;
    private String runId = new DateTime().toString("yyyy-MM-dd");
    private String eventClient = "human-readable";
    private int threadCount = 10;
    private String queryDatabase;
    private String controlGateway;
    private String testGateway;
    private Duration controlTimeout = new Duration(10.0, TimeUnit.MINUTES);
    private Duration testTimeout = new Duration(1.0, TimeUnit.HOURS);
    private Set<String> blacklist = ImmutableSet.of();
    private Set<String> whitelist = ImmutableSet.of();
    private int maxRowCount = 10000;
    private int maxQueries = 1000000;
    private boolean alwaysReport;
    private String eventLogFile;
    private int suiteRepetitions = 1;
    private int queryRepetitions = 1;
    private String skipCorrectnessRegex = "^$";
    private boolean checkCorrectness = true;
    private boolean verboseResultsComparison;
    private String testCatalogOverride;
    private String testSchemaOverride;
    private String controlCatalogOverride;
    private String controlSchemaOverride;
    private boolean quiet;

    @NotNull
    public String getSkipCorrectnessRegex() {
        return this.skipCorrectnessRegex;
    }

    @ConfigDescription(value="Correctness check will be skipped if this regex matches query")
    @Config(value="skip-correctness-regex")
    public VerifierConfig setSkipCorrectnessRegex(String skipCorrectnessRegex) {
        this.skipCorrectnessRegex = skipCorrectnessRegex;
        return this;
    }

    public boolean isVerboseResultsComparison() {
        return this.verboseResultsComparison;
    }

    @ConfigDescription(value="Display a diff of results that don't match")
    @Config(value="verbose-results-comparison")
    public VerifierConfig setVerboseResultsComparison(boolean verboseResultsComparison) {
        this.verboseResultsComparison = verboseResultsComparison;
        return this;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    @ConfigDescription(value="Reduces the number of informational messages printed")
    @Config(value="quiet")
    public VerifierConfig setQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    public int getQueryRepetitions() {
        return this.queryRepetitions;
    }

    @ConfigDescription(value="The number of times to repeat each query")
    @Config(value="query-repetitions")
    public VerifierConfig setQueryRepetitions(int queryRepetitions) {
        this.queryRepetitions = queryRepetitions;
        return this;
    }

    @NotNull
    public String getSuite() {
        return this.suite;
    }

    @ConfigDescription(value="The suite of queries in the query database to run")
    @Config(value="suite")
    public VerifierConfig setSuite(String suite) {
        this.suite = suite;
        return this;
    }

    @Min(value=1L)
    @Max(value=50L)
    public int getThreadCount() {
        return this.threadCount;
    }

    @ConfigDescription(value="The concurrency level")
    @Config(value="thread-count")
    public VerifierConfig setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    @NotNull
    public String getQueryDatabase() {
        return this.queryDatabase;
    }

    @ConfigDescription(value="Database to fetch query suites from")
    @Config(value="query-database")
    public VerifierConfig setQueryDatabase(String queryDatabase) {
        this.queryDatabase = queryDatabase;
        return this;
    }

    @NotNull
    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    @ConfigDescription(value="Names of queries which are blacklisted")
    @Config(value="blacklist")
    public VerifierConfig setBlacklist(String blacklist) {
        ImmutableSet.Builder blacklistBuilder = ImmutableSet.builder();
        for (String value : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)blacklist)) {
            blacklistBuilder.add((Object)value);
        }
        this.blacklist = blacklistBuilder.build();
        return this;
    }

    @NotNull
    public Set<String> getWhitelist() {
        return this.whitelist;
    }

    @ConfigDescription(value="Names of queries which are whitelisted. Whitelist is applied before the blacklist")
    @Config(value="whitelist")
    public VerifierConfig setWhitelist(String whitelist) {
        ImmutableSet.Builder whitelistBuilder = ImmutableSet.builder();
        for (String value : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)whitelist)) {
            whitelistBuilder.add((Object)value);
        }
        this.whitelist = whitelistBuilder.build();
        return this;
    }

    @Min(value=1L)
    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    @ConfigDescription(value="The maximum number of rows a query may return. If it exceeds this limit it's marked as failed")
    @Config(value="max-row-count")
    public VerifierConfig setMaxRowCount(int maxRowCount) {
        this.maxRowCount = maxRowCount;
        return this;
    }

    public boolean isAlwaysReport() {
        return this.alwaysReport;
    }

    @ConfigDescription(value="Print more informational messages")
    @Config(value="always-report")
    public VerifierConfig setAlwaysReport(boolean alwaysReport) {
        this.alwaysReport = alwaysReport;
        return this;
    }

    public int getMaxQueries() {
        return this.maxQueries;
    }

    @ConfigDescription(value="The maximum number of queries from the suite to run")
    @Config(value="max-queries")
    public VerifierConfig setMaxQueries(int maxQueries) {
        this.maxQueries = maxQueries;
        return this;
    }

    public boolean isCheckCorrectnessEnabled() {
        return this.checkCorrectness;
    }

    @ConfigDescription(value="Whether to check that the rows from control and test match")
    @Config(value="check-correctness")
    public VerifierConfig setCheckCorrectnessEnabled(boolean checkCorrectness) {
        this.checkCorrectness = checkCorrectness;
        return this;
    }

    public int getSuiteRepetitions() {
        return this.suiteRepetitions;
    }

    @ConfigDescription(value="Number of times to run the suite")
    @Config(value="suite-repetitions")
    public VerifierConfig setSuiteRepetitions(int suiteRepetitions) {
        this.suiteRepetitions = suiteRepetitions;
        return this;
    }

    @NotNull
    public String getEventClient() {
        return this.eventClient;
    }

    @ConfigDescription(value="The event client to log the results to")
    @Config(value="event-client")
    public VerifierConfig setEventClient(String eventClient) {
        this.eventClient = (String)Preconditions.checkNotNull((Object)eventClient, (Object)"eventClient is null");
        return this;
    }

    public String getSource() {
        return this.source;
    }

    @ConfigDescription(value="The source to pass to Presto")
    @Config(value="source")
    public VerifierConfig setSource(String source) {
        this.source = source;
        return this;
    }

    public String getRunId() {
        return this.runId;
    }

    @ConfigDescription(value="A customizable string that will be logged with the results")
    @Config(value="run-id")
    public VerifierConfig setRunId(String runId) {
        this.runId = runId;
        return this;
    }

    public String getEventLogFile() {
        return this.eventLogFile;
    }

    @ConfigDescription(value="The file to log events to. Used with event-client=file")
    @Config(value="event-log-file")
    public VerifierConfig setEventLogFile(String eventLogFile) {
        this.eventLogFile = eventLogFile;
        return this;
    }

    public String getTestCatalogOverride() {
        return this.testCatalogOverride;
    }

    @ConfigDescription(value="Overrides the test_catalog field in all queries in the suite")
    @Config(value="test.catalog-override")
    public VerifierConfig setTestCatalogOverride(String testCatalogOverride) {
        this.testCatalogOverride = testCatalogOverride;
        return this;
    }

    public String getTestSchemaOverride() {
        return this.testSchemaOverride;
    }

    @ConfigDescription(value="Overrides the test_schema field in all queries in the suite")
    @Config(value="test.schema-override")
    public VerifierConfig setTestSchemaOverride(String testSchemaOverride) {
        this.testSchemaOverride = testSchemaOverride;
        return this;
    }

    public Duration getTestTimeout() {
        return this.testTimeout;
    }

    @ConfigDescription(value="Timeout for queries to the test cluster")
    @Config(value="test.timeout")
    public VerifierConfig setTestTimeout(Duration testTimeout) {
        this.testTimeout = testTimeout;
        return this;
    }

    @NotNull
    public String getTestUsername() {
        return this.testUsername;
    }

    @ConfigDescription(value="Username for test cluster")
    @Config(value="test.username")
    public VerifierConfig setTestUsername(String testUsername) {
        this.testUsername = testUsername;
        return this;
    }

    @Nullable
    public String getTestPassword() {
        return this.testPassword;
    }

    @ConfigDescription(value="Password for test cluster")
    @Config(value="test.password")
    public VerifierConfig setTestPassword(String testPassword) {
        this.testPassword = testPassword;
        return this;
    }

    @NotNull
    public String getTestGateway() {
        return this.testGateway;
    }

    @ConfigDescription(value="URL for test cluster")
    @Config(value="test.gateway")
    public VerifierConfig setTestGateway(String testGateway) {
        this.testGateway = testGateway;
        return this;
    }

    public String getControlCatalogOverride() {
        return this.controlCatalogOverride;
    }

    @ConfigDescription(value="Overrides the control_catalog field in all queries in the suite")
    @Config(value="control.catalog-override")
    public VerifierConfig setControlCatalogOverride(String controlCatalogOverride) {
        this.controlCatalogOverride = controlCatalogOverride;
        return this;
    }

    public String getControlSchemaOverride() {
        return this.controlSchemaOverride;
    }

    @ConfigDescription(value="Overrides the control_schema field in all queries in the suite")
    @Config(value="control.schema-override")
    public VerifierConfig setControlSchemaOverride(String controlSchemaOverride) {
        this.controlSchemaOverride = controlSchemaOverride;
        return this;
    }

    public Duration getControlTimeout() {
        return this.controlTimeout;
    }

    @ConfigDescription(value="Timeout for queries to the control cluster")
    @Config(value="control.timeout")
    public VerifierConfig setControlTimeout(Duration controlTimeout) {
        this.controlTimeout = controlTimeout;
        return this;
    }

    @NotNull
    public String getControlUsername() {
        return this.controlUsername;
    }

    @ConfigDescription(value="Username for control cluster")
    @Config(value="control.username")
    public VerifierConfig setControlUsername(String controlUsername) {
        this.controlUsername = controlUsername;
        return this;
    }

    @Nullable
    public String getControlPassword() {
        return this.controlPassword;
    }

    @ConfigDescription(value="Password for control cluster")
    @Config(value="control.password")
    public VerifierConfig setControlPassword(String controlPassword) {
        this.controlPassword = controlPassword;
        return this;
    }

    @NotNull
    public String getControlGateway() {
        return this.controlGateway;
    }

    @ConfigDescription(value="URL for control cluster")
    @Config(value="control.gateway")
    public VerifierConfig setControlGateway(String controlGateway) {
        this.controlGateway = controlGateway;
        return this;
    }
}

