/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.rewrite;

import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikeClause;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.ShowCreate;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.CreateViewVerification;
import com.facebook.presto.verifier.framework.DataVerificationUtil;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryObjectBundle;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.rewrite.FunctionCallRewriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Language;
import org.joda.time.DateTimeZone;

public class QueryRewriter {
    private final SqlParser sqlParser;
    private final TypeManager typeManager;
    private final BlockEncodingSerde blockEncodingSerde;
    private final PrestoAction prestoAction;
    private final Map<ClusterType, QualifiedName> prefixes;
    private final Map<ClusterType, List<Property>> tableProperties;
    private final Map<ClusterType, Boolean> reuseTables;
    private final Optional<FunctionCallRewriter> functionCallRewriter;

    public QueryRewriter(SqlParser sqlParser, TypeManager typeManager, BlockEncodingSerde blockEncodingSerde, PrestoAction prestoAction, Map<ClusterType, QualifiedName> tablePrefixes, Map<ClusterType, List<Property>> tableProperties, Map<ClusterType, Boolean> reuseTables) {
        this(sqlParser, typeManager, blockEncodingSerde, prestoAction, tablePrefixes, tableProperties, reuseTables, (Multimap<String, FunctionCallRewriter.FunctionCallSubstitute>)ImmutableMultimap.of());
    }

    public QueryRewriter(SqlParser sqlParser, TypeManager typeManager, BlockEncodingSerde blockEncodingSerde, PrestoAction prestoAction, Map<ClusterType, QualifiedName> tablePrefixes, Map<ClusterType, List<Property>> tableProperties, Map<ClusterType, Boolean> reuseTables, Multimap<String, FunctionCallRewriter.FunctionCallSubstitute> functionSubstitutes) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerge");
        this.prestoAction = Objects.requireNonNull(prestoAction, "prestoAction is null");
        this.prefixes = ImmutableMap.copyOf(tablePrefixes);
        this.tableProperties = ImmutableMap.copyOf(tableProperties);
        this.reuseTables = ImmutableMap.copyOf(reuseTables);
        this.functionCallRewriter = FunctionCallRewriter.getInstance(functionSubstitutes, typeManager);
    }

    public QueryObjectBundle rewriteQuery(@Language(value="SQL") String query, QueryConfiguration queryConfiguration, ClusterType clusterType) {
        return this.rewriteQuery(query, queryConfiguration, clusterType, false);
    }

    public QueryObjectBundle rewriteQuery(@Language(value="SQL") String query, QueryConfiguration queryConfiguration, ClusterType clusterType, boolean reuseTable) {
        boolean shouldReuseTable;
        Preconditions.checkState((boolean)this.prefixes.containsKey((Object)clusterType), (String)"Unsupported cluster type: %s", (Object)((Object)clusterType));
        Statement statement = this.sqlParser.createStatement(query, VerifierUtil.PARSING_OPTIONS);
        QualifiedName prefix = this.prefixes.get((Object)clusterType);
        List<Property> properties = this.tableProperties.get((Object)clusterType);
        boolean bl = shouldReuseTable = reuseTable && this.reuseTables.get((Object)clusterType) != false && queryConfiguration.isReusableTable();
        if (statement instanceof CreateTableAsSelect) {
            Optional<Expression> partitionsPredicate;
            CreateTableAsSelect createTableAsSelect = (CreateTableAsSelect)statement;
            Query createQuery = createTableAsSelect.getQuery();
            Optional<String> functionSubstitutions = Optional.empty();
            if (this.functionCallRewriter.isPresent()) {
                FunctionCallRewriter.RewriterResult rewriterResult = this.functionCallRewriter.get().rewrite((Statement)createQuery);
                createQuery = (Query)rewriterResult.getRewrittenNode();
                functionSubstitutions = rewriterResult.getSubstitutions();
            }
            if (shouldReuseTable && !functionSubstitutions.isPresent() && (partitionsPredicate = this.getPartitionsPredicate(createTableAsSelect.getName(), queryConfiguration.getPartitions())).isPresent()) {
                return new QueryObjectBundle(createTableAsSelect.getName(), (List<Statement>)ImmutableList.of(), (Statement)createTableAsSelect, (List<Statement>)ImmutableList.of(), clusterType, Optional.empty(), partitionsPredicate, true);
            }
            QualifiedName temporaryTableName = this.generateTemporaryName(Optional.of(createTableAsSelect.getName()), prefix);
            return new QueryObjectBundle(temporaryTableName, (List<Statement>)ImmutableList.of(), (Statement)new CreateTableAsSelect(temporaryTableName, createQuery, createTableAsSelect.isNotExists(), QueryRewriter.applyPropertyOverride(createTableAsSelect.getProperties(), properties), createTableAsSelect.isWithData(), createTableAsSelect.getColumnAliases(), createTableAsSelect.getComment()), (List<Statement>)ImmutableList.of((Object)new DropTable(temporaryTableName, true)), clusterType, functionSubstitutions, Optional.empty(), false);
        }
        if (statement instanceof Insert) {
            Optional<Expression> partitionsPredicate;
            Insert insert = (Insert)statement;
            QualifiedName originalTableName = insert.getTarget();
            Query insertQuery = insert.getQuery();
            Optional<String> functionSubstitutions = Optional.empty();
            if (this.functionCallRewriter.isPresent()) {
                FunctionCallRewriter.RewriterResult rewriterResult = this.functionCallRewriter.get().rewrite((Statement)insertQuery);
                insertQuery = (Query)rewriterResult.getRewrittenNode();
                functionSubstitutions = rewriterResult.getSubstitutions();
            }
            if (shouldReuseTable && !functionSubstitutions.isPresent() && (partitionsPredicate = this.getPartitionsPredicate(originalTableName, queryConfiguration.getPartitions())).isPresent()) {
                return new QueryObjectBundle(originalTableName, (List<Statement>)ImmutableList.of(), (Statement)insert, (List<Statement>)ImmutableList.of(), clusterType, Optional.empty(), partitionsPredicate, true);
            }
            QualifiedName temporaryTableName = this.generateTemporaryName(Optional.of(originalTableName), prefix);
            return new QueryObjectBundle(temporaryTableName, (List<Statement>)ImmutableList.of((Object)new CreateTable(temporaryTableName, (List)ImmutableList.of((Object)new LikeClause(originalTableName, Optional.of(LikeClause.PropertiesOption.INCLUDING))), false, properties, Optional.empty())), (Statement)new Insert(temporaryTableName, insert.getColumns(), insertQuery), (List<Statement>)ImmutableList.of((Object)new DropTable(temporaryTableName, true)), clusterType, functionSubstitutions, Optional.empty(), false);
        }
        if (statement instanceof Query) {
            Query queryBody = (Query)statement;
            Optional<String> functionSubstitutions = Optional.empty();
            if (this.functionCallRewriter.isPresent()) {
                FunctionCallRewriter.RewriterResult rewriterResult = this.functionCallRewriter.get().rewrite((Statement)queryBody);
                queryBody = (Query)rewriterResult.getRewrittenNode();
                functionSubstitutions = rewriterResult.getSubstitutions();
            }
            QualifiedName temporaryTableName = this.generateTemporaryName(Optional.empty(), prefix);
            ResultSetMetaData metadata = this.getResultMetadata(queryBody);
            List<Identifier> columnAliases = this.generateStorageColumnAliases(metadata);
            queryBody = this.rewriteNonStorableColumns(queryBody, metadata);
            return new QueryObjectBundle(temporaryTableName, (List<Statement>)ImmutableList.of(), (Statement)new CreateTableAsSelect(temporaryTableName, queryBody, false, properties, true, Optional.of(columnAliases), Optional.empty()), (List<Statement>)ImmutableList.of((Object)new DropTable(temporaryTableName, true)), clusterType, functionSubstitutions, Optional.empty(), false);
        }
        if (statement instanceof CreateView) {
            CreateView createView = (CreateView)statement;
            QualifiedName temporaryViewName = this.generateTemporaryName(Optional.empty(), prefix);
            ImmutableList.Builder setupQueries = ImmutableList.builder();
            try {
                String createExistingViewQuery = (String)Iterables.getOnlyElement(this.prestoAction.execute((Statement)new ShowCreate(ShowCreate.Type.VIEW, createView.getName()), QueryStage.REWRITE, CreateViewVerification.SHOW_CREATE_VIEW_CONVERTER).getResults());
                CreateView createExistingView = (CreateView)this.sqlParser.createStatement(createExistingViewQuery, VerifierUtil.PARSING_OPTIONS);
                setupQueries.add((Object)new CreateView(temporaryViewName, createExistingView.getQuery(), false, createExistingView.getSecurity()));
            }
            catch (QueryException queryException) {
                // empty catch block
            }
            return new QueryObjectBundle(temporaryViewName, (List<Statement>)setupQueries.build(), (Statement)new CreateView(temporaryViewName, createView.getQuery(), createView.isReplace(), createView.getSecurity()), (List<Statement>)ImmutableList.of((Object)new DropView(temporaryViewName, true)), clusterType, Optional.empty(), Optional.empty(), false);
        }
        if (statement instanceof CreateTable) {
            CreateTable createTable = (CreateTable)statement;
            QualifiedName temporaryTableName = this.generateTemporaryName(Optional.empty(), prefix);
            return new QueryObjectBundle(temporaryTableName, (List<Statement>)ImmutableList.of(), (Statement)new CreateTable(temporaryTableName, createTable.getElements(), createTable.isNotExists(), QueryRewriter.applyPropertyOverride(createTable.getProperties(), properties), createTable.getComment()), (List<Statement>)ImmutableList.of((Object)new DropTable(temporaryTableName, true)), clusterType, Optional.empty(), Optional.empty(), false);
        }
        throw new IllegalStateException(String.format("Unsupported query type: %s", statement.getClass()));
    }

    private QualifiedName generateTemporaryName(Optional<QualifiedName> originalName, QualifiedName prefix) {
        ArrayList parts = new ArrayList();
        int originalSize = originalName.map(QualifiedName::getOriginalParts).map(List::size).orElse(0);
        int prefixSize = prefix.getOriginalParts().size();
        if (originalName.isPresent() && originalSize > prefixSize) {
            parts.addAll(originalName.get().getOriginalParts().subList(0, originalSize - prefixSize));
        }
        parts.addAll(prefix.getOriginalParts());
        parts.set(parts.size() - 1, prefix.getSuffix() + "_" + UUID.randomUUID().toString().replace("-", ""));
        return QualifiedName.of(parts);
    }

    private List<Identifier> generateStorageColumnAliases(ResultSetMetaData metadata) {
        ImmutableList.Builder aliases = ImmutableList.builder();
        HashSet<String> usedAliases = new HashSet<String>();
        for (String columnName : VerifierUtil.getColumnNames(metadata)) {
            String alias = columnName = QueryRewriter.sanitizeColumnName(columnName);
            int postfix = 1;
            while (usedAliases.contains(alias)) {
                alias = String.format("%s__%s", columnName, postfix);
                ++postfix;
            }
            aliases.add((Object)new Identifier(alias, true));
            usedAliases.add(alias);
        }
        return aliases.build();
    }

    private ResultSetMetaData getResultMetadata(Query query) {
        Query zeroRowQuery;
        if (query.getQueryBody() instanceof QuerySpecification) {
            QuerySpecification querySpecification = (QuerySpecification)query.getQueryBody();
            zeroRowQuery = new Query(query.getWith(), (QueryBody)new QuerySpecification(querySpecification.getSelect(), querySpecification.getFrom(), querySpecification.getWhere(), querySpecification.getGroupBy(), querySpecification.getHaving(), querySpecification.getOrderBy(), querySpecification.getOffset(), Optional.of("0")), Optional.empty(), Optional.empty(), Optional.empty());
        } else {
            zeroRowQuery = new Query(query.getWith(), query.getQueryBody(), Optional.empty(), Optional.empty(), Optional.of("0"));
        }
        return this.prestoAction.execute((Statement)zeroRowQuery, QueryStage.REWRITE, PrestoAction.ResultSetConverter.DEFAULT).getMetadata();
    }

    private Query rewriteNonStorableColumns(Query query, ResultSetMetaData metadata) {
        List<Type> columnTypes = VerifierUtil.getColumnTypes(this.typeManager, metadata);
        if (columnTypes.stream().noneMatch(type -> this.getColumnTypeRewrite((Type)type).isPresent())) {
            return query;
        }
        if (!(query.getQueryBody() instanceof QuerySpecification)) {
            return query;
        }
        QuerySpecification querySpecification = (QuerySpecification)query.getQueryBody();
        List selectItems = querySpecification.getSelect().getSelectItems();
        if (selectItems.stream().anyMatch(AllColumns.class::isInstance)) {
            return query;
        }
        ArrayList<SingleColumn> newItems = new ArrayList<SingleColumn>();
        Preconditions.checkState((selectItems.size() == columnTypes.size() ? 1 : 0) != 0, (String)"SelectItem count (%s) mismatches column count (%s)", (int)selectItems.size(), (int)columnTypes.size());
        for (int i = 0; i < selectItems.size(); ++i) {
            SingleColumn singleColumn = (SingleColumn)selectItems.get(i);
            Optional<Type> columnTypeRewrite = this.getColumnTypeRewrite(columnTypes.get(i));
            if (columnTypeRewrite.isPresent()) {
                newItems.add(new SingleColumn((Expression)new Cast(singleColumn.getExpression(), columnTypeRewrite.get().getTypeSignature().toString()), singleColumn.getAlias()));
                continue;
            }
            newItems.add(singleColumn);
        }
        return new Query(query.getWith(), (QueryBody)new QuerySpecification(new Select(querySpecification.getSelect().isDistinct(), newItems), querySpecification.getFrom(), querySpecification.getWhere(), querySpecification.getGroupBy(), querySpecification.getHaving(), querySpecification.getOrderBy(), Optional.empty(), querySpecification.getLimit()), query.getOrderBy(), Optional.empty(), query.getLimit());
    }

    private Optional<Type> getColumnTypeRewrite(Type type) {
        if (type.equals(DateType.DATE) || type.equals(TimeType.TIME)) {
            return Optional.of(TimestampType.TIMESTAMP);
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return Optional.of(VarcharType.VARCHAR);
        }
        if (type.equals(UnknownType.UNKNOWN)) {
            return Optional.of(BigintType.BIGINT);
        }
        if (type instanceof DecimalType) {
            return Optional.of(DoubleType.DOUBLE);
        }
        if (type instanceof ArrayType) {
            return this.getColumnTypeRewrite(((ArrayType)type).getElementType()).map(ArrayType::new);
        }
        if (type instanceof MapType) {
            Type keyType = ((MapType)type).getKeyType();
            Type valueType = ((MapType)type).getValueType();
            Optional<Type> keyTypeRewrite = this.getColumnTypeRewrite(keyType);
            Optional<Type> valueTypeRewrite = this.getColumnTypeRewrite(valueType);
            if (keyTypeRewrite.isPresent() || valueTypeRewrite.isPresent()) {
                return Optional.of(this.typeManager.getType(new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)keyTypeRewrite.orElse(keyType).getTypeSignature()), TypeSignatureParameter.of((TypeSignature)valueTypeRewrite.orElse(valueType).getTypeSignature())})));
            }
            return Optional.empty();
        }
        if (type instanceof RowType) {
            List fields = ((RowType)type).getFields();
            ArrayList<RowType.Field> fieldsRewrite = new ArrayList<RowType.Field>();
            boolean rewrite = false;
            for (RowType.Field field : fields) {
                Optional<Type> fieldTypeRewrite = this.getColumnTypeRewrite(field.getType());
                rewrite = rewrite || fieldTypeRewrite.isPresent();
                fieldsRewrite.add(new RowType.Field(field.getName(), fieldTypeRewrite.orElse(field.getType())));
            }
            return rewrite ? Optional.of(RowType.from(fieldsRewrite)) : Optional.empty();
        }
        return Optional.empty();
    }

    private static String sanitizeColumnName(String columnName) {
        return columnName.replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase(Locale.ENGLISH);
    }

    private static List<Property> applyPropertyOverride(List<Property> properties, List<Property> overrides) {
        Map propertyMap = (Map)properties.stream().collect(ImmutableMap.toImmutableMap(property -> property.getName().getValueLowerCase(), Property::getValue));
        Map overrideMap = (Map)overrides.stream().collect(ImmutableMap.toImmutableMap(property -> property.getName().getValueLowerCase(), Property::getValue));
        return (List)Stream.concat(propertyMap.entrySet().stream(), overrideMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (original, override) -> override)).entrySet().stream().map(entry -> new Property(new Identifier((String)entry.getKey()), (Expression)entry.getValue())).collect(ImmutableList.toImmutableList());
    }

    private Optional<Expression> getPartitionsPredicate(QualifiedName tableName, List<String> partitions) {
        if (partitions.isEmpty()) {
            return Optional.empty();
        }
        List<Column> columns = DataVerificationUtil.getColumns(this.prestoAction, this.typeManager, tableName);
        LogicalBinaryExpression disjunct = null;
        for (String partition : partitions) {
            Optional<Object> conjunct = Optional.empty();
            try {
                conjunct = this.getPartitionConjunct(partition, columns);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!conjunct.isPresent()) {
                return Optional.empty();
            }
            disjunct = disjunct == null ? (Expression)conjunct.get() : new LogicalBinaryExpression(LogicalBinaryExpression.Operator.OR, (Expression)disjunct, (Expression)conjunct.get());
        }
        return Optional.ofNullable(disjunct);
    }

    private Optional<Expression> getPartitionConjunct(String partition, List<Column> columns) {
        IsNullPredicate conjunct = null;
        Map partitionRawKeyValues = MetastoreUtil.toPartitionNamesAndValues((String)partition);
        for (String partitionKey : partitionRawKeyValues.keySet()) {
            Type type = null;
            for (Column column : columns) {
                if (!column.getName().equals(partitionKey)) continue;
                type = column.getType();
                break;
            }
            if (type == null) {
                return Optional.empty();
            }
            NullableValue partitionValue = HiveUtil.parsePartitionValue((String)partitionKey, (String)((String)partitionRawKeyValues.get(partitionKey)), type, (DateTimeZone)DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault()));
            IsNullPredicate equalPredicate = null;
            if (partitionValue.isNull()) {
                equalPredicate = new IsNullPredicate((Expression)new Identifier(partitionKey));
            } else {
                LiteralEncoder literalEncoder = new LiteralEncoder(this.blockEncodingSerde);
                equalPredicate = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Identifier(partitionKey), literalEncoder.toExpression(partitionValue.getValue(), partitionValue.getType(), false));
            }
            conjunct = conjunct == null ? equalPredicate : new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, (Expression)conjunct, (Expression)equalPredicate);
        }
        return Optional.ofNullable(conjunct);
    }
}

