/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.rewrite;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.sql.tree.QualifiedName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class QueryRewriteConfig {
    private QualifiedName tablePrefix = QualifiedName.of((String)"tmp_verifier");
    private Map<String, Object> tableProperties = ImmutableMap.of();
    private boolean reuseTable;

    public boolean isReuseTable() {
        return this.reuseTable;
    }

    @ConfigDescription(value="If true, reuse the output table of the source query. Otherwise, run the query and write to a temporary shadow table.")
    @Config(value="reuse-table")
    public QueryRewriteConfig setReuseTable(boolean reuseTable) {
        this.reuseTable = reuseTable;
        return this;
    }

    @NotNull
    public QualifiedName getTablePrefix() {
        return this.tablePrefix;
    }

    @ConfigDescription(value="The prefix to use for temporary shadow tables. May be fully qualified like 'tmp_catalog.tmp_schema.tmp_'")
    @Config(value="table-prefix")
    public QueryRewriteConfig setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix == null ? null : QualifiedName.of((Iterable)Splitter.on((String)".").splitToList((CharSequence)tablePrefix));
        return this;
    }

    @NotNull
    public Map<String, Object> getTableProperties() {
        return this.tableProperties;
    }

    @ConfigDescription(value="A json map representing the table properties of the temporary tables")
    @Config(value="table-properties")
    public QueryRewriteConfig setTableProperties(String tableProperties) {
        if (tableProperties == null) {
            return this;
        }
        try {
            this.tableProperties = (Map)new ObjectMapper().readValue(tableProperties, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }
}

