/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.rewrite;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.sql.ExpressionFormatter;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.rewrite.DefaultTreeRewriter;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FunctionCallRewriter {
    private static final List<Class<?>> SUPPORTED_ORIGINAL_FUNCTIONS = ImmutableList.of(FunctionCall.class, CurrentTime.class);
    private static final List<Class<?>> SUPPORTED_SUBSTITUTE_EXPRESSIONS = ImmutableList.of(FunctionCall.class, IfExpression.class, SimpleCaseExpression.class, SearchedCaseExpression.class, Identifier.class, Literal.class, ArrayConstructor.class);
    private static final String OMIT_IDENTIFIER = "_";
    private final Multimap<String, FunctionCallSubstitute> functionCallSubstituteMap;
    private final FunctionAndTypeManager functionAndTypeManager;

    private FunctionCallRewriter(Multimap<String, FunctionCallSubstitute> functionCallSubstituteMap, FunctionAndTypeManager functionAndTypeManager) {
        this.functionCallSubstituteMap = Objects.requireNonNull(functionCallSubstituteMap, "functionCallSubstituteMap is null.");
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
    }

    public static Optional<FunctionCallRewriter> getInstance(Multimap<String, FunctionCallSubstitute> functionCallSubstitutes, TypeManager typeManager) {
        if (functionCallSubstitutes.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkState((boolean)(typeManager instanceof FunctionAndTypeManager), (Object)"FunctionAndTypeManager is required for FunctionCallRewriter.");
        return Optional.of(new FunctionCallRewriter(functionCallSubstitutes, (FunctionAndTypeManager)typeManager));
    }

    public static Multimap<String, FunctionCallSubstitute> validateAndConstructFunctionCallSubstituteMap(String functionCallSubstitutes) {
        ImmutableMultimap.Builder map = ImmutableMultimap.builder();
        if (functionCallSubstitutes == null) {
            return map.build();
        }
        Splitter commaSplitter = Splitter.on((String)"/,/").omitEmptyStrings().trimResults();
        Splitter slashSplitter = Splitter.on((char)'/').omitEmptyStrings().trimResults();
        for (String substitute : commaSplitter.split((CharSequence)functionCallSubstitutes)) {
            FunctionCall originalFunction;
            List specs = slashSplitter.splitToList((CharSequence)substitute);
            if (specs.size() != 2) {
                throw new IllegalArgumentException(String.format("Original function call and substitute must both be specified, %s.", substitute));
            }
            Expression originalExpression = FunctionCallRewriter.parseOriginalFunctionCall((String)specs.get(0));
            Expression substituteExpression = FunctionCallRewriter.parseSubstituteExpression((String)specs.get(1));
            if (originalExpression instanceof FunctionCall) {
                originalFunction = (FunctionCall)originalExpression;
                map.put((Object)originalFunction.getName().getSuffix(), (Object)new FunctionCallSubstitute(originalExpression, substituteExpression));
                continue;
            }
            if (!(originalExpression instanceof CurrentTime)) continue;
            originalFunction = (CurrentTime)originalExpression;
            map.put((Object)originalFunction.getFunction().getName(), (Object)new FunctionCallSubstitute(originalExpression, substituteExpression));
        }
        return map.build();
    }

    public RewriterResult rewrite(Statement root) {
        RewriterContext context = new RewriterContext();
        Statement rewrittenRoot = (Statement)new Rewriter(this.functionCallSubstituteMap, this.functionAndTypeManager).process((Node)root, context);
        String functionCallSubstitutes = context.rewrittenFunctionCalls.stream().map(functionCallSubstitute -> {
            String formattedOriginal = ExpressionFormatter.formatExpression((Expression)((FunctionCallSubstitute)functionCallSubstitute).originalExpression, Optional.empty());
            String formattedSubstitute = ExpressionFormatter.formatExpression((Expression)((FunctionCallSubstitute)functionCallSubstitute).substituteExpression, Optional.empty());
            return String.format("%s is substituted with %s", formattedOriginal, formattedSubstitute);
        }).collect(Collectors.joining(", "));
        return new RewriterResult(rewrittenRoot, functionCallSubstitutes.isEmpty() ? Optional.empty() : Optional.of(functionCallSubstitutes));
    }

    private static Expression parseOriginalFunctionCall(String functionCallSpec) {
        Expression expression;
        SqlParser sqlParser = new SqlParser();
        try {
            expression = sqlParser.createExpression(functionCallSpec, VerifierUtil.PARSING_OPTIONS);
        }
        catch (ParsingException e) {
            throw new IllegalArgumentException(String.format("Function call spec %s is not in a valid format.", functionCallSpec), e);
        }
        if (SUPPORTED_ORIGINAL_FUNCTIONS.stream().noneMatch(clazz -> clazz.equals(expression.getClass()))) {
            throw new IllegalArgumentException(String.format("Substituting %s in %s is not supported.", expression.getClass().getSimpleName(), functionCallSpec));
        }
        if (expression instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)expression;
            Stream<Object> arguments = functionCall.getArguments().stream();
            arguments = Stream.concat(arguments, functionCall.getOrderBy().map(OrderBy::getSortItems).orElse((List)ImmutableList.of()).stream().map(SortItem::getSortKey));
            arguments = Stream.concat(arguments, functionCall.getWindow().map(Window::getPartitionBy).orElse((List)ImmutableList.of()).stream());
            arguments = Stream.concat(arguments, functionCall.getWindow().flatMap(Window::getOrderBy).map(OrderBy::getSortItems).orElse((List)ImmutableList.of()).stream().map(SortItem::getSortKey));
            arguments.forEach(argument -> {
                if (argument instanceof Identifier || argument instanceof Literal) {
                    return;
                }
                if (argument instanceof ArrayConstructor) {
                    if (((ArrayConstructor)argument).getValues().stream().allMatch(Literal.class::isInstance)) {
                        return;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument of type %s from %s is not supported.", argument.getClass().getSimpleName(), functionCallSpec));
            });
        }
        return expression;
    }

    private static Expression parseSubstituteExpression(String expressionSpec) {
        Expression expression;
        SqlParser sqlParser = new SqlParser();
        try {
            expression = sqlParser.createExpression(expressionSpec, VerifierUtil.PARSING_OPTIONS);
        }
        catch (ParsingException e) {
            throw new IllegalArgumentException(String.format("Expression spec %s is not in a valid format.", expressionSpec), e);
        }
        if (SUPPORTED_SUBSTITUTE_EXPRESSIONS.stream().noneMatch(clazz -> clazz.isAssignableFrom(expression.getClass()))) {
            throw new IllegalArgumentException(String.format("Substitution of with from %s is not supported.", expression.getClass().getSimpleName()));
        }
        return expression;
    }

    private static Identifier toIdentifier(Expression expression) {
        if (expression instanceof Identifier) {
            return (Identifier)expression;
        }
        return new Identifier(String.valueOf(expression.toString().hashCode()));
    }

    private static class SubstituteIdentifierResolver {
        private final FunctionAndTypeManager functionAndTypeManager;

        public SubstituteIdentifierResolver(FunctionAndTypeManager functionAndTypeManager) {
            this.functionAndTypeManager = functionAndTypeManager;
        }

        public Expression resolve(Expression substitutePattern, final Map<Identifier, Expression> identifierToArgumentMap, final FunctionCall originalInstance) {
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

                public Expression rewriteIdentifier(Identifier identifier, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    if (!identifierToArgumentMap.containsKey(identifier)) {
                        return identifier;
                    }
                    return (Expression)identifierToArgumentMap.get(identifier);
                }

                public Expression rewriteFunctionCall(FunctionCall functionPattern, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    Optional<Window> rewrittenWindow;
                    Optional rewrittenOrderBy;
                    FunctionCall defaultRewrite = (FunctionCall)treeRewriter.defaultRewrite((Expression)functionPattern, (Object)context);
                    if (!this.isAggregateOrWindowFunction(functionPattern)) {
                        return defaultRewrite;
                    }
                    boolean rewrittenDistinct = originalInstance.isDistinct();
                    boolean rewrittenIgnoreNulls = false;
                    Optional rewrittenFilter = defaultRewrite.getFilter().isPresent() ? defaultRewrite.getFilter() : originalInstance.getFilter();
                    Optional optional = rewrittenOrderBy = defaultRewrite.getOrderBy().isPresent() ? defaultRewrite.getOrderBy() : originalInstance.getOrderBy();
                    if (defaultRewrite.getWindow().isPresent() && originalInstance.getWindow().isPresent()) {
                        Window defaultWindow = (Window)defaultRewrite.getWindow().get();
                        Window originalWindow = (Window)originalInstance.getWindow().get();
                        rewrittenWindow = Optional.of(new Window(!defaultWindow.getPartitionBy().isEmpty() ? defaultWindow.getPartitionBy() : originalWindow.getPartitionBy(), defaultWindow.getOrderBy().isPresent() ? defaultWindow.getOrderBy() : originalWindow.getOrderBy(), defaultWindow.getFrame().isPresent() ? defaultWindow.getFrame() : originalWindow.getFrame()));
                    } else {
                        rewrittenWindow = defaultRewrite.getWindow().isPresent() ? defaultRewrite.getWindow() : originalInstance.getWindow();
                    }
                    return new FunctionCall(defaultRewrite.getName(), (Optional)rewrittenWindow, rewrittenFilter, rewrittenOrderBy, rewrittenDistinct, rewrittenIgnoreNulls, defaultRewrite.getArguments());
                }

                public Expression rewriteLiteral(Literal literal, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    Expression argument = (Expression)identifierToArgumentMap.get(FunctionCallRewriter.toIdentifier((Expression)literal));
                    if (argument == null) {
                        return literal;
                    }
                    return argument;
                }

                public Expression rewriteArrayConstructor(ArrayConstructor array, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    Expression argument = (Expression)identifierToArgumentMap.get(FunctionCallRewriter.toIdentifier((Expression)array));
                    if (argument == null) {
                        return array;
                    }
                    return argument;
                }
            }, (Expression)substitutePattern);
        }

        private boolean isAggregateOrWindowFunction(FunctionCall functionCall) {
            Collection allFunctions = this.functionAndTypeManager.listBuiltInFunctions();
            for (SqlFunction function : allFunctions) {
                Signature signature = function.getSignature();
                if (!signature.getNameSuffix().equals(functionCall.getName().getSuffix()) || !signature.getKind().equals((Object)FunctionKind.AGGREGATE) && !signature.getKind().equals((Object)FunctionKind.WINDOW)) continue;
                return true;
            }
            return false;
        }
    }

    private static class RewriterContext {
        public List<FunctionCallSubstitute> rewrittenFunctionCalls = new ArrayList<FunctionCallSubstitute>();

        private RewriterContext() {
        }
    }

    private static class Rewriter
    extends DefaultTreeRewriter<RewriterContext> {
        private final Multimap<String, FunctionCallSubstitute> functionCallSubstituteMap;
        private final SubstituteIdentifierResolver substituteIdentifierResolver;

        public Rewriter(Multimap<String, FunctionCallSubstitute> functionCallSubstituteMap, FunctionAndTypeManager functionAndTypeManager) {
            this.functionCallSubstituteMap = Objects.requireNonNull(functionCallSubstituteMap, "functionCallSubstituteMap is null.");
            this.substituteIdentifierResolver = new SubstituteIdentifierResolver(functionAndTypeManager);
        }

        @Override
        protected Node visitExpression(Expression node, final RewriterContext context) {
            final Rewriter queryRewriter = this;
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

                public Expression rewriteFunctionCall(FunctionCall original, Void voidContext, ExpressionTreeRewriter<Void> treeRewriter) {
                    FunctionCall defaultRewrite = (FunctionCall)treeRewriter.defaultRewrite((Expression)original, (Object)voidContext);
                    Optional substituteInfo = this.getSubstitution(original);
                    if (!substituteInfo.isPresent()) {
                        return defaultRewrite;
                    }
                    Map identifierToArgumentMap = Rewriter.getIdentifierToOriginalArgumentMap((FunctionCall)((FunctionCallSubstitute)substituteInfo.get()).originalExpression, defaultRewrite);
                    Expression rewritten = this.buildSubstitute(((FunctionCallSubstitute)substituteInfo.get()).substituteExpression, identifierToArgumentMap, defaultRewrite);
                    context.rewrittenFunctionCalls.add(new FunctionCallSubstitute((Expression)original, rewritten));
                    return rewritten;
                }

                public Expression rewriteCurrentTime(CurrentTime original, Void voidContext, ExpressionTreeRewriter<Void> treeRewriter) {
                    CurrentTime defaultRewrite = (CurrentTime)treeRewriter.defaultRewrite((Expression)original, (Object)voidContext);
                    Optional substituteInfo = this.getSubstitution(original);
                    if (!substituteInfo.isPresent()) {
                        return defaultRewrite;
                    }
                    Expression rewritten = ((FunctionCallSubstitute)substituteInfo.get()).substituteExpression;
                    context.rewrittenFunctionCalls.add(new FunctionCallSubstitute((Expression)original, rewritten));
                    return rewritten;
                }

                public Expression rewriteSubqueryExpression(SubqueryExpression expression, Void voidContext, ExpressionTreeRewriter<Void> treeRewriter) {
                    Node query = (Node)queryRewriter.process((Node)expression.getQuery(), context);
                    if (expression.getQuery() == query) {
                        return expression;
                    }
                    return new SubqueryExpression((Query)query);
                }
            }, (Expression)node);
        }

        private Optional<FunctionCallSubstitute> getSubstitution(FunctionCall instance) {
            for (FunctionCallSubstitute substitution : this.functionCallSubstituteMap.get((Object)instance.getName().getSuffix())) {
                int i;
                if (!(substitution.originalExpression instanceof FunctionCall)) continue;
                List originalArguments = ((FunctionCall)substitution.originalExpression).getArguments();
                List instanceArguments = instance.getArguments();
                if (originalArguments.size() > instanceArguments.size()) continue;
                for (i = 0; i < originalArguments.size() && (!(originalArguments.get(i) instanceof Literal) || instanceArguments.get(i) instanceof Literal); ++i) {
                    if (!(originalArguments.get(i) instanceof ArrayConstructor)) continue;
                    if (!(instanceArguments.get(i) instanceof ArrayConstructor)) break;
                    List originalValues = ((ArrayConstructor)originalArguments.get(i)).getValues();
                    List actualValues = ((ArrayConstructor)instanceArguments.get(i)).getValues();
                    if (originalValues.isEmpty() || !(originalValues.get(0) instanceof Literal)) continue;
                    if (!actualValues.stream().allMatch(Literal.class::isInstance)) break;
                }
                if (i < originalArguments.size()) continue;
                return Optional.of(substitution);
            }
            return Optional.empty();
        }

        private Optional<FunctionCallSubstitute> getSubstitution(CurrentTime instance) {
            for (FunctionCallSubstitute substitution : this.functionCallSubstituteMap.get((Object)instance.getFunction().getName())) {
                if (!(substitution.originalExpression instanceof CurrentTime)) continue;
                return Optional.of(substitution);
            }
            return Optional.empty();
        }

        private static Map<Identifier, Expression> getIdentifierToOriginalArgumentMap(FunctionCall originalPattern, FunctionCall originalInstance) {
            ImmutableMap.Builder identifierToArgumentMap = ImmutableMap.builder();
            List patternArguments = originalPattern.getArguments();
            List instanceArguments = originalInstance.getArguments();
            for (int i = 0; i < patternArguments.size(); ++i) {
                Identifier identifier;
                if (patternArguments.get(i) instanceof Identifier && FunctionCallRewriter.OMIT_IDENTIFIER.equals((identifier = (Identifier)patternArguments.get(i)).getValue())) continue;
                identifierToArgumentMap.put((Object)FunctionCallRewriter.toIdentifier((Expression)patternArguments.get(i)), instanceArguments.get(i));
            }
            List patternOrderBys = originalPattern.getOrderBy().map(OrderBy::getSortItems).orElse((List)ImmutableList.of());
            List instanceOrderBys = originalInstance.getOrderBy().map(OrderBy::getSortItems).orElse((List)ImmutableList.of());
            for (int i = 0; i < patternOrderBys.size(); ++i) {
                Identifier identifier = (Identifier)((SortItem)patternOrderBys.get(i)).getSortKey();
                if (FunctionCallRewriter.OMIT_IDENTIFIER.equals(identifier.getValue())) continue;
                identifierToArgumentMap.put((Object)identifier, (Object)((SortItem)instanceOrderBys.get(i)).getSortKey());
            }
            List patternWindowPartitionBys = originalPattern.getWindow().map(Window::getPartitionBy).orElse((List)ImmutableList.of());
            List instanceWindowPartitionBys = originalInstance.getWindow().map(Window::getPartitionBy).orElse((List)ImmutableList.of());
            for (int i = 0; i < patternWindowPartitionBys.size(); ++i) {
                Identifier identifier = (Identifier)patternWindowPartitionBys.get(i);
                if (FunctionCallRewriter.OMIT_IDENTIFIER.equals(identifier.getValue())) continue;
                identifierToArgumentMap.put((Object)identifier, instanceWindowPartitionBys.get(i));
            }
            List patternWindowOrderBys = originalPattern.getWindow().flatMap(Window::getOrderBy).map(OrderBy::getSortItems).orElse((List)ImmutableList.of());
            List instanceWindowOrderBys = originalInstance.getWindow().flatMap(Window::getOrderBy).map(OrderBy::getSortItems).orElse((List)ImmutableList.of());
            for (int i = 0; i < patternWindowOrderBys.size(); ++i) {
                Identifier identifier = (Identifier)((SortItem)patternWindowOrderBys.get(i)).getSortKey();
                if (FunctionCallRewriter.OMIT_IDENTIFIER.equals(identifier.getValue())) continue;
                identifierToArgumentMap.put((Object)identifier, (Object)((SortItem)instanceWindowOrderBys.get(i)).getSortKey());
            }
            return identifierToArgumentMap.build();
        }

        private Expression buildSubstitute(Expression substitutePattern, Map<Identifier, Expression> identifierToArgumentMap, FunctionCall originalInstance) {
            return this.substituteIdentifierResolver.resolve(substitutePattern, identifierToArgumentMap, originalInstance);
        }
    }

    public static class RewriterResult {
        private final Statement rewrittenNode;
        private final Optional<String> substitutions;

        public RewriterResult(Statement rewrittenNode, Optional<String> substitutions) {
            this.rewrittenNode = Objects.requireNonNull(rewrittenNode, "rewrittenNode is null");
            this.substitutions = substitutions;
        }

        public Statement getRewrittenNode() {
            return this.rewrittenNode;
        }

        public Optional<String> getSubstitutions() {
            return this.substitutions;
        }
    }

    public static class FunctionCallSubstitute {
        private final Expression originalExpression;
        private final Expression substituteExpression;

        public FunctionCallSubstitute(Expression originalExpression, Expression substituteExpression) {
            this.originalExpression = Objects.requireNonNull(originalExpression, "originalExpression is null");
            this.substituteExpression = Objects.requireNonNull(substituteExpression, "substituteExpression is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionCallSubstitute that = (FunctionCallSubstitute)o;
            return this.originalExpression.equals((Object)that.originalExpression) && this.substituteExpression.equals((Object)that.substituteExpression);
        }

        public int hashCode() {
            return Objects.hash(this.originalExpression, this.substituteExpression);
        }
    }
}

