/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.rewrite;

import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.Analyze;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.CallArgument;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.CreateMaterializedView;
import com.facebook.presto.sql.tree.CreateSchema;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Cube;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingSets;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.RefreshMaterializedView;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Return;
import com.facebook.presto.sql.tree.Rollup;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.ShowStats;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class DefaultTreeRewriter<C>
extends AstVisitor<Node, C> {
    protected Node visitNode(Node node, C context) {
        return node;
    }

    protected Node visitExpression(Expression node, C context) {
        throw new UnsupportedOperationException("Not yet implemented: " + ((Object)((Object)this)).getClass().getSimpleName() + " for " + node.getClass().getName());
    }

    protected Node visitAddColumn(AddColumn node, C context) {
        Node column = (Node)this.process((Node)node.getColumn(), context);
        if (node.getColumn() == column) {
            return node;
        }
        return new AddColumn(node.getName(), (ColumnDefinition)column, node.isTableExists(), node.isColumnNotExists());
    }

    protected Node visitAliasedRelation(AliasedRelation node, C context) {
        Node relation = (Node)this.process((Node)node.getRelation(), context);
        Node alias = (Node)this.process((Node)node.getAlias(), context);
        List columnNames = this.process(node.getColumnNames(), context);
        if (node.getRelation() == relation && node.getAlias() == alias && DefaultTreeRewriter.sameElements(node.getColumnNames(), columnNames)) {
            return node;
        }
        return new AliasedRelation((Relation)relation, (Identifier)alias, columnNames);
    }

    protected Node visitAnalyze(Analyze node, C context) {
        List properties = this.process(node.getProperties(), context);
        if (DefaultTreeRewriter.sameElements(node.getProperties(), properties)) {
            return node;
        }
        return new Analyze(node.getTableName(), properties);
    }

    protected Node visitCall(Call node, C context) {
        List arguments = this.process(node.getArguments(), context);
        if (DefaultTreeRewriter.sameElements(node.getArguments(), arguments)) {
            return node;
        }
        return new Call(node.getName(), arguments);
    }

    protected Node visitCallArgument(CallArgument node, C context) {
        Node value = (Node)this.process((Node)node.getValue(), context);
        if (node.getValue() == value) {
            return node;
        }
        return node.getName().isPresent() ? new CallArgument((String)node.getName().get(), (Expression)value) : new CallArgument((Expression)value);
    }

    protected Node visitColumnDefinition(ColumnDefinition node, C context) {
        Node name = (Node)this.process((Node)node.getName(), context);
        List properties = this.process(node.getProperties(), context);
        if (node.getName() == name && DefaultTreeRewriter.sameElements(node.getProperties(), properties)) {
            return node;
        }
        return new ColumnDefinition((Identifier)name, node.getType(), node.isNullable(), properties, node.getComment());
    }

    protected Node visitCreateMaterializedView(CreateMaterializedView node, C context) {
        Node query = (Node)this.process((Node)node.getQuery(), context);
        List properties = this.process(node.getProperties(), context);
        if (node.getQuery() == query && node.getProperties() == properties) {
            return node;
        }
        return new CreateMaterializedView(node.getName(), (Query)query, node.isNotExists(), properties, node.getComment());
    }

    protected Node visitCreateSchema(CreateSchema node, C context) {
        List properties = this.process(node.getProperties(), context);
        if (DefaultTreeRewriter.sameElements(node.getProperties(), properties)) {
            return node;
        }
        return new CreateSchema(node.getSchemaName(), node.isNotExists(), properties);
    }

    protected Node visitCreateTable(CreateTable node, C context) {
        List elements = this.process(node.getElements(), context);
        List properties = this.process(node.getProperties(), context);
        if (DefaultTreeRewriter.sameElements(node.getElements(), elements) && DefaultTreeRewriter.sameElements(node.getProperties(), properties)) {
            return node;
        }
        return new CreateTable(node.getName(), elements, node.isNotExists(), properties, node.getComment());
    }

    protected Node visitCreateTableAsSelect(CreateTableAsSelect node, C context) {
        Node query = (Node)this.process((Node)node.getQuery(), context);
        List properties = this.process(node.getProperties(), context);
        Optional<List> columnAliases = node.getColumnAliases().map(aliases -> this.process((List)aliases, context));
        if (node.getQuery() == query && node.getProperties() == properties && (!columnAliases.isPresent() || DefaultTreeRewriter.sameElements((Iterable)node.getColumnAliases().get(), columnAliases.get()))) {
            return node;
        }
        return new CreateTableAsSelect(node.getName(), (Query)query, node.isNotExists(), properties, node.isWithData(), node.getColumnAliases(), node.getComment());
    }

    protected Node visitCreateView(CreateView node, C context) {
        Node query = (Node)this.process((Node)node.getQuery(), context);
        if (node.getQuery() == query) {
            return node;
        }
        return new CreateView(node.getName(), (Query)query, node.isReplace(), node.getSecurity());
    }

    protected Node visitCube(Cube node, C context) {
        List expressions = this.process(node.getExpressions(), context);
        if (DefaultTreeRewriter.sameElements(node.getExpressions(), expressions)) {
            return node;
        }
        return new Cube(expressions);
    }

    protected Node visitDeallocate(Deallocate node, C context) {
        Node name = (Node)this.process((Node)node.getName(), context);
        if (node.getName() == name) {
            return node;
        }
        return new Deallocate((Identifier)name);
    }

    protected Node visitDelete(Delete node, C context) {
        Node table = (Node)this.process((Node)node.getTable(), context);
        Optional where = this.process(node.getWhere(), context);
        if (node.getTable() == table && DefaultTreeRewriter.sameElement(node.getWhere(), where)) {
            return node;
        }
        return new Delete((Table)table, where);
    }

    protected Node visitExcept(Except node, C context) {
        Node left = (Node)this.process((Node)node.getLeft(), context);
        Node right = (Node)this.process((Node)node.getRight(), context);
        if (node.getLeft() == left && node.getRight() == right) {
            return node;
        }
        return new Except((Relation)left, (Relation)right, node.isDistinct());
    }

    protected Node visitExecute(Execute node, C context) {
        Node name = (Node)this.process((Node)node.getName(), context);
        List parameters = this.process(node.getParameters(), context);
        if (node.getName() == name && DefaultTreeRewriter.sameElements(node.getParameters(), parameters)) {
            return node;
        }
        return new Execute(node.getName(), parameters);
    }

    protected Node visitExplain(Explain node, C context) {
        Node statement = (Node)this.process((Node)node.getStatement(), context);
        if (node.getStatement() == statement) {
            return node;
        }
        return new Explain((Statement)statement, node.isAnalyze(), node.isVerbose(), node.getOptions());
    }

    protected Node visitFrameBound(FrameBound node, C context) {
        Optional value = this.process(node.getValue(), context);
        if (DefaultTreeRewriter.sameElement(node.getValue(), value)) {
            return node;
        }
        return value.isPresent() ? new FrameBound(node.getType(), (Expression)value.get()) : new FrameBound(node.getType());
    }

    protected Node visitGroupBy(GroupBy node, C context) {
        List groupingElements = this.process(node.getGroupingElements(), context);
        if (DefaultTreeRewriter.sameElements(node.getGroupingElements(), groupingElements)) {
            return node;
        }
        return new GroupBy(node.isDistinct(), groupingElements);
    }

    protected Node visitGroupingSets(GroupingSets node, C context) {
        List sets = (List)node.getSets().stream().map(expressionList -> this.process((List)expressionList, context)).collect(ImmutableList.toImmutableList());
        if (DefaultTreeRewriter.sameElements(node.getSets(), sets)) {
            return node;
        }
        return new GroupingSets(sets);
    }

    protected Node visitInsert(Insert node, C context) {
        Node query = (Node)this.process((Node)node.getQuery(), context);
        Optional<List> columns = node.getColumns().map(columnList -> this.process((List)columnList, context));
        if (node.getQuery() == query && (!columns.isPresent() || DefaultTreeRewriter.sameElements((Iterable)node.getColumns().get(), columns.get()))) {
            return node;
        }
        return new Insert(node.getTarget(), columns, (Query)query);
    }

    protected Node visitIntersect(Intersect node, C context) {
        List relations = this.process(node.getRelations(), context);
        if (DefaultTreeRewriter.sameElements(node.getRelations(), relations)) {
            return node;
        }
        return new Intersect(relations, node.isDistinct());
    }

    protected Node visitJoin(Join node, C context) {
        Node left = (Node)this.process((Node)node.getLeft(), context);
        Node right = (Node)this.process((Node)node.getRight(), context);
        Optional<JoinCriteria> joinCriteria = node.getCriteria().map(criteria -> {
            if (criteria instanceof JoinOn) {
                Node expression = (Node)this.process((Node)((JoinOn)criteria).getExpression(), context);
                if (((JoinOn)criteria).getExpression() == expression) {
                    return criteria;
                }
                return new JoinOn((Expression)expression);
            }
            return criteria;
        });
        if (node.getLeft() == left && node.getRight() == right && node.getCriteria() == joinCriteria) {
            return node;
        }
        return new Join(node.getType(), (Relation)left, (Relation)right, joinCriteria);
    }

    protected Node visitLateral(Lateral node, C context) {
        Node query = (Node)this.process((Node)node.getQuery(), context);
        if (node.getQuery() == query) {
            return node;
        }
        return new Lateral((Query)query);
    }

    protected Node visitOrderBy(OrderBy node, C context) {
        List sortItems = this.process(node.getSortItems(), context);
        if (DefaultTreeRewriter.sameElements(node.getSortItems(), sortItems)) {
            return node;
        }
        return new OrderBy(sortItems);
    }

    protected Node visitPrepare(Prepare node, C context) {
        Node statement = (Node)this.process((Node)node.getStatement(), context);
        if (node.getStatement() == statement) {
            return node;
        }
        return new Prepare(node.getName(), (Statement)statement);
    }

    protected Node visitProperty(Property node, C context) {
        Node name = (Node)this.process((Node)node.getName(), context);
        Node value = (Node)this.process((Node)node.getValue(), context);
        if (node.getName() == name && node.getValue() == value) {
            return node;
        }
        return new Property((Identifier)name, (Expression)value);
    }

    protected Node visitQuery(Query node, C context) {
        Optional with = this.process(node.getWith(), context);
        Node queryBody = (Node)this.process((Node)node.getQueryBody(), context);
        Optional orderBy = this.process(node.getOrderBy(), context);
        if (node.getQueryBody() == queryBody && DefaultTreeRewriter.sameElement(node.getWith(), with) && DefaultTreeRewriter.sameElement(node.getOrderBy(), orderBy)) {
            return node;
        }
        return new Query(with, (QueryBody)queryBody, orderBy, node.getOffset(), node.getLimit());
    }

    protected Node visitQuerySpecification(QuerySpecification node, C context) {
        Node select = (Node)this.process((Node)node.getSelect(), context);
        Optional from = this.process(node.getFrom(), context);
        Optional where = this.process(node.getWhere(), context);
        Optional groupBy = this.process(node.getGroupBy(), context);
        Optional having = this.process(node.getHaving(), context);
        Optional orderBy = this.process(node.getOrderBy(), context);
        if (node.getSelect() == select && DefaultTreeRewriter.sameElement(node.getFrom(), from) && DefaultTreeRewriter.sameElement(node.getWhere(), where) && DefaultTreeRewriter.sameElement(node.getGroupBy(), groupBy) && DefaultTreeRewriter.sameElement(node.getHaving(), having) && DefaultTreeRewriter.sameElement(node.getOrderBy(), orderBy)) {
            return node;
        }
        return new QuerySpecification((Select)select, from, where, groupBy, having, orderBy, node.getOffset(), node.getLimit());
    }

    protected Node visitRefreshMaterializedView(RefreshMaterializedView node, C context) {
        Node table = (Node)this.process((Node)node.getTarget(), context);
        Node where = (Node)this.process((Node)node.getWhere(), context);
        if (node.getTarget() == table && node.getWhere() == where) {
            return node;
        }
        return new RefreshMaterializedView((Table)table, (Expression)where);
    }

    protected Node visitReturn(Return node, C context) {
        Node expression = (Node)this.process((Node)node.getExpression(), context);
        if (node.getExpression() == expression) {
            return node;
        }
        return new Return((Expression)expression);
    }

    protected Node visitRollup(Rollup node, C context) {
        List expressions = this.process(node.getExpressions(), context);
        if (DefaultTreeRewriter.sameElements(node.getExpressions(), expressions)) {
            return node;
        }
        return new Rollup(expressions);
    }

    protected Node visitRow(Row node, C context) {
        List items = this.process(node.getItems(), context);
        if (DefaultTreeRewriter.sameElements(node.getItems(), items)) {
            return node;
        }
        return new Row(items);
    }

    protected Node visitSampledRelation(SampledRelation node, C context) {
        Node relation = (Node)this.process((Node)node.getRelation(), context);
        Node samplePercentage = (Node)this.process((Node)node.getSamplePercentage(), context);
        if (node.getRelation() == relation && node.getSamplePercentage() == samplePercentage) {
            return node;
        }
        return new SampledRelation((Relation)relation, node.getType(), (Expression)samplePercentage);
    }

    protected Node visitSelect(Select node, C context) {
        List selectItems = this.process(node.getSelectItems(), context);
        if (DefaultTreeRewriter.sameElements(node.getSelectItems(), selectItems)) {
            return node;
        }
        return new Select(node.isDistinct(), selectItems);
    }

    protected Node visitShowStats(ShowStats node, C context) {
        Node relation = (Node)this.process((Node)node.getRelation(), context);
        if (node.getRelation() == relation) {
            return node;
        }
        return new ShowStats((Relation)relation);
    }

    protected Node visitSimpleGroupBy(SimpleGroupBy node, C context) {
        List columns = this.process(node.getExpressions(), context);
        if (DefaultTreeRewriter.sameElements(node.getExpressions(), columns)) {
            return node;
        }
        return new SimpleGroupBy(columns);
    }

    protected Node visitSingleColumn(SingleColumn node, C context) {
        Node expression = (Node)this.process((Node)node.getExpression(), context);
        if (node.getExpression() == expression) {
            return node;
        }
        return new SingleColumn((Expression)expression, node.getAlias());
    }

    protected Node visitSortItem(SortItem node, C context) {
        Node sortKey = (Node)this.process((Node)node.getSortKey(), context);
        if (node.getSortKey() == sortKey) {
            return node;
        }
        return new SortItem((Expression)sortKey, node.getOrdering(), node.getNullOrdering());
    }

    protected Node visitTableSubquery(TableSubquery node, C context) {
        Node query = (Node)this.process((Node)node.getQuery(), context);
        if (node.getQuery() == query) {
            return node;
        }
        return new TableSubquery((Query)query);
    }

    protected Node visitUnion(Union node, C context) {
        List relations = this.process(node.getRelations(), context);
        if (DefaultTreeRewriter.sameElements(node.getRelations(), relations)) {
            return node;
        }
        return new Union(relations, node.isDistinct());
    }

    protected Node visitUnnest(Unnest node, C context) {
        List expressions = this.process(node.getExpressions(), context);
        if (DefaultTreeRewriter.sameElements(node.getExpressions(), expressions)) {
            return node;
        }
        return new Unnest(expressions, node.isWithOrdinality());
    }

    protected Node visitValues(Values node, C context) {
        List expressions = this.process(node.getRows(), context);
        if (DefaultTreeRewriter.sameElements(node.getRows(), expressions)) {
            return node;
        }
        return new Values(expressions);
    }

    protected Node visitWindow(Window node, C context) {
        List partitionBy = this.process(node.getPartitionBy(), context);
        Optional orderBy = this.process(node.getOrderBy(), context);
        Optional frame = this.process(node.getFrame(), context);
        if (DefaultTreeRewriter.sameElements(node.getPartitionBy(), partitionBy) && DefaultTreeRewriter.sameElement(node.getOrderBy(), orderBy) && DefaultTreeRewriter.sameElement(node.getFrame(), frame)) {
            return node;
        }
        return new Window(partitionBy, orderBy, frame);
    }

    protected Node visitWindowFrame(WindowFrame node, C context) {
        Node start = (Node)this.process((Node)node.getStart(), context);
        Optional end = this.process(node.getEnd(), context);
        if (node.getStart() == start && DefaultTreeRewriter.sameElement(node.getEnd(), end)) {
            return node;
        }
        return new WindowFrame(node.getType(), (FrameBound)start, end);
    }

    protected Node visitWith(With node, C context) {
        List queries = this.process(node.getQueries(), context);
        if (DefaultTreeRewriter.sameElements(node.getQueries(), queries)) {
            return node;
        }
        return new With(node.isRecursive(), queries);
    }

    protected Node visitWithQuery(WithQuery node, C context) {
        Node name = (Node)this.process((Node)node.getName(), context);
        Node query = (Node)this.process((Node)node.getQuery(), context);
        Optional<List> columnNames = node.getColumnNames().map(columnNamesList -> this.process((List)columnNamesList, context));
        if (node.getName() == name && node.getQuery() == query && DefaultTreeRewriter.sameElement(node.getColumnNames(), columnNames)) {
            return node;
        }
        return new WithQuery(node.getName(), (Query)query, node.getColumnNames());
    }

    private <T extends Node> List<T> process(List<T> elements, C context) {
        if (elements == null) {
            return null;
        }
        List result = (List)elements.stream().map(element -> (Node)this.process((Node)element, context)).collect(ImmutableList.toImmutableList());
        return DefaultTreeRewriter.sameElements(elements, result) ? elements : result;
    }

    private <T extends Node> Optional<T> process(Optional<T> element, C context) {
        if (element == null) {
            return null;
        }
        Optional<Node> result = element.map(e -> (Node)this.process((Node)e, context));
        return DefaultTreeRewriter.sameElement(element, result) ? element : result;
    }

    private static <T> boolean sameElement(Optional<T> a, Optional<T> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (!a.isPresent() && !b.isPresent()) {
            return true;
        }
        if (a.isPresent() != b.isPresent()) {
            return false;
        }
        return a.get() == b.get();
    }

    private static <T> boolean sameElements(Iterable<? extends T> a, Iterable<? extends T> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (Iterables.size(a) != Iterables.size(b)) {
            return false;
        }
        Iterator<T> first = a.iterator();
        Iterator<T> second = b.iterator();
        while (first.hasNext() && second.hasNext()) {
            if (first.next() == second.next()) continue;
            return false;
        }
        return true;
    }
}

